package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryXpackRelateDB invokes the hbase.QueryXpackRelateDB API synchronously
// api document: https://help.aliyun.com/api/hbase/queryxpackrelatedb.html
func (client *Client) QueryXpackRelateDB(request *QueryXpackRelateDBRequest) (response *QueryXpackRelateDBResponse, err error) {
	response = CreateQueryXpackRelateDBResponse()
	err = client.DoAction(request, response)
	return
}

// QueryXpackRelateDBWithChan invokes the hbase.QueryXpackRelateDB API asynchronously
// api document: https://help.aliyun.com/api/hbase/queryxpackrelatedb.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryXpackRelateDBWithChan(request *QueryXpackRelateDBRequest) (<-chan *QueryXpackRelateDBResponse, <-chan error) {
	responseChan := make(chan *QueryXpackRelateDBResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryXpackRelateDB(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryXpackRelateDBWithCallback invokes the hbase.QueryXpackRelateDB API asynchronously
// api document: https://help.aliyun.com/api/hbase/queryxpackrelatedb.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryXpackRelateDBWithCallback(request *QueryXpackRelateDBRequest, callback func(response *QueryXpackRelateDBResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryXpackRelateDBResponse
		var err error
		defer close(result)
		response, err = client.QueryXpackRelateDB(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryXpackRelateDBRequest is the request struct for api QueryXpackRelateDB
type QueryXpackRelateDBRequest struct {
	*requests.RpcRequest
	ClusterId    string `position:"Query" name:"ClusterId"`
	RelateDbType string `position:"Query" name:"RelateDbType"`
}

// QueryXpackRelateDBResponse is the response struct for api QueryXpackRelateDB
type QueryXpackRelateDBResponse struct {
	*responses.BaseResponse
	RequestId   string                          `json:"RequestId" xml:"RequestId"`
	ClusterList ClusterListInQueryXpackRelateDB `json:"ClusterList" xml:"ClusterList"`
}

// CreateQueryXpackRelateDBRequest creates a request to invoke QueryXpackRelateDB API
func CreateQueryXpackRelateDBRequest() (request *QueryXpackRelateDBRequest) {
	request = &QueryXpackRelateDBRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "QueryXpackRelateDB", "hbase", "openAPI")
	return
}

// CreateQueryXpackRelateDBResponse creates a response to parse from QueryXpackRelateDB response
func CreateQueryXpackRelateDBResponse() (response *QueryXpackRelateDBResponse) {
	response = &QueryXpackRelateDBResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
