package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchClearEdgeInstanceDeviceConfig invokes the iot.BatchClearEdgeInstanceDeviceConfig API synchronously
// api document: https://help.aliyun.com/api/iot/batchclearedgeinstancedeviceconfig.html
func (client *Client) BatchClearEdgeInstanceDeviceConfig(request *BatchClearEdgeInstanceDeviceConfigRequest) (response *BatchClearEdgeInstanceDeviceConfigResponse, err error) {
	response = CreateBatchClearEdgeInstanceDeviceConfigResponse()
	err = client.DoAction(request, response)
	return
}

// BatchClearEdgeInstanceDeviceConfigWithChan invokes the iot.BatchClearEdgeInstanceDeviceConfig API asynchronously
// api document: https://help.aliyun.com/api/iot/batchclearedgeinstancedeviceconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BatchClearEdgeInstanceDeviceConfigWithChan(request *BatchClearEdgeInstanceDeviceConfigRequest) (<-chan *BatchClearEdgeInstanceDeviceConfigResponse, <-chan error) {
	responseChan := make(chan *BatchClearEdgeInstanceDeviceConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchClearEdgeInstanceDeviceConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchClearEdgeInstanceDeviceConfigWithCallback invokes the iot.BatchClearEdgeInstanceDeviceConfig API asynchronously
// api document: https://help.aliyun.com/api/iot/batchclearedgeinstancedeviceconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BatchClearEdgeInstanceDeviceConfigWithCallback(request *BatchClearEdgeInstanceDeviceConfigRequest, callback func(response *BatchClearEdgeInstanceDeviceConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchClearEdgeInstanceDeviceConfigResponse
		var err error
		defer close(result)
		response, err = client.BatchClearEdgeInstanceDeviceConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchClearEdgeInstanceDeviceConfigRequest is the request struct for api BatchClearEdgeInstanceDeviceConfig
type BatchClearEdgeInstanceDeviceConfigRequest struct {
	*requests.RpcRequest
	InstanceId    string    `position:"Query" name:"InstanceId"`
	IotIds        *[]string `position:"Query" name:"IotIds"  type:"Repeated"`
	IotInstanceId string    `position:"Query" name:"IotInstanceId"`
}

// BatchClearEdgeInstanceDeviceConfigResponse is the response struct for api BatchClearEdgeInstanceDeviceConfig
type BatchClearEdgeInstanceDeviceConfigResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateBatchClearEdgeInstanceDeviceConfigRequest creates a request to invoke BatchClearEdgeInstanceDeviceConfig API
func CreateBatchClearEdgeInstanceDeviceConfigRequest() (request *BatchClearEdgeInstanceDeviceConfigRequest) {
	request = &BatchClearEdgeInstanceDeviceConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "BatchClearEdgeInstanceDeviceConfig", "iot", "openAPI")
	return
}

// CreateBatchClearEdgeInstanceDeviceConfigResponse creates a response to parse from BatchClearEdgeInstanceDeviceConfig response
func CreateBatchClearEdgeInstanceDeviceConfigResponse() (response *BatchClearEdgeInstanceDeviceConfigResponse) {
	response = &BatchClearEdgeInstanceDeviceConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
