package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetProductKeyListByName invokes the iot.GetProductKeyListByName API synchronously
// api document: https://help.aliyun.com/api/iot/getproductkeylistbyname.html
func (client *Client) GetProductKeyListByName(request *GetProductKeyListByNameRequest) (response *GetProductKeyListByNameResponse, err error) {
	response = CreateGetProductKeyListByNameResponse()
	err = client.DoAction(request, response)
	return
}

// GetProductKeyListByNameWithChan invokes the iot.GetProductKeyListByName API asynchronously
// api document: https://help.aliyun.com/api/iot/getproductkeylistbyname.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetProductKeyListByNameWithChan(request *GetProductKeyListByNameRequest) (<-chan *GetProductKeyListByNameResponse, <-chan error) {
	responseChan := make(chan *GetProductKeyListByNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetProductKeyListByName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetProductKeyListByNameWithCallback invokes the iot.GetProductKeyListByName API asynchronously
// api document: https://help.aliyun.com/api/iot/getproductkeylistbyname.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetProductKeyListByNameWithCallback(request *GetProductKeyListByNameRequest, callback func(response *GetProductKeyListByNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetProductKeyListByNameResponse
		var err error
		defer close(result)
		response, err = client.GetProductKeyListByName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetProductKeyListByNameRequest is the request struct for api GetProductKeyListByName
type GetProductKeyListByNameRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	IotInstanceId   string `position:"Query" name:"IotInstanceId"`
	ProductName     string `position:"Query" name:"ProductName"`
	Page            string `position:"Query" name:"Page"`
}

// GetProductKeyListByNameResponse is the response struct for api GetProductKeyListByName
type GetProductKeyListByNameResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Code         string `json:"Code" xml:"Code"`
	Data         string `json:"Data" xml:"Data"`
}

// CreateGetProductKeyListByNameRequest creates a request to invoke GetProductKeyListByName API
func CreateGetProductKeyListByNameRequest() (request *GetProductKeyListByNameRequest) {
	request = &GetProductKeyListByNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "GetProductKeyListByName", "iot", "openAPI")
	return
}

// CreateGetProductKeyListByNameResponse creates a response to parse from GetProductKeyListByName response
func CreateGetProductKeyListByNameResponse() (response *GetProductKeyListByNameResponse) {
	response = &GetProductKeyListByNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
