package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddCasterEpisode invokes the live.AddCasterEpisode API synchronously
// api document: https://help.aliyun.com/api/live/addcasterepisode.html
func (client *Client) AddCasterEpisode(request *AddCasterEpisodeRequest) (response *AddCasterEpisodeResponse, err error) {
	response = CreateAddCasterEpisodeResponse()
	err = client.DoAction(request, response)
	return
}

// AddCasterEpisodeWithChan invokes the live.AddCasterEpisode API asynchronously
// api document: https://help.aliyun.com/api/live/addcasterepisode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddCasterEpisodeWithChan(request *AddCasterEpisodeRequest) (<-chan *AddCasterEpisodeResponse, <-chan error) {
	responseChan := make(chan *AddCasterEpisodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddCasterEpisode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddCasterEpisodeWithCallback invokes the live.AddCasterEpisode API asynchronously
// api document: https://help.aliyun.com/api/live/addcasterepisode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddCasterEpisodeWithCallback(request *AddCasterEpisodeRequest, callback func(response *AddCasterEpisodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddCasterEpisodeResponse
		var err error
		defer close(result)
		response, err = client.AddCasterEpisode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddCasterEpisodeRequest is the request struct for api AddCasterEpisode
type AddCasterEpisodeRequest struct {
	*requests.RpcRequest
	EpisodeName string           `position:"Query" name:"EpisodeName"`
	StartTime   string           `position:"Query" name:"StartTime"`
	ResourceId  string           `position:"Query" name:"ResourceId"`
	ComponentId *[]string        `position:"Query" name:"ComponentId"  type:"Repeated"`
	CasterId    string           `position:"Query" name:"CasterId"`
	EpisodeType string           `position:"Query" name:"EpisodeType"`
	EndTime     string           `position:"Query" name:"EndTime"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	SwitchType  string           `position:"Query" name:"SwitchType"`
}

// AddCasterEpisodeResponse is the response struct for api AddCasterEpisode
type AddCasterEpisodeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	EpisodeId string `json:"EpisodeId" xml:"EpisodeId"`
}

// CreateAddCasterEpisodeRequest creates a request to invoke AddCasterEpisode API
func CreateAddCasterEpisodeRequest() (request *AddCasterEpisodeRequest) {
	request = &AddCasterEpisodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "AddCasterEpisode", "live", "openAPI")
	return
}

// CreateAddCasterEpisodeResponse creates a response to parse from AddCasterEpisode response
func CreateAddCasterEpisodeResponse() (response *AddCasterEpisodeResponse) {
	response = &AddCasterEpisodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
