package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListLiveRealtimeLogDeliveryInfos invokes the live.ListLiveRealtimeLogDeliveryInfos API synchronously
// api document: https://help.aliyun.com/api/live/listliverealtimelogdeliveryinfos.html
func (client *Client) ListLiveRealtimeLogDeliveryInfos(request *ListLiveRealtimeLogDeliveryInfosRequest) (response *ListLiveRealtimeLogDeliveryInfosResponse, err error) {
	response = CreateListLiveRealtimeLogDeliveryInfosResponse()
	err = client.DoAction(request, response)
	return
}

// ListLiveRealtimeLogDeliveryInfosWithChan invokes the live.ListLiveRealtimeLogDeliveryInfos API asynchronously
// api document: https://help.aliyun.com/api/live/listliverealtimelogdeliveryinfos.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListLiveRealtimeLogDeliveryInfosWithChan(request *ListLiveRealtimeLogDeliveryInfosRequest) (<-chan *ListLiveRealtimeLogDeliveryInfosResponse, <-chan error) {
	responseChan := make(chan *ListLiveRealtimeLogDeliveryInfosResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListLiveRealtimeLogDeliveryInfos(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListLiveRealtimeLogDeliveryInfosWithCallback invokes the live.ListLiveRealtimeLogDeliveryInfos API asynchronously
// api document: https://help.aliyun.com/api/live/listliverealtimelogdeliveryinfos.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListLiveRealtimeLogDeliveryInfosWithCallback(request *ListLiveRealtimeLogDeliveryInfosRequest, callback func(response *ListLiveRealtimeLogDeliveryInfosResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListLiveRealtimeLogDeliveryInfosResponse
		var err error
		defer close(result)
		response, err = client.ListLiveRealtimeLogDeliveryInfos(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListLiveRealtimeLogDeliveryInfosRequest is the request struct for api ListLiveRealtimeLogDeliveryInfos
type ListLiveRealtimeLogDeliveryInfosRequest struct {
	*requests.RpcRequest
	OwnerId            requests.Integer `position:"Query" name:"OwnerId"`
	LiveOpenapiReserve string           `position:"Query" name:"LiveOpenapiReserve"`
}

// ListLiveRealtimeLogDeliveryInfosResponse is the response struct for api ListLiveRealtimeLogDeliveryInfos
type ListLiveRealtimeLogDeliveryInfosResponse struct {
	*responses.BaseResponse
	RequestId string                                    `json:"RequestId" xml:"RequestId"`
	Content   ContentInListLiveRealtimeLogDeliveryInfos `json:"Content" xml:"Content"`
}

// CreateListLiveRealtimeLogDeliveryInfosRequest creates a request to invoke ListLiveRealtimeLogDeliveryInfos API
func CreateListLiveRealtimeLogDeliveryInfosRequest() (request *ListLiveRealtimeLogDeliveryInfosRequest) {
	request = &ListLiveRealtimeLogDeliveryInfosRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "ListLiveRealtimeLogDeliveryInfos", "live", "openAPI")
	return
}

// CreateListLiveRealtimeLogDeliveryInfosResponse creates a response to parse from ListLiveRealtimeLogDeliveryInfos response
func CreateListLiveRealtimeLogDeliveryInfosResponse() (response *ListLiveRealtimeLogDeliveryInfosResponse) {
	response = &ListLiveRealtimeLogDeliveryInfosResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
