package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryFpImportResult invokes the mts.QueryFpImportResult API synchronously
// api document: https://help.aliyun.com/api/mts/queryfpimportresult.html
func (client *Client) QueryFpImportResult(request *QueryFpImportResultRequest) (response *QueryFpImportResultResponse, err error) {
	response = CreateQueryFpImportResultResponse()
	err = client.DoAction(request, response)
	return
}

// QueryFpImportResultWithChan invokes the mts.QueryFpImportResult API asynchronously
// api document: https://help.aliyun.com/api/mts/queryfpimportresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryFpImportResultWithChan(request *QueryFpImportResultRequest) (<-chan *QueryFpImportResultResponse, <-chan error) {
	responseChan := make(chan *QueryFpImportResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryFpImportResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryFpImportResultWithCallback invokes the mts.QueryFpImportResult API asynchronously
// api document: https://help.aliyun.com/api/mts/queryfpimportresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryFpImportResultWithCallback(request *QueryFpImportResultRequest, callback func(response *QueryFpImportResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryFpImportResultResponse
		var err error
		defer close(result)
		response, err = client.QueryFpImportResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryFpImportResultRequest is the request struct for api QueryFpImportResult
type QueryFpImportResultRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	EndTime              requests.Integer `position:"Query" name:"EndTime"`
	PageIndex            requests.Integer `position:"Query" name:"PageIndex"`
	StartTime            requests.Integer `position:"Query" name:"StartTime"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// QueryFpImportResultResponse is the response struct for api QueryFpImportResult
type QueryFpImportResultResponse struct {
	*responses.BaseResponse
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	LogCount            int64               `json:"LogCount" xml:"LogCount"`
	PageInfo            PageInfo            `json:"PageInfo" xml:"PageInfo"`
	FpResultLogInfoList FpResultLogInfoList `json:"FpResultLogInfoList" xml:"FpResultLogInfoList"`
}

// CreateQueryFpImportResultRequest creates a request to invoke QueryFpImportResult API
func CreateQueryFpImportResultRequest() (request *QueryFpImportResultRequest) {
	request = &QueryFpImportResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "QueryFpImportResult", "mts", "openAPI")
	return
}

// CreateQueryFpImportResultResponse creates a response to parse from QueryFpImportResult response
func CreateQueryFpImportResultResponse() (response *QueryFpImportResultResponse) {
	response = &QueryFpImportResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
