package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CloseDBClusterMigration invokes the polardb.CloseDBClusterMigration API synchronously
// api document: https://help.aliyun.com/api/polardb/closedbclustermigration.html
func (client *Client) CloseDBClusterMigration(request *CloseDBClusterMigrationRequest) (response *CloseDBClusterMigrationResponse, err error) {
	response = CreateCloseDBClusterMigrationResponse()
	err = client.DoAction(request, response)
	return
}

// CloseDBClusterMigrationWithChan invokes the polardb.CloseDBClusterMigration API asynchronously
// api document: https://help.aliyun.com/api/polardb/closedbclustermigration.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CloseDBClusterMigrationWithChan(request *CloseDBClusterMigrationRequest) (<-chan *CloseDBClusterMigrationResponse, <-chan error) {
	responseChan := make(chan *CloseDBClusterMigrationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CloseDBClusterMigration(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CloseDBClusterMigrationWithCallback invokes the polardb.CloseDBClusterMigration API asynchronously
// api document: https://help.aliyun.com/api/polardb/closedbclustermigration.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CloseDBClusterMigrationWithCallback(request *CloseDBClusterMigrationRequest, callback func(response *CloseDBClusterMigrationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CloseDBClusterMigrationResponse
		var err error
		defer close(result)
		response, err = client.CloseDBClusterMigration(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CloseDBClusterMigrationRequest is the request struct for api CloseDBClusterMigration
type CloseDBClusterMigrationRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ContinueEnableBinlog requests.Boolean `position:"Query" name:"ContinueEnableBinlog"`
}

// CloseDBClusterMigrationResponse is the response struct for api CloseDBClusterMigration
type CloseDBClusterMigrationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCloseDBClusterMigrationRequest creates a request to invoke CloseDBClusterMigration API
func CreateCloseDBClusterMigrationRequest() (request *CloseDBClusterMigrationRequest) {
	request = &CloseDBClusterMigrationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "CloseDBClusterMigration", "polardb", "openAPI")
	return
}

// CreateCloseDBClusterMigrationResponse creates a response to parse from CloseDBClusterMigration response
func CreateCloseDBClusterMigrationResponse() (response *CloseDBClusterMigrationResponse) {
	response = &CloseDBClusterMigrationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
