package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfigDataSet invokes the qualitycheck.ConfigDataSet API synchronously
// api document: https://help.aliyun.com/api/qualitycheck/configdataset.html
func (client *Client) ConfigDataSet(request *ConfigDataSetRequest) (response *ConfigDataSetResponse, err error) {
	response = CreateConfigDataSetResponse()
	err = client.DoAction(request, response)
	return
}

// ConfigDataSetWithChan invokes the qualitycheck.ConfigDataSet API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/configdataset.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ConfigDataSetWithChan(request *ConfigDataSetRequest) (<-chan *ConfigDataSetResponse, <-chan error) {
	responseChan := make(chan *ConfigDataSetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfigDataSet(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfigDataSetWithCallback invokes the qualitycheck.ConfigDataSet API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/configdataset.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ConfigDataSetWithCallback(request *ConfigDataSetRequest, callback func(response *ConfigDataSetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfigDataSetResponse
		var err error
		defer close(result)
		response, err = client.ConfigDataSet(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfigDataSetRequest is the request struct for api ConfigDataSet
type ConfigDataSetRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// ConfigDataSetResponse is the response struct for api ConfigDataSet
type ConfigDataSetResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateConfigDataSetRequest creates a request to invoke ConfigDataSet API
func CreateConfigDataSetRequest() (request *ConfigDataSetRequest) {
	request = &ConfigDataSetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "ConfigDataSet", "", "")
	return
}

// CreateConfigDataSetResponse creates a response to parse from ConfigDataSet response
func CreateConfigDataSetResponse() (response *ConfigDataSetResponse) {
	response = &ConfigDataSetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
