package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTaskFileResultList invokes the qualitycheck.GetTaskFileResultList API synchronously
// api document: https://help.aliyun.com/api/qualitycheck/gettaskfileresultlist.html
func (client *Client) GetTaskFileResultList(request *GetTaskFileResultListRequest) (response *GetTaskFileResultListResponse, err error) {
	response = CreateGetTaskFileResultListResponse()
	err = client.DoAction(request, response)
	return
}

// GetTaskFileResultListWithChan invokes the qualitycheck.GetTaskFileResultList API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/gettaskfileresultlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetTaskFileResultListWithChan(request *GetTaskFileResultListRequest) (<-chan *GetTaskFileResultListResponse, <-chan error) {
	responseChan := make(chan *GetTaskFileResultListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTaskFileResultList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTaskFileResultListWithCallback invokes the qualitycheck.GetTaskFileResultList API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/gettaskfileresultlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetTaskFileResultListWithCallback(request *GetTaskFileResultListRequest, callback func(response *GetTaskFileResultListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTaskFileResultListResponse
		var err error
		defer close(result)
		response, err = client.GetTaskFileResultList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTaskFileResultListRequest is the request struct for api GetTaskFileResultList
type GetTaskFileResultListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// GetTaskFileResultListResponse is the response struct for api GetTaskFileResultList
type GetTaskFileResultListResponse struct {
	*responses.BaseResponse
	RequestId  string                      `json:"RequestId" xml:"RequestId"`
	Success    bool                        `json:"Success" xml:"Success"`
	Code       string                      `json:"Code" xml:"Code"`
	Message    string                      `json:"Message" xml:"Message"`
	PageSize   int                         `json:"PageSize" xml:"PageSize"`
	DataSize   int                         `json:"DataSize" xml:"DataSize"`
	TotalCount int                         `json:"TotalCount" xml:"TotalCount"`
	Data       DataInGetTaskFileResultList `json:"Data" xml:"Data"`
}

// CreateGetTaskFileResultListRequest creates a request to invoke GetTaskFileResultList API
func CreateGetTaskFileResultListRequest() (request *GetTaskFileResultListRequest) {
	request = &GetTaskFileResultListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "GetTaskFileResultList", "", "")
	return
}

// CreateGetTaskFileResultListResponse creates a response to parse from GetTaskFileResultList response
func CreateGetTaskFileResultListResponse() (response *GetTaskFileResultListResponse) {
	response = &GetTaskFileResultListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
