package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyInstanceSSL invokes the r_kvstore.ModifyInstanceSSL API synchronously
// api document: https://help.aliyun.com/api/r-kvstore/modifyinstancessl.html
func (client *Client) ModifyInstanceSSL(request *ModifyInstanceSSLRequest) (response *ModifyInstanceSSLResponse, err error) {
	response = CreateModifyInstanceSSLResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyInstanceSSLWithChan invokes the r_kvstore.ModifyInstanceSSL API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/modifyinstancessl.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyInstanceSSLWithChan(request *ModifyInstanceSSLRequest) (<-chan *ModifyInstanceSSLResponse, <-chan error) {
	responseChan := make(chan *ModifyInstanceSSLResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyInstanceSSL(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyInstanceSSLWithCallback invokes the r_kvstore.ModifyInstanceSSL API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/modifyinstancessl.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyInstanceSSLWithCallback(request *ModifyInstanceSSLRequest, callback func(response *ModifyInstanceSSLResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyInstanceSSLResponse
		var err error
		defer close(result)
		response, err = client.ModifyInstanceSSL(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyInstanceSSLRequest is the request struct for api ModifyInstanceSSL
type ModifyInstanceSSLRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	SSLEnabled           string           `position:"Query" name:"SSLEnabled"`
}

// ModifyInstanceSSLResponse is the response struct for api ModifyInstanceSSL
type ModifyInstanceSSLResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	InstanceId string `json:"InstanceId" xml:"InstanceId"`
	TaskId     string `json:"TaskId" xml:"TaskId"`
}

// CreateModifyInstanceSSLRequest creates a request to invoke ModifyInstanceSSL API
func CreateModifyInstanceSSLRequest() (request *ModifyInstanceSSLRequest) {
	request = &ModifyInstanceSSLRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "ModifyInstanceSSL", "", "")
	return
}

// CreateModifyInstanceSSLResponse creates a response to parse from ModifyInstanceSSL response
func CreateModifyInstanceSSLResponse() (response *ModifyInstanceSSLResponse) {
	response = &ModifyInstanceSSLResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
