package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddNetworkOptimizationSetting invokes the smartag.AddNetworkOptimizationSetting API synchronously
// api document: https://help.aliyun.com/api/smartag/addnetworkoptimizationsetting.html
func (client *Client) AddNetworkOptimizationSetting(request *AddNetworkOptimizationSettingRequest) (response *AddNetworkOptimizationSettingResponse, err error) {
	response = CreateAddNetworkOptimizationSettingResponse()
	err = client.DoAction(request, response)
	return
}

// AddNetworkOptimizationSettingWithChan invokes the smartag.AddNetworkOptimizationSetting API asynchronously
// api document: https://help.aliyun.com/api/smartag/addnetworkoptimizationsetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddNetworkOptimizationSettingWithChan(request *AddNetworkOptimizationSettingRequest) (<-chan *AddNetworkOptimizationSettingResponse, <-chan error) {
	responseChan := make(chan *AddNetworkOptimizationSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddNetworkOptimizationSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddNetworkOptimizationSettingWithCallback invokes the smartag.AddNetworkOptimizationSetting API asynchronously
// api document: https://help.aliyun.com/api/smartag/addnetworkoptimizationsetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddNetworkOptimizationSettingWithCallback(request *AddNetworkOptimizationSettingRequest, callback func(response *AddNetworkOptimizationSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddNetworkOptimizationSettingResponse
		var err error
		defer close(result)
		response, err = client.AddNetworkOptimizationSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddNetworkOptimizationSettingRequest is the request struct for api AddNetworkOptimizationSetting
type AddNetworkOptimizationSettingRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Type                 string           `position:"Query" name:"Type"`
	NetworkOptId         string           `position:"Query" name:"NetworkOptId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Domain               string           `position:"Query" name:"Domain"`
}

// AddNetworkOptimizationSettingResponse is the response struct for api AddNetworkOptimizationSetting
type AddNetworkOptimizationSettingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddNetworkOptimizationSettingRequest creates a request to invoke AddNetworkOptimizationSetting API
func CreateAddNetworkOptimizationSettingRequest() (request *AddNetworkOptimizationSettingRequest) {
	request = &AddNetworkOptimizationSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "AddNetworkOptimizationSetting", "smartag", "openAPI")
	return
}

// CreateAddNetworkOptimizationSettingResponse creates a response to parse from AddNetworkOptimizationSetting response
func CreateAddNetworkOptimizationSettingResponse() (response *AddNetworkOptimizationSettingResponse) {
	response = &AddNetworkOptimizationSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
