package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBindableSmartAccessGateways invokes the smartag.DescribeBindableSmartAccessGateways API synchronously
// api document: https://help.aliyun.com/api/smartag/describebindablesmartaccessgateways.html
func (client *Client) DescribeBindableSmartAccessGateways(request *DescribeBindableSmartAccessGatewaysRequest) (response *DescribeBindableSmartAccessGatewaysResponse, err error) {
	response = CreateDescribeBindableSmartAccessGatewaysResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBindableSmartAccessGatewaysWithChan invokes the smartag.DescribeBindableSmartAccessGateways API asynchronously
// api document: https://help.aliyun.com/api/smartag/describebindablesmartaccessgateways.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeBindableSmartAccessGatewaysWithChan(request *DescribeBindableSmartAccessGatewaysRequest) (<-chan *DescribeBindableSmartAccessGatewaysResponse, <-chan error) {
	responseChan := make(chan *DescribeBindableSmartAccessGatewaysResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBindableSmartAccessGateways(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBindableSmartAccessGatewaysWithCallback invokes the smartag.DescribeBindableSmartAccessGateways API asynchronously
// api document: https://help.aliyun.com/api/smartag/describebindablesmartaccessgateways.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeBindableSmartAccessGatewaysWithCallback(request *DescribeBindableSmartAccessGatewaysRequest, callback func(response *DescribeBindableSmartAccessGatewaysResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBindableSmartAccessGatewaysResponse
		var err error
		defer close(result)
		response, err = client.DescribeBindableSmartAccessGateways(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBindableSmartAccessGatewaysRequest is the request struct for api DescribeBindableSmartAccessGateways
type DescribeBindableSmartAccessGatewaysRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CcnId                string           `position:"Query" name:"CcnId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	CrossAccount         requests.Boolean `position:"Query" name:"CrossAccount"`
}

// DescribeBindableSmartAccessGatewaysResponse is the response struct for api DescribeBindableSmartAccessGateways
type DescribeBindableSmartAccessGatewaysResponse struct {
	*responses.BaseResponse
	RequestId           string                                                   `json:"RequestId" xml:"RequestId"`
	TotalCount          int                                                      `json:"TotalCount" xml:"TotalCount"`
	PageNumber          int                                                      `json:"PageNumber" xml:"PageNumber"`
	PageSize            int                                                      `json:"PageSize" xml:"PageSize"`
	SmartAccessGateways SmartAccessGatewaysInDescribeBindableSmartAccessGateways `json:"SmartAccessGateways" xml:"SmartAccessGateways"`
}

// CreateDescribeBindableSmartAccessGatewaysRequest creates a request to invoke DescribeBindableSmartAccessGateways API
func CreateDescribeBindableSmartAccessGatewaysRequest() (request *DescribeBindableSmartAccessGatewaysRequest) {
	request = &DescribeBindableSmartAccessGatewaysRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DescribeBindableSmartAccessGateways", "smartag", "openAPI")
	return
}

// CreateDescribeBindableSmartAccessGatewaysResponse creates a response to parse from DescribeBindableSmartAccessGateways response
func CreateDescribeBindableSmartAccessGatewaysResponse() (response *DescribeBindableSmartAccessGatewaysResponse) {
	response = &DescribeBindableSmartAccessGatewaysResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
