package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePbrInterfaces invokes the smartag.DescribePbrInterfaces API synchronously
// api document: https://help.aliyun.com/api/smartag/describepbrinterfaces.html
func (client *Client) DescribePbrInterfaces(request *DescribePbrInterfacesRequest) (response *DescribePbrInterfacesResponse, err error) {
	response = CreateDescribePbrInterfacesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePbrInterfacesWithChan invokes the smartag.DescribePbrInterfaces API asynchronously
// api document: https://help.aliyun.com/api/smartag/describepbrinterfaces.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribePbrInterfacesWithChan(request *DescribePbrInterfacesRequest) (<-chan *DescribePbrInterfacesResponse, <-chan error) {
	responseChan := make(chan *DescribePbrInterfacesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePbrInterfaces(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePbrInterfacesWithCallback invokes the smartag.DescribePbrInterfaces API asynchronously
// api document: https://help.aliyun.com/api/smartag/describepbrinterfaces.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribePbrInterfacesWithCallback(request *DescribePbrInterfacesRequest, callback func(response *DescribePbrInterfacesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePbrInterfacesResponse
		var err error
		defer close(result)
		response, err = client.DescribePbrInterfaces(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePbrInterfacesRequest is the request struct for api DescribePbrInterfaces
type DescribePbrInterfacesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PbrInstanceId        string           `position:"Query" name:"PbrInstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribePbrInterfacesResponse is the response struct for api DescribePbrInterfaces
type DescribePbrInterfacesResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	TotalCount    int           `json:"TotalCount" xml:"TotalCount"`
	PbrInterfaces PbrInterfaces `json:"PbrInterfaces" xml:"PbrInterfaces"`
}

// CreateDescribePbrInterfacesRequest creates a request to invoke DescribePbrInterfaces API
func CreateDescribePbrInterfacesRequest() (request *DescribePbrInterfacesRequest) {
	request = &DescribePbrInterfacesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DescribePbrInterfaces", "smartag", "openAPI")
	return
}

// CreateDescribePbrInterfacesResponse creates a response to parse from DescribePbrInterfaces response
func CreateDescribePbrInterfacesResponse() (response *DescribePbrInterfacesResponse) {
	response = &DescribePbrInterfacesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
