package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// KickOutClients invokes the smartag.KickOutClients API synchronously
// api document: https://help.aliyun.com/api/smartag/kickoutclients.html
func (client *Client) KickOutClients(request *KickOutClientsRequest) (response *KickOutClientsResponse, err error) {
	response = CreateKickOutClientsResponse()
	err = client.DoAction(request, response)
	return
}

// KickOutClientsWithChan invokes the smartag.KickOutClients API asynchronously
// api document: https://help.aliyun.com/api/smartag/kickoutclients.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) KickOutClientsWithChan(request *KickOutClientsRequest) (<-chan *KickOutClientsResponse, <-chan error) {
	responseChan := make(chan *KickOutClientsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.KickOutClients(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// KickOutClientsWithCallback invokes the smartag.KickOutClients API asynchronously
// api document: https://help.aliyun.com/api/smartag/kickoutclients.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) KickOutClientsWithCallback(request *KickOutClientsRequest, callback func(response *KickOutClientsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *KickOutClientsResponse
		var err error
		defer close(result)
		response, err = client.KickOutClients(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// KickOutClientsRequest is the request struct for api KickOutClients
type KickOutClientsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	Username             string           `position:"Query" name:"Username"`
}

// KickOutClientsResponse is the response struct for api KickOutClients
type KickOutClientsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateKickOutClientsRequest creates a request to invoke KickOutClients API
func CreateKickOutClientsRequest() (request *KickOutClientsRequest) {
	request = &KickOutClientsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "KickOutClients", "smartag", "openAPI")
	return
}

// CreateKickOutClientsResponse creates a response to parse from KickOutClients response
func CreateKickOutClientsResponse() (response *KickOutClientsResponse) {
	response = &KickOutClientsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
