package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyRouteDistributionStrategy invokes the smartag.ModifyRouteDistributionStrategy API synchronously
// api document: https://help.aliyun.com/api/smartag/modifyroutedistributionstrategy.html
func (client *Client) ModifyRouteDistributionStrategy(request *ModifyRouteDistributionStrategyRequest) (response *ModifyRouteDistributionStrategyResponse, err error) {
	response = CreateModifyRouteDistributionStrategyResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyRouteDistributionStrategyWithChan invokes the smartag.ModifyRouteDistributionStrategy API asynchronously
// api document: https://help.aliyun.com/api/smartag/modifyroutedistributionstrategy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyRouteDistributionStrategyWithChan(request *ModifyRouteDistributionStrategyRequest) (<-chan *ModifyRouteDistributionStrategyResponse, <-chan error) {
	responseChan := make(chan *ModifyRouteDistributionStrategyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyRouteDistributionStrategy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyRouteDistributionStrategyWithCallback invokes the smartag.ModifyRouteDistributionStrategy API asynchronously
// api document: https://help.aliyun.com/api/smartag/modifyroutedistributionstrategy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyRouteDistributionStrategyWithCallback(request *ModifyRouteDistributionStrategyRequest, callback func(response *ModifyRouteDistributionStrategyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyRouteDistributionStrategyResponse
		var err error
		defer close(result)
		response, err = client.ModifyRouteDistributionStrategy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyRouteDistributionStrategyRequest is the request struct for api ModifyRouteDistributionStrategy
type ModifyRouteDistributionStrategyRequest struct {
	*requests.RpcRequest
	RouteSource          string           `position:"Query" name:"RouteSource"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	HcInstanceId         string           `position:"Query" name:"HcInstanceId"`
	SourceType           string           `position:"Query" name:"SourceType"`
	DestCidrBlock        string           `position:"Query" name:"DestCidrBlock"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	RouteDistribution    string           `position:"Query" name:"RouteDistribution"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
}

// ModifyRouteDistributionStrategyResponse is the response struct for api ModifyRouteDistributionStrategy
type ModifyRouteDistributionStrategyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyRouteDistributionStrategyRequest creates a request to invoke ModifyRouteDistributionStrategy API
func CreateModifyRouteDistributionStrategyRequest() (request *ModifyRouteDistributionStrategyRequest) {
	request = &ModifyRouteDistributionStrategyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "ModifyRouteDistributionStrategy", "smartag", "openAPI")
	return
}

// CreateModifyRouteDistributionStrategyResponse creates a response to parse from ModifyRouteDistributionStrategy response
func CreateModifyRouteDistributionStrategyResponse() (response *ModifyRouteDistributionStrategyResponse) {
	response = &ModifyRouteDistributionStrategyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
