package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifySagCidr invokes the smartag.ModifySagCidr API synchronously
// api document: https://help.aliyun.com/api/smartag/modifysagcidr.html
func (client *Client) ModifySagCidr(request *ModifySagCidrRequest) (response *ModifySagCidrResponse, err error) {
	response = CreateModifySagCidrResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySagCidrWithChan invokes the smartag.ModifySagCidr API asynchronously
// api document: https://help.aliyun.com/api/smartag/modifysagcidr.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifySagCidrWithChan(request *ModifySagCidrRequest) (<-chan *ModifySagCidrResponse, <-chan error) {
	responseChan := make(chan *ModifySagCidrResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifySagCidr(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySagCidrWithCallback invokes the smartag.ModifySagCidr API asynchronously
// api document: https://help.aliyun.com/api/smartag/modifysagcidr.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifySagCidrWithCallback(request *ModifySagCidrRequest, callback func(response *ModifySagCidrResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySagCidrResponse
		var err error
		defer close(result)
		response, err = client.ModifySagCidr(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySagCidrRequest is the request struct for api ModifySagCidr
type ModifySagCidrRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Cidr                 string           `position:"Query" name:"Cidr"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	EnableBackup         requests.Boolean `position:"Query" name:"EnableBackup"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
}

// ModifySagCidrResponse is the response struct for api ModifySagCidr
type ModifySagCidrResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifySagCidrRequest creates a request to invoke ModifySagCidr API
func CreateModifySagCidrRequest() (request *ModifySagCidrRequest) {
	request = &ModifySagCidrRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "ModifySagCidr", "smartag", "openAPI")
	return
}

// CreateModifySagCidrResponse creates a response to parse from ModifySagCidr response
func CreateModifySagCidrResponse() (response *ModifySagCidrResponse) {
	response = &ModifySagCidrResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
