package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpgradeSmartAccessGateway invokes the smartag.UpgradeSmartAccessGateway API synchronously
// api document: https://help.aliyun.com/api/smartag/upgradesmartaccessgateway.html
func (client *Client) UpgradeSmartAccessGateway(request *UpgradeSmartAccessGatewayRequest) (response *UpgradeSmartAccessGatewayResponse, err error) {
	response = CreateUpgradeSmartAccessGatewayResponse()
	err = client.DoAction(request, response)
	return
}

// UpgradeSmartAccessGatewayWithChan invokes the smartag.UpgradeSmartAccessGateway API asynchronously
// api document: https://help.aliyun.com/api/smartag/upgradesmartaccessgateway.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpgradeSmartAccessGatewayWithChan(request *UpgradeSmartAccessGatewayRequest) (<-chan *UpgradeSmartAccessGatewayResponse, <-chan error) {
	responseChan := make(chan *UpgradeSmartAccessGatewayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpgradeSmartAccessGateway(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpgradeSmartAccessGatewayWithCallback invokes the smartag.UpgradeSmartAccessGateway API asynchronously
// api document: https://help.aliyun.com/api/smartag/upgradesmartaccessgateway.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpgradeSmartAccessGatewayWithCallback(request *UpgradeSmartAccessGatewayRequest, callback func(response *UpgradeSmartAccessGatewayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpgradeSmartAccessGatewayResponse
		var err error
		defer close(result)
		response, err = client.UpgradeSmartAccessGateway(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpgradeSmartAccessGatewayRequest is the request struct for api UpgradeSmartAccessGateway
type UpgradeSmartAccessGatewayRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	BandWidthSpec        requests.Integer `position:"Query" name:"BandWidthSpec"`
	UserCount            requests.Integer `position:"Query" name:"UserCount"`
	AutoPay              requests.Boolean `position:"Query" name:"AutoPay"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	DataPlan             requests.Integer `position:"Query" name:"DataPlan"`
}

// UpgradeSmartAccessGatewayResponse is the response struct for api UpgradeSmartAccessGateway
type UpgradeSmartAccessGatewayResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	OrderId   string `json:"OrderId" xml:"OrderId"`
}

// CreateUpgradeSmartAccessGatewayRequest creates a request to invoke UpgradeSmartAccessGateway API
func CreateUpgradeSmartAccessGatewayRequest() (request *UpgradeSmartAccessGatewayRequest) {
	request = &UpgradeSmartAccessGatewayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "UpgradeSmartAccessGateway", "smartag", "openAPI")
	return
}

// CreateUpgradeSmartAccessGatewayResponse creates a response to parse from UpgradeSmartAccessGateway response
func CreateUpgradeSmartAccessGatewayResponse() (response *UpgradeSmartAccessGatewayResponse) {
	response = &UpgradeSmartAccessGatewayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
