package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteBgpGroup invokes the vpc.DeleteBgpGroup API synchronously
// api document: https://help.aliyun.com/api/vpc/deletebgpgroup.html
func (client *Client) DeleteBgpGroup(request *DeleteBgpGroupRequest) (response *DeleteBgpGroupResponse, err error) {
	response = CreateDeleteBgpGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteBgpGroupWithChan invokes the vpc.DeleteBgpGroup API asynchronously
// api document: https://help.aliyun.com/api/vpc/deletebgpgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteBgpGroupWithChan(request *DeleteBgpGroupRequest) (<-chan *DeleteBgpGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteBgpGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteBgpGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteBgpGroupWithCallback invokes the vpc.DeleteBgpGroup API asynchronously
// api document: https://help.aliyun.com/api/vpc/deletebgpgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteBgpGroupWithCallback(request *DeleteBgpGroupRequest, callback func(response *DeleteBgpGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteBgpGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteBgpGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteBgpGroupRequest is the request struct for api DeleteBgpGroup
type DeleteBgpGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	BgpGroupId           string           `position:"Query" name:"BgpGroupId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteBgpGroupResponse is the response struct for api DeleteBgpGroup
type DeleteBgpGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteBgpGroupRequest creates a request to invoke DeleteBgpGroup API
func CreateDeleteBgpGroupRequest() (request *DeleteBgpGroupRequest) {
	request = &DeleteBgpGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DeleteBgpGroup", "vpc", "openAPI")
	return
}

// CreateDeleteBgpGroupResponse creates a response to parse from DeleteBgpGroup response
func CreateDeleteBgpGroupResponse() (response *DeleteBgpGroupResponse) {
	response = &DeleteBgpGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
