package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableVpcClassicLink invokes the vpc.EnableVpcClassicLink API synchronously
// api document: https://help.aliyun.com/api/vpc/enablevpcclassiclink.html
func (client *Client) EnableVpcClassicLink(request *EnableVpcClassicLinkRequest) (response *EnableVpcClassicLinkResponse, err error) {
	response = CreateEnableVpcClassicLinkResponse()
	err = client.DoAction(request, response)
	return
}

// EnableVpcClassicLinkWithChan invokes the vpc.EnableVpcClassicLink API asynchronously
// api document: https://help.aliyun.com/api/vpc/enablevpcclassiclink.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) EnableVpcClassicLinkWithChan(request *EnableVpcClassicLinkRequest) (<-chan *EnableVpcClassicLinkResponse, <-chan error) {
	responseChan := make(chan *EnableVpcClassicLinkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableVpcClassicLink(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableVpcClassicLinkWithCallback invokes the vpc.EnableVpcClassicLink API asynchronously
// api document: https://help.aliyun.com/api/vpc/enablevpcclassiclink.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) EnableVpcClassicLinkWithCallback(request *EnableVpcClassicLinkRequest, callback func(response *EnableVpcClassicLinkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableVpcClassicLinkResponse
		var err error
		defer close(result)
		response, err = client.EnableVpcClassicLink(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableVpcClassicLinkRequest is the request struct for api EnableVpcClassicLink
type EnableVpcClassicLinkRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	VpcId                string           `position:"Query" name:"VpcId"`
}

// EnableVpcClassicLinkResponse is the response struct for api EnableVpcClassicLink
type EnableVpcClassicLinkResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEnableVpcClassicLinkRequest creates a request to invoke EnableVpcClassicLink API
func CreateEnableVpcClassicLinkRequest() (request *EnableVpcClassicLinkRequest) {
	request = &EnableVpcClassicLinkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "EnableVpcClassicLink", "vpc", "openAPI")
	return
}

// CreateEnableVpcClassicLinkResponse creates a response to parse from EnableVpcClassicLink response
func CreateEnableVpcClassicLinkResponse() (response *EnableVpcClassicLinkResponse) {
	response = &EnableVpcClassicLinkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
