package xtrace

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSpanNames invokes the xtrace.ListSpanNames API synchronously
// api document: https://help.aliyun.com/api/xtrace/listspannames.html
func (client *Client) ListSpanNames(request *ListSpanNamesRequest) (response *ListSpanNamesResponse, err error) {
	response = CreateListSpanNamesResponse()
	err = client.DoAction(request, response)
	return
}

// ListSpanNamesWithChan invokes the xtrace.ListSpanNames API asynchronously
// api document: https://help.aliyun.com/api/xtrace/listspannames.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListSpanNamesWithChan(request *ListSpanNamesRequest) (<-chan *ListSpanNamesResponse, <-chan error) {
	responseChan := make(chan *ListSpanNamesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSpanNames(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSpanNamesWithCallback invokes the xtrace.ListSpanNames API asynchronously
// api document: https://help.aliyun.com/api/xtrace/listspannames.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListSpanNamesWithCallback(request *ListSpanNamesRequest, callback func(response *ListSpanNamesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSpanNamesResponse
		var err error
		defer close(result)
		response, err = client.ListSpanNames(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSpanNamesRequest is the request struct for api ListSpanNames
type ListSpanNamesRequest struct {
	*requests.RpcRequest
	EndTime     requests.Integer `position:"Query" name:"EndTime"`
	ServiceName string           `position:"Query" name:"ServiceName"`
	StartTime   requests.Integer `position:"Query" name:"StartTime"`
}

// ListSpanNamesResponse is the response struct for api ListSpanNames
type ListSpanNamesResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	SpanNames SpanNames `json:"SpanNames" xml:"SpanNames"`
}

// CreateListSpanNamesRequest creates a request to invoke ListSpanNames API
func CreateListSpanNamesRequest() (request *ListSpanNamesRequest) {
	request = &ListSpanNamesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("xtrace", "2019-08-08", "ListSpanNames", "xtrace", "openAPI")
	return
}

// CreateListSpanNamesResponse creates a response to parse from ListSpanNames response
func CreateListSpanNamesResponse() (response *ListSpanNamesResponse) {
	response = &ListSpanNamesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
