// Code generated by github.com/gobuffalo/mapgen. DO NOT EDIT.

package plugcmds

import (
	"sort"
	"testing"

	"github.com/stretchr/testify/require"
)

func Test_plugMap(t *testing.T) {
	r := require.New(t)

	sm := &plugMap{}

	sm.Store("a", plug{})

	s, ok := sm.Load("a")
	r.True(ok)
	r.Equal(plug{}, s)

	s, ok = sm.LoadOrStore("b", plug{})
	r.True(ok)
	r.Equal(plug{}, s)

	s, ok = sm.LoadOrStore("b", plug{})
	r.True(ok)
	r.Equal(plug{}, s)

	var keys []string

	sm.Range(func(key string, value plug) bool {
		keys = append(keys, key)
		return true
	})

	sort.Strings(keys)

	r.Equal(sm.Keys(), keys)

	sm.Delete("b")
	r.Equal([]string{"a", "b"}, keys)

	sm.Delete("b")
	_, ok = sm.Load("b")
	r.False(ok)
	p := plug{
		BuffaloCommand: "foo",
	}
	func(m *plugMap) {
		m.Store("c", p)
	}(sm)
	s, ok = sm.Load("c")
	r.True(ok)
	r.Equal(p, s)
}
