package accountapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/datalake/store/mgmt/2016-11-01/account"
	"github.com/Azure/go-autorest/autorest"
)

// AccountsClientAPI contains the set of methods on the AccountsClient type.
type AccountsClientAPI interface {
	CheckNameAvailability(ctx context.Context, location string, parameters account.CheckNameAvailabilityParameters) (result account.NameAvailabilityInformation, err error)
	Create(ctx context.Context, resourceGroupName string, accountName string, parameters account.CreateDataLakeStoreAccountParameters) (result account.AccountsCreateFutureType, err error)
	Delete(ctx context.Context, resourceGroupName string, accountName string) (result account.AccountsDeleteFutureType, err error)
	EnableKeyVault(ctx context.Context, resourceGroupName string, accountName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, accountName string) (result account.DataLakeStoreAccount, err error)
	List(ctx context.Context, filter string, top *int32, skip *int32, selectParameter string, orderby string, count *bool) (result account.DataLakeStoreAccountListResultPage, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string, filter string, top *int32, skip *int32, selectParameter string, orderby string, count *bool) (result account.DataLakeStoreAccountListResultPage, err error)
	Update(ctx context.Context, resourceGroupName string, accountName string, parameters account.UpdateDataLakeStoreAccountParameters) (result account.AccountsUpdateFutureType, err error)
}

var _ AccountsClientAPI = (*account.AccountsClient)(nil)

// FirewallRulesClientAPI contains the set of methods on the FirewallRulesClient type.
type FirewallRulesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, accountName string, firewallRuleName string, parameters account.CreateOrUpdateFirewallRuleParameters) (result account.FirewallRule, err error)
	Delete(ctx context.Context, resourceGroupName string, accountName string, firewallRuleName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, accountName string, firewallRuleName string) (result account.FirewallRule, err error)
	ListByAccount(ctx context.Context, resourceGroupName string, accountName string) (result account.FirewallRuleListResultPage, err error)
	Update(ctx context.Context, resourceGroupName string, accountName string, firewallRuleName string, parameters *account.UpdateFirewallRuleParameters) (result account.FirewallRule, err error)
}

var _ FirewallRulesClientAPI = (*account.FirewallRulesClient)(nil)

// VirtualNetworkRulesClientAPI contains the set of methods on the VirtualNetworkRulesClient type.
type VirtualNetworkRulesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, accountName string, virtualNetworkRuleName string, parameters account.CreateOrUpdateVirtualNetworkRuleParameters) (result account.VirtualNetworkRule, err error)
	Delete(ctx context.Context, resourceGroupName string, accountName string, virtualNetworkRuleName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, accountName string, virtualNetworkRuleName string) (result account.VirtualNetworkRule, err error)
	ListByAccount(ctx context.Context, resourceGroupName string, accountName string) (result account.VirtualNetworkRuleListResultPage, err error)
	Update(ctx context.Context, resourceGroupName string, accountName string, virtualNetworkRuleName string, parameters *account.UpdateVirtualNetworkRuleParameters) (result account.VirtualNetworkRule, err error)
}

var _ VirtualNetworkRulesClientAPI = (*account.VirtualNetworkRulesClient)(nil)

// TrustedIDProvidersClientAPI contains the set of methods on the TrustedIDProvidersClient type.
type TrustedIDProvidersClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, accountName string, trustedIDProviderName string, parameters account.CreateOrUpdateTrustedIDProviderParameters) (result account.TrustedIDProvider, err error)
	Delete(ctx context.Context, resourceGroupName string, accountName string, trustedIDProviderName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, accountName string, trustedIDProviderName string) (result account.TrustedIDProvider, err error)
	ListByAccount(ctx context.Context, resourceGroupName string, accountName string) (result account.TrustedIDProviderListResultPage, err error)
	Update(ctx context.Context, resourceGroupName string, accountName string, trustedIDProviderName string, parameters *account.UpdateTrustedIDProviderParameters) (result account.TrustedIDProvider, err error)
}

var _ TrustedIDProvidersClientAPI = (*account.TrustedIDProvidersClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result account.OperationListResult, err error)
}

var _ OperationsClientAPI = (*account.OperationsClient)(nil)

// LocationsClientAPI contains the set of methods on the LocationsClient type.
type LocationsClientAPI interface {
	GetCapability(ctx context.Context, location string) (result account.CapabilityInformation, err error)
	GetUsage(ctx context.Context, location string) (result account.UsageListResult, err error)
}

var _ LocationsClientAPI = (*account.LocationsClient)(nil)
