// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dialogflow/v2beta1/document.proto

package dialogflow

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "github.com/golang/protobuf/ptypes/empty"
	_ "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	_ "google.golang.org/genproto/googleapis/rpc/status"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The knowledge type of document content.
type Document_KnowledgeType int32

const (
	// The type is unspecified or arbitrary.
	Document_KNOWLEDGE_TYPE_UNSPECIFIED Document_KnowledgeType = 0
	// The document content contains question and answer pairs as either HTML or
	// CSV. Typical FAQ HTML formats are parsed accurately, but unusual formats
	// may fail to be parsed.
	//
	// CSV must have questions in the first column and answers in the second,
	// with no header. Because of this explicit format, they are always parsed
	// accurately.
	Document_FAQ Document_KnowledgeType = 1
	// Documents for which unstructured text is extracted and used for
	// question answering.
	Document_EXTRACTIVE_QA Document_KnowledgeType = 2
)

var Document_KnowledgeType_name = map[int32]string{
	0: "KNOWLEDGE_TYPE_UNSPECIFIED",
	1: "FAQ",
	2: "EXTRACTIVE_QA",
}

var Document_KnowledgeType_value = map[string]int32{
	"KNOWLEDGE_TYPE_UNSPECIFIED": 0,
	"FAQ":                        1,
	"EXTRACTIVE_QA":              2,
}

func (x Document_KnowledgeType) String() string {
	return proto.EnumName(Document_KnowledgeType_name, int32(x))
}

func (Document_KnowledgeType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_2d3494516d3ece6c, []int{0, 0}
}

// States of the operation.
type KnowledgeOperationMetadata_State int32

const (
	// State unspecified.
	KnowledgeOperationMetadata_STATE_UNSPECIFIED KnowledgeOperationMetadata_State = 0
	// The operation has been created.
	KnowledgeOperationMetadata_PENDING KnowledgeOperationMetadata_State = 1
	// The operation is currently running.
	KnowledgeOperationMetadata_RUNNING KnowledgeOperationMetadata_State = 2
	// The operation is done, either cancelled or completed.
	KnowledgeOperationMetadata_DONE KnowledgeOperationMetadata_State = 3
)

var KnowledgeOperationMetadata_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "PENDING",
	2: "RUNNING",
	3: "DONE",
}

var KnowledgeOperationMetadata_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"PENDING":           1,
	"RUNNING":           2,
	"DONE":              3,
}

func (x KnowledgeOperationMetadata_State) String() string {
	return proto.EnumName(KnowledgeOperationMetadata_State_name, int32(x))
}

func (KnowledgeOperationMetadata_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_2d3494516d3ece6c, []int{7, 0}
}

// A document resource.
//
// Note: The `projects.agent.knowledgeBases.documents` resource is deprecated;
// only use `projects.knowledgeBases.documents`.
type Document struct {
	// The document resource name.
	// The name must be empty when creating a document.
	// Format: `projects/<Project ID>/knowledgeBases/<Knowledge Base
	// ID>/documents/<Document ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the document. The name must be 1024 bytes or
	// less; otherwise, the creation request fails.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The MIME type of this document.
	MimeType string `protobuf:"bytes,3,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// Required. The knowledge type of document content.
	KnowledgeTypes []Document_KnowledgeType `protobuf:"varint,4,rep,packed,name=knowledge_types,json=knowledgeTypes,proto3,enum=google.cloud.dialogflow.v2beta1.Document_KnowledgeType" json:"knowledge_types,omitempty"`
	// Required. The source of this document.
	//
	// Types that are valid to be assigned to Source:
	//	*Document_ContentUri
	//	*Document_Content
	//	*Document_RawContent
	Source               isDocument_Source `protobuf_oneof:"source"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Document) Reset()         { *m = Document{} }
func (m *Document) String() string { return proto.CompactTextString(m) }
func (*Document) ProtoMessage()    {}
func (*Document) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d3494516d3ece6c, []int{0}
}

func (m *Document) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document.Unmarshal(m, b)
}
func (m *Document) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document.Marshal(b, m, deterministic)
}
func (m *Document) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document.Merge(m, src)
}
func (m *Document) XXX_Size() int {
	return xxx_messageInfo_Document.Size(m)
}
func (m *Document) XXX_DiscardUnknown() {
	xxx_messageInfo_Document.DiscardUnknown(m)
}

var xxx_messageInfo_Document proto.InternalMessageInfo

func (m *Document) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Document) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Document) GetMimeType() string {
	if m != nil {
		return m.MimeType
	}
	return ""
}

func (m *Document) GetKnowledgeTypes() []Document_KnowledgeType {
	if m != nil {
		return m.KnowledgeTypes
	}
	return nil
}

type isDocument_Source interface {
	isDocument_Source()
}

type Document_ContentUri struct {
	ContentUri string `protobuf:"bytes,5,opt,name=content_uri,json=contentUri,proto3,oneof"`
}

type Document_Content struct {
	Content string `protobuf:"bytes,6,opt,name=content,proto3,oneof"`
}

type Document_RawContent struct {
	RawContent []byte `protobuf:"bytes,9,opt,name=raw_content,json=rawContent,proto3,oneof"`
}

func (*Document_ContentUri) isDocument_Source() {}

func (*Document_Content) isDocument_Source() {}

func (*Document_RawContent) isDocument_Source() {}

func (m *Document) GetSource() isDocument_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *Document) GetContentUri() string {
	if x, ok := m.GetSource().(*Document_ContentUri); ok {
		return x.ContentUri
	}
	return ""
}

// Deprecated: Do not use.
func (m *Document) GetContent() string {
	if x, ok := m.GetSource().(*Document_Content); ok {
		return x.Content
	}
	return ""
}

func (m *Document) GetRawContent() []byte {
	if x, ok := m.GetSource().(*Document_RawContent); ok {
		return x.RawContent
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Document) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Document_ContentUri)(nil),
		(*Document_Content)(nil),
		(*Document_RawContent)(nil),
	}
}

// Request message for [Documents.ListDocuments][google.cloud.dialogflow.v2beta1.Documents.ListDocuments].
type ListDocumentsRequest struct {
	// Required. The knowledge base to list all documents for.
	// Format: `projects/<Project ID>/knowledgeBases/<Knowledge Base ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return in a single page. By
	// default 10 and at most 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDocumentsRequest) Reset()         { *m = ListDocumentsRequest{} }
func (m *ListDocumentsRequest) String() string { return proto.CompactTextString(m) }
func (*ListDocumentsRequest) ProtoMessage()    {}
func (*ListDocumentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d3494516d3ece6c, []int{1}
}

func (m *ListDocumentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDocumentsRequest.Unmarshal(m, b)
}
func (m *ListDocumentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDocumentsRequest.Marshal(b, m, deterministic)
}
func (m *ListDocumentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDocumentsRequest.Merge(m, src)
}
func (m *ListDocumentsRequest) XXX_Size() int {
	return xxx_messageInfo_ListDocumentsRequest.Size(m)
}
func (m *ListDocumentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDocumentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDocumentsRequest proto.InternalMessageInfo

func (m *ListDocumentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListDocumentsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDocumentsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for [Documents.ListDocuments][google.cloud.dialogflow.v2beta1.Documents.ListDocuments].
type ListDocumentsResponse struct {
	// The list of documents.
	Documents []*Document `protobuf:"bytes,1,rep,name=documents,proto3" json:"documents,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDocumentsResponse) Reset()         { *m = ListDocumentsResponse{} }
func (m *ListDocumentsResponse) String() string { return proto.CompactTextString(m) }
func (*ListDocumentsResponse) ProtoMessage()    {}
func (*ListDocumentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d3494516d3ece6c, []int{2}
}

func (m *ListDocumentsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDocumentsResponse.Unmarshal(m, b)
}
func (m *ListDocumentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDocumentsResponse.Marshal(b, m, deterministic)
}
func (m *ListDocumentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDocumentsResponse.Merge(m, src)
}
func (m *ListDocumentsResponse) XXX_Size() int {
	return xxx_messageInfo_ListDocumentsResponse.Size(m)
}
func (m *ListDocumentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDocumentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDocumentsResponse proto.InternalMessageInfo

func (m *ListDocumentsResponse) GetDocuments() []*Document {
	if m != nil {
		return m.Documents
	}
	return nil
}

func (m *ListDocumentsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for [Documents.GetDocument][google.cloud.dialogflow.v2beta1.Documents.GetDocument].
type GetDocumentRequest struct {
	// Required. The name of the document to retrieve.
	// Format `projects/<Project ID>/knowledgeBases/<Knowledge Base
	// ID>/documents/<Document ID>`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetDocumentRequest) Reset()         { *m = GetDocumentRequest{} }
func (m *GetDocumentRequest) String() string { return proto.CompactTextString(m) }
func (*GetDocumentRequest) ProtoMessage()    {}
func (*GetDocumentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d3494516d3ece6c, []int{3}
}

func (m *GetDocumentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDocumentRequest.Unmarshal(m, b)
}
func (m *GetDocumentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDocumentRequest.Marshal(b, m, deterministic)
}
func (m *GetDocumentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDocumentRequest.Merge(m, src)
}
func (m *GetDocumentRequest) XXX_Size() int {
	return xxx_messageInfo_GetDocumentRequest.Size(m)
}
func (m *GetDocumentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDocumentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDocumentRequest proto.InternalMessageInfo

func (m *GetDocumentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [Documents.CreateDocument][google.cloud.dialogflow.v2beta1.Documents.CreateDocument].
type CreateDocumentRequest struct {
	// Required. The knoweldge base to create a document for.
	// Format: `projects/<Project ID>/knowledgeBases/<Knowledge Base ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The document to create.
	Document             *Document `protobuf:"bytes,2,opt,name=document,proto3" json:"document,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CreateDocumentRequest) Reset()         { *m = CreateDocumentRequest{} }
func (m *CreateDocumentRequest) String() string { return proto.CompactTextString(m) }
func (*CreateDocumentRequest) ProtoMessage()    {}
func (*CreateDocumentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d3494516d3ece6c, []int{4}
}

func (m *CreateDocumentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateDocumentRequest.Unmarshal(m, b)
}
func (m *CreateDocumentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateDocumentRequest.Marshal(b, m, deterministic)
}
func (m *CreateDocumentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateDocumentRequest.Merge(m, src)
}
func (m *CreateDocumentRequest) XXX_Size() int {
	return xxx_messageInfo_CreateDocumentRequest.Size(m)
}
func (m *CreateDocumentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateDocumentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateDocumentRequest proto.InternalMessageInfo

func (m *CreateDocumentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateDocumentRequest) GetDocument() *Document {
	if m != nil {
		return m.Document
	}
	return nil
}

// Request message for [Documents.DeleteDocument][google.cloud.dialogflow.v2beta1.Documents.DeleteDocument].
type DeleteDocumentRequest struct {
	// The name of the document to delete.
	// Format: `projects/<Project ID>/knowledgeBases/<Knowledge Base
	// ID>/documents/<Document ID>`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteDocumentRequest) Reset()         { *m = DeleteDocumentRequest{} }
func (m *DeleteDocumentRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteDocumentRequest) ProtoMessage()    {}
func (*DeleteDocumentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d3494516d3ece6c, []int{5}
}

func (m *DeleteDocumentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteDocumentRequest.Unmarshal(m, b)
}
func (m *DeleteDocumentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteDocumentRequest.Marshal(b, m, deterministic)
}
func (m *DeleteDocumentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteDocumentRequest.Merge(m, src)
}
func (m *DeleteDocumentRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteDocumentRequest.Size(m)
}
func (m *DeleteDocumentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteDocumentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteDocumentRequest proto.InternalMessageInfo

func (m *DeleteDocumentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [Documents.UpdateDocument][google.cloud.dialogflow.v2beta1.Documents.UpdateDocument].
type UpdateDocumentRequest struct {
	// Required. The document to update.
	Document *Document `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// Optional. Not specified means `update all`.
	// Currently, only `display_name` can be updated, an InvalidArgument will be
	// returned for attempting to update other fields.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateDocumentRequest) Reset()         { *m = UpdateDocumentRequest{} }
func (m *UpdateDocumentRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateDocumentRequest) ProtoMessage()    {}
func (*UpdateDocumentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d3494516d3ece6c, []int{6}
}

func (m *UpdateDocumentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateDocumentRequest.Unmarshal(m, b)
}
func (m *UpdateDocumentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateDocumentRequest.Marshal(b, m, deterministic)
}
func (m *UpdateDocumentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateDocumentRequest.Merge(m, src)
}
func (m *UpdateDocumentRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateDocumentRequest.Size(m)
}
func (m *UpdateDocumentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateDocumentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateDocumentRequest proto.InternalMessageInfo

func (m *UpdateDocumentRequest) GetDocument() *Document {
	if m != nil {
		return m.Document
	}
	return nil
}

func (m *UpdateDocumentRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Metadata in google::longrunning::Operation for Knowledge operations.
type KnowledgeOperationMetadata struct {
	// Required. The current state of this operation.
	State                KnowledgeOperationMetadata_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata_State" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *KnowledgeOperationMetadata) Reset()         { *m = KnowledgeOperationMetadata{} }
func (m *KnowledgeOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*KnowledgeOperationMetadata) ProtoMessage()    {}
func (*KnowledgeOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d3494516d3ece6c, []int{7}
}

func (m *KnowledgeOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KnowledgeOperationMetadata.Unmarshal(m, b)
}
func (m *KnowledgeOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KnowledgeOperationMetadata.Marshal(b, m, deterministic)
}
func (m *KnowledgeOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KnowledgeOperationMetadata.Merge(m, src)
}
func (m *KnowledgeOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_KnowledgeOperationMetadata.Size(m)
}
func (m *KnowledgeOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_KnowledgeOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_KnowledgeOperationMetadata proto.InternalMessageInfo

func (m *KnowledgeOperationMetadata) GetState() KnowledgeOperationMetadata_State {
	if m != nil {
		return m.State
	}
	return KnowledgeOperationMetadata_STATE_UNSPECIFIED
}

// Request message for [Documents.ReloadDocument][google.cloud.dialogflow.v2beta1.Documents.ReloadDocument].
type ReloadDocumentRequest struct {
	// The name of the document to reload.
	// Format: `projects/<Project ID>/knowledgeBases/<Knowledge Base
	// ID>/documents/<Document ID>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The source for document reloading.
	// Optional. If provided, the service will load the contents from the source
	// and update document in the knowledge base.
	//
	// Types that are valid to be assigned to Source:
	//	*ReloadDocumentRequest_GcsSource
	Source               isReloadDocumentRequest_Source `protobuf_oneof:"source"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *ReloadDocumentRequest) Reset()         { *m = ReloadDocumentRequest{} }
func (m *ReloadDocumentRequest) String() string { return proto.CompactTextString(m) }
func (*ReloadDocumentRequest) ProtoMessage()    {}
func (*ReloadDocumentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d3494516d3ece6c, []int{8}
}

func (m *ReloadDocumentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReloadDocumentRequest.Unmarshal(m, b)
}
func (m *ReloadDocumentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReloadDocumentRequest.Marshal(b, m, deterministic)
}
func (m *ReloadDocumentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReloadDocumentRequest.Merge(m, src)
}
func (m *ReloadDocumentRequest) XXX_Size() int {
	return xxx_messageInfo_ReloadDocumentRequest.Size(m)
}
func (m *ReloadDocumentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReloadDocumentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReloadDocumentRequest proto.InternalMessageInfo

func (m *ReloadDocumentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type isReloadDocumentRequest_Source interface {
	isReloadDocumentRequest_Source()
}

type ReloadDocumentRequest_GcsSource struct {
	GcsSource *GcsSource `protobuf:"bytes,3,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

func (*ReloadDocumentRequest_GcsSource) isReloadDocumentRequest_Source() {}

func (m *ReloadDocumentRequest) GetSource() isReloadDocumentRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *ReloadDocumentRequest) GetGcsSource() *GcsSource {
	if x, ok := m.GetSource().(*ReloadDocumentRequest_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ReloadDocumentRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ReloadDocumentRequest_GcsSource)(nil),
	}
}

func init() {
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.Document_KnowledgeType", Document_KnowledgeType_name, Document_KnowledgeType_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata_State", KnowledgeOperationMetadata_State_name, KnowledgeOperationMetadata_State_value)
	proto.RegisterType((*Document)(nil), "google.cloud.dialogflow.v2beta1.Document")
	proto.RegisterType((*ListDocumentsRequest)(nil), "google.cloud.dialogflow.v2beta1.ListDocumentsRequest")
	proto.RegisterType((*ListDocumentsResponse)(nil), "google.cloud.dialogflow.v2beta1.ListDocumentsResponse")
	proto.RegisterType((*GetDocumentRequest)(nil), "google.cloud.dialogflow.v2beta1.GetDocumentRequest")
	proto.RegisterType((*CreateDocumentRequest)(nil), "google.cloud.dialogflow.v2beta1.CreateDocumentRequest")
	proto.RegisterType((*DeleteDocumentRequest)(nil), "google.cloud.dialogflow.v2beta1.DeleteDocumentRequest")
	proto.RegisterType((*UpdateDocumentRequest)(nil), "google.cloud.dialogflow.v2beta1.UpdateDocumentRequest")
	proto.RegisterType((*KnowledgeOperationMetadata)(nil), "google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata")
	proto.RegisterType((*ReloadDocumentRequest)(nil), "google.cloud.dialogflow.v2beta1.ReloadDocumentRequest")
}

func init() {
	proto.RegisterFile("google/cloud/dialogflow/v2beta1/document.proto", fileDescriptor_2d3494516d3ece6c)
}

var fileDescriptor_2d3494516d3ece6c = []byte{
	// 1169 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x57, 0x4f, 0x6f, 0x1b, 0x45,
	0x14, 0xcf, 0x38, 0xff, 0xec, 0x71, 0xed, 0xa6, 0x23, 0x0c, 0xc6, 0xa5, 0x4d, 0xba, 0x95, 0x50,
	0x6a, 0x60, 0x57, 0xb8, 0x82, 0x4a, 0xa9, 0x0a, 0xd8, 0xb1, 0xe3, 0x58, 0x69, 0x1d, 0x77, 0xe3,
	0xb4, 0x34, 0x17, 0x33, 0x59, 0x4f, 0x36, 0xdb, 0xac, 0x77, 0x96, 0x9d, 0x71, 0xdc, 0x04, 0x55,
	0xa2, 0x3d, 0x71, 0x42, 0x42, 0x88, 0x13, 0x17, 0xc4, 0x05, 0x09, 0x3e, 0x01, 0x5f, 0x81, 0x23,
	0x7c, 0x05, 0x4e, 0x9c, 0x38, 0x72, 0x41, 0xa0, 0xd9, 0x7f, 0xfe, 0x53, 0x27, 0xeb, 0x24, 0x37,
	0xcf, 0xbc, 0xf7, 0x7e, 0xf3, 0xfb, 0xbd, 0x37, 0xef, 0xed, 0x18, 0xca, 0x3a, 0xa5, 0xba, 0x49,
	0x14, 0xcd, 0xa4, 0xdd, 0xb6, 0xd2, 0x36, 0xb0, 0x49, 0xf5, 0x3d, 0x93, 0xf6, 0x94, 0xc3, 0xc2,
	0x2e, 0xe1, 0xf8, 0x7d, 0xa5, 0x4d, 0xb5, 0x6e, 0x87, 0x58, 0x5c, 0xb6, 0x1d, 0xca, 0x29, 0x5a,
	0xf4, 0xfc, 0x65, 0xd7, 0x5f, 0xee, 0xfb, 0xcb, 0xbe, 0x7f, 0xee, 0x2d, 0x1f, 0x10, 0xdb, 0x86,
	0x82, 0x2d, 0x8b, 0x72, 0xcc, 0x0d, 0x6a, 0x31, 0x2f, 0x3c, 0xb7, 0x38, 0x60, 0xdd, 0x33, 0x88,
	0xd9, 0x6e, 0xed, 0x92, 0x7d, 0x7c, 0x68, 0x50, 0xc7, 0x77, 0xb8, 0x15, 0xc5, 0x47, 0xd7, 0x02,
	0xac, 0x9b, 0xbe, 0xab, 0x49, 0x2d, 0xdd, 0xe9, 0x5a, 0x96, 0x61, 0xe9, 0x0a, 0xb5, 0x89, 0x33,
	0x74, 0xe0, 0x55, 0xdf, 0xc9, 0x5d, 0xed, 0x76, 0xf7, 0x14, 0xd2, 0xb1, 0xf9, 0x91, 0x6f, 0x5c,
	0x1a, 0x35, 0x7a, 0x94, 0x3a, 0x98, 0x1d, 0x8c, 0xf0, 0x0d, 0x3d, 0xb8, 0xd1, 0x21, 0x8c, 0xe3,
	0x8e, 0xed, 0x3b, 0xbc, 0xe1, 0x3b, 0x38, 0xb6, 0xa6, 0x30, 0x8e, 0x79, 0x97, 0x8d, 0x18, 0x84,
	0x52, 0xcd, 0x34, 0xc2, 0x0c, 0x4a, 0xff, 0xc6, 0x60, 0xbc, 0xec, 0x27, 0x15, 0x21, 0x38, 0x63,
	0xe1, 0x0e, 0xc9, 0x82, 0x25, 0xb0, 0x9c, 0x50, 0xdd, 0xdf, 0xe8, 0x06, 0xbc, 0xd4, 0x36, 0x98,
	0x6d, 0xe2, 0xa3, 0x96, 0x6b, 0x8b, 0xb9, 0xb6, 0xa4, 0xbf, 0x57, 0x17, 0x2e, 0x57, 0x61, 0xa2,
	0x63, 0x74, 0x48, 0x8b, 0x1f, 0xd9, 0x24, 0x3b, 0xed, 0xda, 0xe3, 0x62, 0xa3, 0x79, 0x64, 0x13,
	0xf4, 0x19, 0xbc, 0x7c, 0x60, 0xd1, 0x9e, 0x49, 0xda, 0xba, 0xe7, 0xc1, 0xb2, 0x33, 0x4b, 0xd3,
	0xcb, 0xe9, 0xc2, 0x1d, 0x39, 0xa2, 0x78, 0x72, 0xc0, 0x4b, 0xde, 0x08, 0x00, 0x04, 0xa2, 0x9a,
	0x3e, 0x18, 0x5c, 0x32, 0x74, 0x03, 0x26, 0x35, 0x6a, 0x71, 0x62, 0xf1, 0x56, 0xd7, 0x31, 0xb2,
	0xb3, 0x82, 0xc0, 0xfa, 0x94, 0x0a, 0xfd, 0xcd, 0x6d, 0xc7, 0x40, 0xd7, 0xe1, 0xbc, 0xbf, 0xca,
	0xce, 0x09, 0x73, 0x29, 0x96, 0x05, 0xeb, 0x53, 0x6a, 0xb0, 0x29, 0x20, 0x1c, 0xdc, 0x6b, 0x05,
	0x3e, 0x89, 0x25, 0xb0, 0x7c, 0x49, 0x40, 0x38, 0xb8, 0xb7, 0xea, 0xed, 0x49, 0x1b, 0x30, 0x35,
	0x44, 0x03, 0x5d, 0x87, 0xb9, 0x8d, 0xfa, 0xe6, 0xe3, 0xfb, 0x95, 0x72, 0xb5, 0xd2, 0x6a, 0x3e,
	0x69, 0x54, 0x5a, 0xdb, 0xf5, 0xad, 0x46, 0x65, 0xb5, 0xb6, 0x56, 0xab, 0x94, 0x17, 0xa6, 0xd0,
	0x3c, 0x9c, 0x5e, 0x2b, 0x3e, 0x5c, 0x00, 0xe8, 0x0a, 0x4c, 0x55, 0x3e, 0x6d, 0xaa, 0xc5, 0xd5,
	0x66, 0xed, 0x51, 0xa5, 0xf5, 0xb0, 0xb8, 0x10, 0x2b, 0xc5, 0xe1, 0x1c, 0xa3, 0x5d, 0x47, 0x23,
	0xd2, 0x53, 0xf8, 0xda, 0x7d, 0x83, 0xf1, 0x40, 0x2a, 0x53, 0xc9, 0xe7, 0x5d, 0xc2, 0x38, 0x7a,
	0x1d, 0xce, 0xd9, 0xd8, 0x11, 0x64, 0xbc, 0x62, 0xf8, 0x2b, 0x91, 0x6b, 0x1b, 0xeb, 0xa4, 0xc5,
	0x8c, 0x63, 0xaf, 0x16, 0xb3, 0x6a, 0x5c, 0x6c, 0x6c, 0x19, 0xc7, 0x04, 0x5d, 0x83, 0xd0, 0x35,
	0x72, 0x7a, 0x40, 0x2c, 0xbf, 0x12, 0xae, 0x7b, 0x53, 0x6c, 0x48, 0x5f, 0x01, 0x98, 0x19, 0x39,
	0x8c, 0xd9, 0xd4, 0x62, 0x04, 0x55, 0x61, 0x22, 0xe8, 0x2c, 0x96, 0x05, 0x4b, 0xd3, 0xcb, 0xc9,
	0xc2, 0xad, 0x89, 0xcb, 0xa3, 0xf6, 0x63, 0xd1, 0xdb, 0xf0, 0xb2, 0x45, 0x9e, 0xf1, 0xd6, 0x00,
	0x0d, 0xef, 0xc2, 0xa4, 0xc4, 0x76, 0x23, 0xa4, 0xb2, 0x0c, 0x51, 0x95, 0x84, 0x44, 0x02, 0xd1,
	0x63, 0xee, 0x9f, 0x74, 0x08, 0x33, 0xab, 0x0e, 0xc1, 0x9c, 0x8c, 0x3a, 0x9f, 0x94, 0xa1, 0x0a,
	0x8c, 0x07, 0x7c, 0xdc, 0xb3, 0xcf, 0x24, 0x25, 0x0c, 0x95, 0xde, 0x81, 0x99, 0x32, 0x31, 0xc9,
	0xab, 0xe7, 0x8e, 0x23, 0xf9, 0x3d, 0x80, 0x99, 0x6d, 0xbb, 0x3d, 0x86, 0xe5, 0x20, 0x1b, 0x70,
	0x6e, 0x36, 0xe8, 0x2e, 0x4c, 0x76, 0x5d, 0x7c, 0x77, 0x1c, 0xf8, 0xba, 0x72, 0x01, 0x52, 0x30,
	0x0f, 0xe4, 0x35, 0x31, 0x31, 0x1e, 0x60, 0x76, 0xa0, 0x42, 0xcf, 0x5d, 0xfc, 0x96, 0x7e, 0x05,
	0x30, 0x17, 0xde, 0xdd, 0xcd, 0x60, 0x26, 0x3d, 0x20, 0x1c, 0xb7, 0x31, 0xc7, 0xe8, 0x31, 0x9c,
	0x15, 0xb3, 0xc2, 0x53, 0x94, 0x2e, 0x14, 0x23, 0xf9, 0x9d, 0x8c, 0x25, 0x6f, 0x09, 0x20, 0xd5,
	0xc3, 0x93, 0x4a, 0x70, 0xd6, 0x5d, 0xa3, 0x0c, 0xbc, 0xb2, 0xd5, 0x2c, 0x36, 0x47, 0x3b, 0x24,
	0x09, 0xe7, 0x1b, 0x95, 0x7a, 0xb9, 0x56, 0xaf, 0x2e, 0x00, 0xb1, 0x50, 0xb7, 0xeb, 0x75, 0xb1,
	0x88, 0xa1, 0x38, 0x9c, 0x29, 0x6f, 0xd6, 0x2b, 0x0b, 0xd3, 0xd2, 0x4b, 0x00, 0x33, 0x2a, 0x31,
	0x29, 0x6e, 0x4f, 0x50, 0x07, 0xb4, 0x01, 0xa1, 0xae, 0xb1, 0x96, 0xd7, 0x5b, 0x6e, 0x03, 0x24,
	0x0b, 0xf9, 0x48, 0x3d, 0x55, 0x8d, 0x6d, 0xb9, 0x11, 0xeb, 0x53, 0x6a, 0x42, 0x0f, 0x16, 0xfd,
	0x26, 0x2d, 0xbc, 0x48, 0xc1, 0x44, 0xd8, 0x34, 0xe8, 0x45, 0x0c, 0xa6, 0x86, 0xda, 0x08, 0x7d,
	0x10, 0x79, 0xc4, 0xb8, 0x1e, 0xcf, 0x7d, 0x78, 0xd6, 0x30, 0xaf, 0x5b, 0xa5, 0x2f, 0xc1, 0xcb,
	0x3f, 0xfe, 0xfc, 0x36, 0x76, 0x8c, 0xee, 0x84, 0xdf, 0xa1, 0x2f, 0xbc, 0xcb, 0x7f, 0xcf, 0x76,
	0xe8, 0x53, 0xa2, 0x71, 0xa6, 0xe4, 0x95, 0x70, 0x4a, 0x96, 0x30, 0x23, 0x4c, 0xc9, 0x3f, 0x0f,
	0x3f, 0x9e, 0x6c, 0xe7, 0x63, 0x74, 0xef, 0xb4, 0x50, 0xac, 0x13, 0x8b, 0x9f, 0x06, 0x80, 0xfe,
	0x06, 0x30, 0x39, 0xd0, 0xc0, 0xe8, 0x76, 0x74, 0x92, 0x5f, 0x69, 0xf7, 0xdc, 0xe4, 0x9d, 0x30,
	0x56, 0xb2, 0xa8, 0xf8, 0x69, 0x82, 0xfb, 0x74, 0x95, 0xfc, 0xf3, 0x61, 0xc9, 0xa3, 0xa1, 0xe3,
	0x05, 0x0f, 0x01, 0xa0, 0xff, 0x00, 0x4c, 0x0f, 0x4f, 0x22, 0x14, 0x5d, 0xc0, 0xb1, 0xa3, 0x2b,
	0x77, 0x2d, 0x88, 0x1b, 0x78, 0x2c, 0xc8, 0x61, 0x33, 0x49, 0xdf, 0x79, 0x62, 0xbf, 0x06, 0xd2,
	0x79, 0x0b, 0xbc, 0x12, 0x4e, 0x8e, 0x9d, 0x9a, 0x74, 0xb1, 0x52, 0xf7, 0xa1, 0xd0, 0x5f, 0x00,
	0xa6, 0x87, 0x67, 0xe2, 0x04, 0x19, 0x18, 0x3b, 0x44, 0xa3, 0x32, 0x10, 0x94, 0x3b, 0x7f, 0xfe,
	0x72, 0xe7, 0x2f, 0x58, 0xee, 0x6f, 0x62, 0x30, 0x3d, 0x3c, 0xd2, 0x27, 0x10, 0x3b, 0xf6, 0x1b,
	0x10, 0x25, 0xf6, 0x27, 0x4f, 0xec, 0x0f, 0xa0, 0xf0, 0x49, 0x9f, 0x72, 0xf8, 0xd0, 0x3d, 0x93,
	0xec, 0x81, 0xba, 0xab, 0x85, 0xb5, 0x09, 0xd0, 0x26, 0xc8, 0xc4, 0xc0, 0x05, 0x10, 0x2d, 0x30,
	0x3c, 0x8c, 0x27, 0xc8, 0xc9, 0xd8, 0xe9, 0x3d, 0x79, 0x0b, 0x7c, 0x74, 0xce, 0x1b, 0xb0, 0xe2,
	0xb8, 0xe7, 0xae, 0x80, 0xfc, 0x4e, 0x4d, 0x2a, 0x5f, 0xe8, 0x2e, 0xf4, 0xa1, 0x72, 0xcf, 0x7e,
	0x2b, 0xbe, 0x39, 0xa0, 0xd1, 0xd3, 0x80, 0x6d, 0x83, 0xc9, 0x1a, 0xed, 0xfc, 0x5e, 0x7c, 0xb2,
	0xcf, 0xb9, 0xcd, 0x56, 0x14, 0xa5, 0xd7, 0x1b, 0x35, 0x2a, 0xb8, 0xcb, 0xf7, 0xbd, 0x3f, 0x12,
	0xef, 0xd9, 0x26, 0xe6, 0x7b, 0xd4, 0xe9, 0xbc, 0x1b, 0xe5, 0xde, 0x3f, 0xaa, 0xf4, 0x0b, 0x80,
	0x37, 0x35, 0xda, 0x89, 0x4a, 0x77, 0x29, 0x15, 0x64, 0xba, 0x21, 0x1e, 0x05, 0x0d, 0xb0, 0x53,
	0xf3, 0x23, 0x74, 0x6a, 0x62, 0x4b, 0x97, 0xa9, 0xa3, 0x2b, 0x3a, 0xb1, 0xdc, 0x27, 0x83, 0xd2,
	0x3f, 0xf3, 0xc4, 0xbf, 0x38, 0x77, 0xfb, 0x5b, 0xff, 0x00, 0xf0, 0x63, 0x2c, 0x56, 0x5e, 0xfb,
	0x39, 0xb6, 0x58, 0xf5, 0x30, 0x57, 0x5d, 0x16, 0xe5, 0x3e, 0x8b, 0x47, 0x5e, 0xd0, 0xee, 0x9c,
	0x8b, 0x7f, 0xfb, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd5, 0xe1, 0xe8, 0xe7, 0xd1, 0x0d, 0x00,
	0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DocumentsClient is the client API for Documents service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DocumentsClient interface {
	// Returns the list of all documents of the knowledge base.
	//
	// Note: The `projects.agent.knowledgeBases.documents` resource is deprecated;
	// only use `projects.knowledgeBases.documents`.
	ListDocuments(ctx context.Context, in *ListDocumentsRequest, opts ...grpc.CallOption) (*ListDocumentsResponse, error)
	// Retrieves the specified document.
	//
	// Note: The `projects.agent.knowledgeBases.documents` resource is deprecated;
	// only use `projects.knowledgeBases.documents`.
	GetDocument(ctx context.Context, in *GetDocumentRequest, opts ...grpc.CallOption) (*Document, error)
	// Creates a new document.
	//
	// Note: The `projects.agent.knowledgeBases.documents` resource is deprecated;
	// only use `projects.knowledgeBases.documents`.
	//
	// Operation <response: [Document][google.cloud.dialogflow.v2beta1.Document],
	//            metadata: [KnowledgeOperationMetadata][google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata]>
	CreateDocument(ctx context.Context, in *CreateDocumentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes the specified document.
	//
	// Note: The `projects.agent.knowledgeBases.documents` resource is deprecated;
	// only use `projects.knowledgeBases.documents`.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty],
	//            metadata: [KnowledgeOperationMetadata][google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata]>
	DeleteDocument(ctx context.Context, in *DeleteDocumentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates the specified document.
	//
	// Note: The `projects.agent.knowledgeBases.documents` resource is deprecated;
	// only use `projects.knowledgeBases.documents`.
	//
	// Operation <response: [Document][google.cloud.dialogflow.v2beta1.Document],
	//            metadata: [KnowledgeOperationMetadata][google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata]>
	UpdateDocument(ctx context.Context, in *UpdateDocumentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Reloads the specified document from its specified source, content_uri or
	// content. The previously loaded content of the document will be deleted.
	// Note: Even when the content of the document has not changed, there still
	// may be side effects because of internal implementation changes.
	//
	// Note: The `projects.agent.knowledgeBases.documents` resource is deprecated;
	// only use `projects.knowledgeBases.documents`.
	//
	// Operation <response: [Document][google.cloud.dialogflow.v2beta1.Document],
	//            metadata: [KnowledgeOperationMetadata][google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata]>
	ReloadDocument(ctx context.Context, in *ReloadDocumentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type documentsClient struct {
	cc grpc.ClientConnInterface
}

func NewDocumentsClient(cc grpc.ClientConnInterface) DocumentsClient {
	return &documentsClient{cc}
}

func (c *documentsClient) ListDocuments(ctx context.Context, in *ListDocumentsRequest, opts ...grpc.CallOption) (*ListDocumentsResponse, error) {
	out := new(ListDocumentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Documents/ListDocuments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentsClient) GetDocument(ctx context.Context, in *GetDocumentRequest, opts ...grpc.CallOption) (*Document, error) {
	out := new(Document)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Documents/GetDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentsClient) CreateDocument(ctx context.Context, in *CreateDocumentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Documents/CreateDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentsClient) DeleteDocument(ctx context.Context, in *DeleteDocumentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Documents/DeleteDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentsClient) UpdateDocument(ctx context.Context, in *UpdateDocumentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Documents/UpdateDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentsClient) ReloadDocument(ctx context.Context, in *ReloadDocumentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Documents/ReloadDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DocumentsServer is the server API for Documents service.
type DocumentsServer interface {
	// Returns the list of all documents of the knowledge base.
	//
	// Note: The `projects.agent.knowledgeBases.documents` resource is deprecated;
	// only use `projects.knowledgeBases.documents`.
	ListDocuments(context.Context, *ListDocumentsRequest) (*ListDocumentsResponse, error)
	// Retrieves the specified document.
	//
	// Note: The `projects.agent.knowledgeBases.documents` resource is deprecated;
	// only use `projects.knowledgeBases.documents`.
	GetDocument(context.Context, *GetDocumentRequest) (*Document, error)
	// Creates a new document.
	//
	// Note: The `projects.agent.knowledgeBases.documents` resource is deprecated;
	// only use `projects.knowledgeBases.documents`.
	//
	// Operation <response: [Document][google.cloud.dialogflow.v2beta1.Document],
	//            metadata: [KnowledgeOperationMetadata][google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata]>
	CreateDocument(context.Context, *CreateDocumentRequest) (*longrunning.Operation, error)
	// Deletes the specified document.
	//
	// Note: The `projects.agent.knowledgeBases.documents` resource is deprecated;
	// only use `projects.knowledgeBases.documents`.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty],
	//            metadata: [KnowledgeOperationMetadata][google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata]>
	DeleteDocument(context.Context, *DeleteDocumentRequest) (*longrunning.Operation, error)
	// Updates the specified document.
	//
	// Note: The `projects.agent.knowledgeBases.documents` resource is deprecated;
	// only use `projects.knowledgeBases.documents`.
	//
	// Operation <response: [Document][google.cloud.dialogflow.v2beta1.Document],
	//            metadata: [KnowledgeOperationMetadata][google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata]>
	UpdateDocument(context.Context, *UpdateDocumentRequest) (*longrunning.Operation, error)
	// Reloads the specified document from its specified source, content_uri or
	// content. The previously loaded content of the document will be deleted.
	// Note: Even when the content of the document has not changed, there still
	// may be side effects because of internal implementation changes.
	//
	// Note: The `projects.agent.knowledgeBases.documents` resource is deprecated;
	// only use `projects.knowledgeBases.documents`.
	//
	// Operation <response: [Document][google.cloud.dialogflow.v2beta1.Document],
	//            metadata: [KnowledgeOperationMetadata][google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata]>
	ReloadDocument(context.Context, *ReloadDocumentRequest) (*longrunning.Operation, error)
}

// UnimplementedDocumentsServer can be embedded to have forward compatible implementations.
type UnimplementedDocumentsServer struct {
}

func (*UnimplementedDocumentsServer) ListDocuments(ctx context.Context, req *ListDocumentsRequest) (*ListDocumentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDocuments not implemented")
}
func (*UnimplementedDocumentsServer) GetDocument(ctx context.Context, req *GetDocumentRequest) (*Document, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDocument not implemented")
}
func (*UnimplementedDocumentsServer) CreateDocument(ctx context.Context, req *CreateDocumentRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDocument not implemented")
}
func (*UnimplementedDocumentsServer) DeleteDocument(ctx context.Context, req *DeleteDocumentRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDocument not implemented")
}
func (*UnimplementedDocumentsServer) UpdateDocument(ctx context.Context, req *UpdateDocumentRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDocument not implemented")
}
func (*UnimplementedDocumentsServer) ReloadDocument(ctx context.Context, req *ReloadDocumentRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReloadDocument not implemented")
}

func RegisterDocumentsServer(s *grpc.Server, srv DocumentsServer) {
	s.RegisterService(&_Documents_serviceDesc, srv)
}

func _Documents_ListDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentsServer).ListDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Documents/ListDocuments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentsServer).ListDocuments(ctx, req.(*ListDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Documents_GetDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentsServer).GetDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Documents/GetDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentsServer).GetDocument(ctx, req.(*GetDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Documents_CreateDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentsServer).CreateDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Documents/CreateDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentsServer).CreateDocument(ctx, req.(*CreateDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Documents_DeleteDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentsServer).DeleteDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Documents/DeleteDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentsServer).DeleteDocument(ctx, req.(*DeleteDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Documents_UpdateDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentsServer).UpdateDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Documents/UpdateDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentsServer).UpdateDocument(ctx, req.(*UpdateDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Documents_ReloadDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReloadDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentsServer).ReloadDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Documents/ReloadDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentsServer).ReloadDocument(ctx, req.(*ReloadDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Documents_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2beta1.Documents",
	HandlerType: (*DocumentsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListDocuments",
			Handler:    _Documents_ListDocuments_Handler,
		},
		{
			MethodName: "GetDocument",
			Handler:    _Documents_GetDocument_Handler,
		},
		{
			MethodName: "CreateDocument",
			Handler:    _Documents_CreateDocument_Handler,
		},
		{
			MethodName: "DeleteDocument",
			Handler:    _Documents_DeleteDocument_Handler,
		},
		{
			MethodName: "UpdateDocument",
			Handler:    _Documents_UpdateDocument_Handler,
		},
		{
			MethodName: "ReloadDocument",
			Handler:    _Documents_ReloadDocument_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2beta1/document.proto",
}
