// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/logging/v2/logging.proto

package logging

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "github.com/golang/protobuf/ptypes/duration"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	monitoredres "google.golang.org/genproto/googleapis/api/monitoredres"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The parameters to DeleteLog.
type DeleteLogRequest struct {
	// Required. The resource name of the log to delete:
	//
	//     "projects/[PROJECT_ID]/logs/[LOG_ID]"
	//     "organizations/[ORGANIZATION_ID]/logs/[LOG_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]"
	//     "folders/[FOLDER_ID]/logs/[LOG_ID]"
	//
	// `[LOG_ID]` must be URL-encoded. For example,
	// `"projects/my-project-id/logs/syslog"`,
	// `"organizations/1234567890/logs/cloudresourcemanager.googleapis.com%2Factivity"`.
	// For more information about log names, see
	// [LogEntry][google.logging.v2.LogEntry].
	LogName              string   `protobuf:"bytes,1,opt,name=log_name,json=logName,proto3" json:"log_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteLogRequest) Reset()         { *m = DeleteLogRequest{} }
func (m *DeleteLogRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteLogRequest) ProtoMessage()    {}
func (*DeleteLogRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6a8ba408154557e4, []int{0}
}

func (m *DeleteLogRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteLogRequest.Unmarshal(m, b)
}
func (m *DeleteLogRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteLogRequest.Marshal(b, m, deterministic)
}
func (m *DeleteLogRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteLogRequest.Merge(m, src)
}
func (m *DeleteLogRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteLogRequest.Size(m)
}
func (m *DeleteLogRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteLogRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteLogRequest proto.InternalMessageInfo

func (m *DeleteLogRequest) GetLogName() string {
	if m != nil {
		return m.LogName
	}
	return ""
}

// The parameters to WriteLogEntries.
type WriteLogEntriesRequest struct {
	// Optional. A default log resource name that is assigned to all log entries
	// in `entries` that do not specify a value for `log_name`:
	//
	//     "projects/[PROJECT_ID]/logs/[LOG_ID]"
	//     "organizations/[ORGANIZATION_ID]/logs/[LOG_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]"
	//     "folders/[FOLDER_ID]/logs/[LOG_ID]"
	//
	// `[LOG_ID]` must be URL-encoded. For example:
	//
	//     "projects/my-project-id/logs/syslog"
	//     "organizations/1234567890/logs/cloudresourcemanager.googleapis.com%2Factivity"
	//
	// The permission `logging.logEntries.create` is needed on each project,
	// organization, billing account, or folder that is receiving new log
	// entries, whether the resource is specified in `logName` or in an
	// individual log entry.
	LogName string `protobuf:"bytes,1,opt,name=log_name,json=logName,proto3" json:"log_name,omitempty"`
	// Optional. A default monitored resource object that is assigned to all log
	// entries in `entries` that do not specify a value for `resource`. Example:
	//
	//     { "type": "gce_instance",
	//       "labels": {
	//         "zone": "us-central1-a", "instance_id": "00000000000000000000" }}
	//
	// See [LogEntry][google.logging.v2.LogEntry].
	Resource *monitoredres.MonitoredResource `protobuf:"bytes,2,opt,name=resource,proto3" json:"resource,omitempty"`
	// Optional. Default labels that are added to the `labels` field of all log
	// entries in `entries`. If a log entry already has a label with the same key
	// as a label in this parameter, then the log entry's label is not changed.
	// See [LogEntry][google.logging.v2.LogEntry].
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. The log entries to send to Logging. The order of log
	// entries in this list does not matter. Values supplied in this method's
	// `log_name`, `resource`, and `labels` fields are copied into those log
	// entries in this list that do not include values for their corresponding
	// fields. For more information, see the
	// [LogEntry][google.logging.v2.LogEntry] type.
	//
	// If the `timestamp` or `insert_id` fields are missing in log entries, then
	// this method supplies the current time or a unique identifier, respectively.
	// The supplied values are chosen so that, among the log entries that did not
	// supply their own values, the entries earlier in the list will sort before
	// the entries later in the list. See the `entries.list` method.
	//
	// Log entries with timestamps that are more than the
	// [logs retention period](/logging/quota-policy) in the past or more than
	// 24 hours in the future will not be available when calling `entries.list`.
	// However, those log entries can still be
	// [exported with LogSinks](/logging/docs/api/tasks/exporting-logs).
	//
	// To improve throughput and to avoid exceeding the
	// [quota limit](/logging/quota-policy) for calls to `entries.write`,
	// you should try to include several log entries in this list,
	// rather than calling this method for each individual log entry.
	Entries []*LogEntry `protobuf:"bytes,4,rep,name=entries,proto3" json:"entries,omitempty"`
	// Optional. Whether valid entries should be written even if some other
	// entries fail due to INVALID_ARGUMENT or PERMISSION_DENIED errors. If any
	// entry is not written, then the response status is the error associated
	// with one of the failed entries and the response includes error details
	// keyed by the entries' zero-based index in the `entries.write` method.
	PartialSuccess bool `protobuf:"varint,5,opt,name=partial_success,json=partialSuccess,proto3" json:"partial_success,omitempty"`
	// Optional. If true, the request should expect normal response, but the
	// entries won't be persisted nor exported. Useful for checking whether the
	// logging API endpoints are working properly before sending valuable data.
	DryRun               bool     `protobuf:"varint,6,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WriteLogEntriesRequest) Reset()         { *m = WriteLogEntriesRequest{} }
func (m *WriteLogEntriesRequest) String() string { return proto.CompactTextString(m) }
func (*WriteLogEntriesRequest) ProtoMessage()    {}
func (*WriteLogEntriesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6a8ba408154557e4, []int{1}
}

func (m *WriteLogEntriesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WriteLogEntriesRequest.Unmarshal(m, b)
}
func (m *WriteLogEntriesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WriteLogEntriesRequest.Marshal(b, m, deterministic)
}
func (m *WriteLogEntriesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WriteLogEntriesRequest.Merge(m, src)
}
func (m *WriteLogEntriesRequest) XXX_Size() int {
	return xxx_messageInfo_WriteLogEntriesRequest.Size(m)
}
func (m *WriteLogEntriesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_WriteLogEntriesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_WriteLogEntriesRequest proto.InternalMessageInfo

func (m *WriteLogEntriesRequest) GetLogName() string {
	if m != nil {
		return m.LogName
	}
	return ""
}

func (m *WriteLogEntriesRequest) GetResource() *monitoredres.MonitoredResource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *WriteLogEntriesRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *WriteLogEntriesRequest) GetEntries() []*LogEntry {
	if m != nil {
		return m.Entries
	}
	return nil
}

func (m *WriteLogEntriesRequest) GetPartialSuccess() bool {
	if m != nil {
		return m.PartialSuccess
	}
	return false
}

func (m *WriteLogEntriesRequest) GetDryRun() bool {
	if m != nil {
		return m.DryRun
	}
	return false
}

// Result returned from WriteLogEntries.
type WriteLogEntriesResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WriteLogEntriesResponse) Reset()         { *m = WriteLogEntriesResponse{} }
func (m *WriteLogEntriesResponse) String() string { return proto.CompactTextString(m) }
func (*WriteLogEntriesResponse) ProtoMessage()    {}
func (*WriteLogEntriesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6a8ba408154557e4, []int{2}
}

func (m *WriteLogEntriesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WriteLogEntriesResponse.Unmarshal(m, b)
}
func (m *WriteLogEntriesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WriteLogEntriesResponse.Marshal(b, m, deterministic)
}
func (m *WriteLogEntriesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WriteLogEntriesResponse.Merge(m, src)
}
func (m *WriteLogEntriesResponse) XXX_Size() int {
	return xxx_messageInfo_WriteLogEntriesResponse.Size(m)
}
func (m *WriteLogEntriesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_WriteLogEntriesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_WriteLogEntriesResponse proto.InternalMessageInfo

// Error details for WriteLogEntries with partial success.
type WriteLogEntriesPartialErrors struct {
	// When `WriteLogEntriesRequest.partial_success` is true, records the error
	// status for entries that were not written due to a permanent error, keyed
	// by the entry's zero-based index in `WriteLogEntriesRequest.entries`.
	//
	// Failed requests for which no entries are written will not include
	// per-entry errors.
	LogEntryErrors       map[int32]*status.Status `protobuf:"bytes,1,rep,name=log_entry_errors,json=logEntryErrors,proto3" json:"log_entry_errors,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *WriteLogEntriesPartialErrors) Reset()         { *m = WriteLogEntriesPartialErrors{} }
func (m *WriteLogEntriesPartialErrors) String() string { return proto.CompactTextString(m) }
func (*WriteLogEntriesPartialErrors) ProtoMessage()    {}
func (*WriteLogEntriesPartialErrors) Descriptor() ([]byte, []int) {
	return fileDescriptor_6a8ba408154557e4, []int{3}
}

func (m *WriteLogEntriesPartialErrors) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WriteLogEntriesPartialErrors.Unmarshal(m, b)
}
func (m *WriteLogEntriesPartialErrors) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WriteLogEntriesPartialErrors.Marshal(b, m, deterministic)
}
func (m *WriteLogEntriesPartialErrors) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WriteLogEntriesPartialErrors.Merge(m, src)
}
func (m *WriteLogEntriesPartialErrors) XXX_Size() int {
	return xxx_messageInfo_WriteLogEntriesPartialErrors.Size(m)
}
func (m *WriteLogEntriesPartialErrors) XXX_DiscardUnknown() {
	xxx_messageInfo_WriteLogEntriesPartialErrors.DiscardUnknown(m)
}

var xxx_messageInfo_WriteLogEntriesPartialErrors proto.InternalMessageInfo

func (m *WriteLogEntriesPartialErrors) GetLogEntryErrors() map[int32]*status.Status {
	if m != nil {
		return m.LogEntryErrors
	}
	return nil
}

// The parameters to `ListLogEntries`.
type ListLogEntriesRequest struct {
	// Required. Names of one or more parent resources from which to
	// retrieve log entries:
	//
	//     "projects/[PROJECT_ID]"
	//     "organizations/[ORGANIZATION_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]"
	//     "folders/[FOLDER_ID]"
	//
	//
	// Projects listed in the `project_ids` field are added to this list.
	ResourceNames []string `protobuf:"bytes,8,rep,name=resource_names,json=resourceNames,proto3" json:"resource_names,omitempty"`
	// Optional. A filter that chooses which log entries to return.  See [Advanced
	// Logs Queries](/logging/docs/view/advanced-queries).  Only log entries that
	// match the filter are returned.  An empty filter matches all log entries in
	// the resources listed in `resource_names`. Referencing a parent resource
	// that is not listed in `resource_names` will cause the filter to return no
	// results.
	// The maximum length of the filter is 20000 characters.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. How the results should be sorted.  Presently, the only permitted
	// values are `"timestamp asc"` (default) and `"timestamp desc"`. The first
	// option returns entries in order of increasing values of
	// `LogEntry.timestamp` (oldest first), and the second option returns entries
	// in order of decreasing timestamps (newest first).  Entries with equal
	// timestamps are returned in order of their `insert_id` values.
	OrderBy string `protobuf:"bytes,3,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Optional. The maximum number of results to return from this request.
	// Non-positive values are ignored.  The presence of `next_page_token` in the
	// response indicates that more results might be available.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. If present, then retrieve the next batch of results from the
	// preceding call to this method.  `page_token` must be the value of
	// `next_page_token` from the previous response.  The values of other method
	// parameters should be identical to those in the previous call.
	PageToken            string   `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListLogEntriesRequest) Reset()         { *m = ListLogEntriesRequest{} }
func (m *ListLogEntriesRequest) String() string { return proto.CompactTextString(m) }
func (*ListLogEntriesRequest) ProtoMessage()    {}
func (*ListLogEntriesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6a8ba408154557e4, []int{4}
}

func (m *ListLogEntriesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListLogEntriesRequest.Unmarshal(m, b)
}
func (m *ListLogEntriesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListLogEntriesRequest.Marshal(b, m, deterministic)
}
func (m *ListLogEntriesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListLogEntriesRequest.Merge(m, src)
}
func (m *ListLogEntriesRequest) XXX_Size() int {
	return xxx_messageInfo_ListLogEntriesRequest.Size(m)
}
func (m *ListLogEntriesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListLogEntriesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListLogEntriesRequest proto.InternalMessageInfo

func (m *ListLogEntriesRequest) GetResourceNames() []string {
	if m != nil {
		return m.ResourceNames
	}
	return nil
}

func (m *ListLogEntriesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListLogEntriesRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

func (m *ListLogEntriesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListLogEntriesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Result returned from `ListLogEntries`.
type ListLogEntriesResponse struct {
	// A list of log entries.  If `entries` is empty, `nextPageToken` may still be
	// returned, indicating that more entries may exist.  See `nextPageToken` for
	// more information.
	Entries []*LogEntry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
	// If there might be more results than those appearing in this response, then
	// `nextPageToken` is included.  To get the next set of results, call this
	// method again using the value of `nextPageToken` as `pageToken`.
	//
	// If a value for `next_page_token` appears and the `entries` field is empty,
	// it means that the search found no log entries so far but it did not have
	// time to search all the possible log entries.  Retry the method with this
	// value for `page_token` to continue the search.  Alternatively, consider
	// speeding up the search by changing your filter to specify a single log name
	// or resource type, or to narrow the time range of the search.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListLogEntriesResponse) Reset()         { *m = ListLogEntriesResponse{} }
func (m *ListLogEntriesResponse) String() string { return proto.CompactTextString(m) }
func (*ListLogEntriesResponse) ProtoMessage()    {}
func (*ListLogEntriesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6a8ba408154557e4, []int{5}
}

func (m *ListLogEntriesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListLogEntriesResponse.Unmarshal(m, b)
}
func (m *ListLogEntriesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListLogEntriesResponse.Marshal(b, m, deterministic)
}
func (m *ListLogEntriesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListLogEntriesResponse.Merge(m, src)
}
func (m *ListLogEntriesResponse) XXX_Size() int {
	return xxx_messageInfo_ListLogEntriesResponse.Size(m)
}
func (m *ListLogEntriesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListLogEntriesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListLogEntriesResponse proto.InternalMessageInfo

func (m *ListLogEntriesResponse) GetEntries() []*LogEntry {
	if m != nil {
		return m.Entries
	}
	return nil
}

func (m *ListLogEntriesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The parameters to ListMonitoredResourceDescriptors
type ListMonitoredResourceDescriptorsRequest struct {
	// Optional. The maximum number of results to return from this request.
	// Non-positive values are ignored.  The presence of `nextPageToken` in the
	// response indicates that more results might be available.
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. If present, then retrieve the next batch of results from the
	// preceding call to this method.  `pageToken` must be the value of
	// `nextPageToken` from the previous response.  The values of other method
	// parameters should be identical to those in the previous call.
	PageToken            string   `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListMonitoredResourceDescriptorsRequest) Reset() {
	*m = ListMonitoredResourceDescriptorsRequest{}
}
func (m *ListMonitoredResourceDescriptorsRequest) String() string { return proto.CompactTextString(m) }
func (*ListMonitoredResourceDescriptorsRequest) ProtoMessage()    {}
func (*ListMonitoredResourceDescriptorsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6a8ba408154557e4, []int{6}
}

func (m *ListMonitoredResourceDescriptorsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListMonitoredResourceDescriptorsRequest.Unmarshal(m, b)
}
func (m *ListMonitoredResourceDescriptorsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListMonitoredResourceDescriptorsRequest.Marshal(b, m, deterministic)
}
func (m *ListMonitoredResourceDescriptorsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListMonitoredResourceDescriptorsRequest.Merge(m, src)
}
func (m *ListMonitoredResourceDescriptorsRequest) XXX_Size() int {
	return xxx_messageInfo_ListMonitoredResourceDescriptorsRequest.Size(m)
}
func (m *ListMonitoredResourceDescriptorsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListMonitoredResourceDescriptorsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListMonitoredResourceDescriptorsRequest proto.InternalMessageInfo

func (m *ListMonitoredResourceDescriptorsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListMonitoredResourceDescriptorsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Result returned from ListMonitoredResourceDescriptors.
type ListMonitoredResourceDescriptorsResponse struct {
	// A list of resource descriptors.
	ResourceDescriptors []*monitoredres.MonitoredResourceDescriptor `protobuf:"bytes,1,rep,name=resource_descriptors,json=resourceDescriptors,proto3" json:"resource_descriptors,omitempty"`
	// If there might be more results than those appearing in this response, then
	// `nextPageToken` is included.  To get the next set of results, call this
	// method again using the value of `nextPageToken` as `pageToken`.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListMonitoredResourceDescriptorsResponse) Reset() {
	*m = ListMonitoredResourceDescriptorsResponse{}
}
func (m *ListMonitoredResourceDescriptorsResponse) String() string { return proto.CompactTextString(m) }
func (*ListMonitoredResourceDescriptorsResponse) ProtoMessage()    {}
func (*ListMonitoredResourceDescriptorsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6a8ba408154557e4, []int{7}
}

func (m *ListMonitoredResourceDescriptorsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListMonitoredResourceDescriptorsResponse.Unmarshal(m, b)
}
func (m *ListMonitoredResourceDescriptorsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListMonitoredResourceDescriptorsResponse.Marshal(b, m, deterministic)
}
func (m *ListMonitoredResourceDescriptorsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListMonitoredResourceDescriptorsResponse.Merge(m, src)
}
func (m *ListMonitoredResourceDescriptorsResponse) XXX_Size() int {
	return xxx_messageInfo_ListMonitoredResourceDescriptorsResponse.Size(m)
}
func (m *ListMonitoredResourceDescriptorsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListMonitoredResourceDescriptorsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListMonitoredResourceDescriptorsResponse proto.InternalMessageInfo

func (m *ListMonitoredResourceDescriptorsResponse) GetResourceDescriptors() []*monitoredres.MonitoredResourceDescriptor {
	if m != nil {
		return m.ResourceDescriptors
	}
	return nil
}

func (m *ListMonitoredResourceDescriptorsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The parameters to ListLogs.
type ListLogsRequest struct {
	// Required. The resource name that owns the logs:
	//
	//     "projects/[PROJECT_ID]"
	//     "organizations/[ORGANIZATION_ID]"
	//     "billingAccounts/[BILLING_ACCOUNT_ID]"
	//     "folders/[FOLDER_ID]"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of results to return from this request.
	// Non-positive values are ignored.  The presence of `nextPageToken` in the
	// response indicates that more results might be available.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. If present, then retrieve the next batch of results from the
	// preceding call to this method.  `pageToken` must be the value of
	// `nextPageToken` from the previous response.  The values of other method
	// parameters should be identical to those in the previous call.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListLogsRequest) Reset()         { *m = ListLogsRequest{} }
func (m *ListLogsRequest) String() string { return proto.CompactTextString(m) }
func (*ListLogsRequest) ProtoMessage()    {}
func (*ListLogsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6a8ba408154557e4, []int{8}
}

func (m *ListLogsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListLogsRequest.Unmarshal(m, b)
}
func (m *ListLogsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListLogsRequest.Marshal(b, m, deterministic)
}
func (m *ListLogsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListLogsRequest.Merge(m, src)
}
func (m *ListLogsRequest) XXX_Size() int {
	return xxx_messageInfo_ListLogsRequest.Size(m)
}
func (m *ListLogsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListLogsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListLogsRequest proto.InternalMessageInfo

func (m *ListLogsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListLogsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListLogsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Result returned from ListLogs.
type ListLogsResponse struct {
	// A list of log names. For example,
	// `"projects/my-project/logs/syslog"` or
	// `"organizations/123/logs/cloudresourcemanager.googleapis.com%2Factivity"`.
	LogNames []string `protobuf:"bytes,3,rep,name=log_names,json=logNames,proto3" json:"log_names,omitempty"`
	// If there might be more results than those appearing in this response, then
	// `nextPageToken` is included.  To get the next set of results, call this
	// method again using the value of `nextPageToken` as `pageToken`.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListLogsResponse) Reset()         { *m = ListLogsResponse{} }
func (m *ListLogsResponse) String() string { return proto.CompactTextString(m) }
func (*ListLogsResponse) ProtoMessage()    {}
func (*ListLogsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6a8ba408154557e4, []int{9}
}

func (m *ListLogsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListLogsResponse.Unmarshal(m, b)
}
func (m *ListLogsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListLogsResponse.Marshal(b, m, deterministic)
}
func (m *ListLogsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListLogsResponse.Merge(m, src)
}
func (m *ListLogsResponse) XXX_Size() int {
	return xxx_messageInfo_ListLogsResponse.Size(m)
}
func (m *ListLogsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListLogsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListLogsResponse proto.InternalMessageInfo

func (m *ListLogsResponse) GetLogNames() []string {
	if m != nil {
		return m.LogNames
	}
	return nil
}

func (m *ListLogsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*DeleteLogRequest)(nil), "google.logging.v2.DeleteLogRequest")
	proto.RegisterType((*WriteLogEntriesRequest)(nil), "google.logging.v2.WriteLogEntriesRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.logging.v2.WriteLogEntriesRequest.LabelsEntry")
	proto.RegisterType((*WriteLogEntriesResponse)(nil), "google.logging.v2.WriteLogEntriesResponse")
	proto.RegisterType((*WriteLogEntriesPartialErrors)(nil), "google.logging.v2.WriteLogEntriesPartialErrors")
	proto.RegisterMapType((map[int32]*status.Status)(nil), "google.logging.v2.WriteLogEntriesPartialErrors.LogEntryErrorsEntry")
	proto.RegisterType((*ListLogEntriesRequest)(nil), "google.logging.v2.ListLogEntriesRequest")
	proto.RegisterType((*ListLogEntriesResponse)(nil), "google.logging.v2.ListLogEntriesResponse")
	proto.RegisterType((*ListMonitoredResourceDescriptorsRequest)(nil), "google.logging.v2.ListMonitoredResourceDescriptorsRequest")
	proto.RegisterType((*ListMonitoredResourceDescriptorsResponse)(nil), "google.logging.v2.ListMonitoredResourceDescriptorsResponse")
	proto.RegisterType((*ListLogsRequest)(nil), "google.logging.v2.ListLogsRequest")
	proto.RegisterType((*ListLogsResponse)(nil), "google.logging.v2.ListLogsResponse")
}

func init() {
	proto.RegisterFile("google/logging/v2/logging.proto", fileDescriptor_6a8ba408154557e4)
}

var fileDescriptor_6a8ba408154557e4 = []byte{
	// 1281 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x57, 0xcf, 0x6f, 0x1b, 0xc5,
	0x17, 0xd7, 0xd8, 0x6d, 0x62, 0x4f, 0xbe, 0x4d, 0xdc, 0x69, 0x93, 0xba, 0x76, 0x9a, 0xba, 0x1b,
	0xb5, 0x71, 0x2d, 0x77, 0x57, 0xf2, 0x57, 0x95, 0x8a, 0x4b, 0x41, 0x4e, 0x5b, 0x21, 0xa4, 0x80,
	0x82, 0x03, 0xad, 0x14, 0x55, 0xb2, 0xd6, 0xeb, 0xf1, 0x76, 0xe8, 0xee, 0xce, 0x32, 0x3b, 0x9b,
	0xe0, 0xa2, 0x5e, 0x38, 0x71, 0xe1, 0xd4, 0x0b, 0x67, 0x38, 0xc1, 0xa1, 0x07, 0x0e, 0xfc, 0x07,
	0x48, 0xa8, 0x47, 0xb8, 0x45, 0x42, 0xea, 0xa1, 0xdc, 0x39, 0x22, 0x4e, 0x68, 0x67, 0x66, 0xd7,
	0xeb, 0x1f, 0xb5, 0x0d, 0xb7, 0xf5, 0xfb, 0x7c, 0xde, 0x9b, 0xf7, 0xde, 0xbc, 0xf7, 0x19, 0x19,
	0x5e, 0xb6, 0x29, 0xb5, 0x1d, 0x6c, 0x38, 0xd4, 0xb6, 0x89, 0x67, 0x1b, 0x47, 0x8d, 0xf8, 0x53,
	0xf7, 0x19, 0xe5, 0x14, 0x9d, 0x95, 0x04, 0x3d, 0xb6, 0x1e, 0x35, 0x4a, 0x17, 0x94, 0x8f, 0xe9,
	0x13, 0xc3, 0x72, 0x08, 0xf6, 0xb8, 0xe4, 0x96, 0x2e, 0xa7, 0x80, 0x3e, 0xc1, 0x4e, 0xaf, 0xd3,
	0xc5, 0x8f, 0xcd, 0x23, 0x42, 0x99, 0x22, 0x6c, 0xa7, 0x08, 0x2e, 0xf5, 0x08, 0xa7, 0x0c, 0xf7,
	0x3a, 0x0c, 0x07, 0x34, 0x64, 0x16, 0x56, 0xa4, 0x8b, 0x29, 0xd2, 0x18, 0x74, 0x65, 0x6a, 0xb6,
	0x1d, 0xec, 0x71, 0x36, 0x50, 0x94, 0x6b, 0x6f, 0x2c, 0xa8, 0x63, 0x51, 0xaf, 0x4f, 0x54, 0x5d,
	0xa5, 0x2d, 0xc5, 0x13, 0xbf, 0xba, 0x61, 0xdf, 0xe8, 0x85, 0xcc, 0xe4, 0x84, 0x7a, 0x0a, 0x2f,
	0x8f, 0xe3, 0xd8, 0xf5, 0xf9, 0x60, 0xac, 0xd0, 0x04, 0xe4, 0xc4, 0xc5, 0x01, 0x37, 0x5d, 0x5f,
	0x11, 0xe2, 0x16, 0x31, 0xdf, 0x32, 0x02, 0x6e, 0xf2, 0x30, 0x50, 0xc0, 0x66, 0xaa, 0x38, 0xd3,
	0xf3, 0x28, 0x17, 0x67, 0x2a, 0x54, 0xfb, 0x08, 0x16, 0xee, 0x61, 0x07, 0x73, 0xbc, 0x47, 0xed,
	0x36, 0xfe, 0x2c, 0xc4, 0x01, 0x47, 0x77, 0x60, 0x2e, 0xaa, 0xd1, 0x33, 0x5d, 0x5c, 0x04, 0x15,
	0x50, 0xcd, 0xef, 0x6a, 0xaf, 0x5a, 0x99, 0xbf, 0x5b, 0x9b, 0xb0, 0x14, 0xdf, 0x89, 0x8c, 0x69,
	0xfa, 0x24, 0xd0, 0x2d, 0xea, 0x1a, 0x91, 0xf3, 0xb2, 0x43, 0xed, 0x0f, 0x4d, 0x17, 0x6b, 0x2f,
	0xb2, 0x70, 0xe3, 0x21, 0x23, 0x22, 0xe4, 0x7d, 0x8f, 0x33, 0x82, 0x83, 0x99, 0x91, 0xc1, 0xa2,
	0x91, 0xd1, 0x3b, 0x30, 0x17, 0x5f, 0x4f, 0x31, 0x53, 0x01, 0xd5, 0x95, 0xc6, 0x25, 0xc5, 0xd7,
	0x4d, 0x9f, 0xe8, 0x1f, 0xc4, 0xf7, 0xdb, 0x56, 0xa4, 0xdd, 0xec, 0xab, 0x16, 0x68, 0x27, 0x3e,
	0xa8, 0x0d, 0x97, 0x1c, 0xb3, 0x8b, 0x9d, 0xa0, 0x98, 0xad, 0x64, 0xab, 0x2b, 0x8d, 0x9b, 0xfa,
	0xc4, 0xa8, 0xe9, 0xd3, 0x33, 0xd7, 0xf7, 0x84, 0x5f, 0x64, 0x1c, 0xc8, 0xa8, 0x2a, 0x12, 0x6a,
	0xc2, 0x65, 0x2c, 0xa9, 0xc5, 0x53, 0x22, 0x68, 0x79, 0x4a, 0x50, 0x15, 0x4f, 0xb8, 0x66, 0xda,
	0xb1, 0x03, 0xaa, 0xc3, 0x35, 0xdf, 0x64, 0x9c, 0x98, 0x4e, 0x27, 0x08, 0x2d, 0x0b, 0x07, 0x41,
	0xf1, 0x74, 0x05, 0x54, 0x73, 0xf2, 0x84, 0x55, 0x85, 0x1d, 0x48, 0x08, 0x6d, 0xc2, 0xe5, 0x1e,
	0x1b, 0x74, 0x58, 0xe8, 0x15, 0x97, 0x86, 0xac, 0xa5, 0x1e, 0x1b, 0xb4, 0x43, 0xaf, 0xf4, 0x16,
	0x5c, 0x49, 0xe5, 0x88, 0x0a, 0x30, 0xfb, 0x04, 0x0f, 0x64, 0x93, 0xdb, 0xd1, 0x27, 0x3a, 0x0f,
	0x4f, 0x1f, 0x99, 0x4e, 0x28, 0x3b, 0x97, 0x6f, 0xcb, 0x1f, 0xcd, 0xcc, 0x2d, 0xa0, 0x5d, 0x84,
	0x17, 0x26, 0xaa, 0x0e, 0x7c, 0xea, 0x05, 0x58, 0x7b, 0x0d, 0xe0, 0xe6, 0x18, 0xb6, 0x2f, 0xb3,
	0xba, 0xcf, 0x18, 0x65, 0x01, 0x72, 0x61, 0x21, 0xd9, 0x87, 0x0e, 0x16, 0xb6, 0x22, 0x10, 0x7d,
	0xb8, 0x3b, 0xbf, 0xb9, 0x23, 0xa1, 0x92, 0x26, 0xc9, 0x9f, 0xe2, 0xb3, 0xbd, 0xea, 0x8c, 0x18,
	0x4b, 0x9f, 0xc0, 0x73, 0x53, 0x68, 0xe9, 0x6a, 0x4f, 0xcb, 0x6a, 0xab, 0xe9, 0x6a, 0x57, 0x1a,
	0x28, 0x4e, 0x86, 0xf9, 0x96, 0x7e, 0x20, 0xd6, 0x23, 0xdd, 0x81, 0x3f, 0x00, 0x5c, 0xdf, 0x23,
	0x01, 0x9f, 0x9c, 0xd8, 0xf7, 0xe1, 0x6a, 0x3c, 0x3e, 0x62, 0x6c, 0x83, 0x62, 0xae, 0x92, 0x1d,
	0x6e, 0x04, 0x9a, 0x35, 0xb7, 0x67, 0x62, 0xcf, 0x68, 0x78, 0x03, 0x54, 0x86, 0x4b, 0x7d, 0xe2,
	0x70, 0xcc, 0xe4, 0x0d, 0xa8, 0xeb, 0x93, 0x26, 0xb4, 0x05, 0x73, 0x94, 0xf5, 0x30, 0xeb, 0x74,
	0x07, 0xc5, 0xec, 0x10, 0x5e, 0x16, 0xc6, 0xdd, 0x01, 0xaa, 0xc0, 0xbc, 0x6f, 0xda, 0xb8, 0x13,
	0x90, 0xa7, 0xb8, 0x78, 0x2a, 0xaa, 0x53, 0x0d, 0x77, 0x64, 0x3d, 0x20, 0x4f, 0x31, 0xd2, 0x20,
	0x14, 0x0c, 0x4e, 0x9f, 0x60, 0x4f, 0xcc, 0x91, 0x8a, 0x21, 0x1c, 0x3f, 0x8e, 0xac, 0xda, 0x31,
	0xdc, 0x18, 0x2f, 0x53, 0x5e, 0x34, 0xba, 0x39, 0x1c, 0x63, 0x30, 0x77, 0x8c, 0x87, 0x13, 0x7c,
	0x0d, 0xae, 0x79, 0xf8, 0x73, 0xde, 0x49, 0x9d, 0x2c, 0xc7, 0xeb, 0x4c, 0x64, 0xde, 0x4f, 0x0e,
	0xa6, 0x70, 0x27, 0x3a, 0x78, 0x62, 0x43, 0xef, 0xe1, 0xc0, 0x62, 0xc4, 0xe7, 0x94, 0x25, 0x1d,
	0x1f, 0xa9, 0x14, 0xcc, 0xaf, 0x34, 0x33, 0xb5, 0xd2, 0x17, 0x00, 0x56, 0xe7, 0x9f, 0xa8, 0x8a,
	0x3f, 0x84, 0xe7, 0x93, 0x4b, 0xee, 0x0d, 0x71, 0xd5, 0x89, 0x9d, 0x99, 0x1a, 0x33, 0x8c, 0xd7,
	0x3e, 0xc7, 0x26, 0xcf, 0x58, 0xb8, 0x43, 0xcf, 0x01, 0x5c, 0x53, 0x77, 0x93, 0xb4, 0xa2, 0x09,
	0x97, 0x7c, 0x93, 0x61, 0x8f, 0x8f, 0xca, 0xf0, 0xcc, 0xa1, 0x53, 0x1e, 0xa3, 0x6d, 0xcc, 0xcc,
	0x6f, 0x63, 0x76, 0x6a, 0x1b, 0x1f, 0xc2, 0xc2, 0x30, 0x29, 0xd5, 0xad, 0x32, 0xcc, 0xc7, 0x22,
	0x2e, 0x85, 0x34, 0xdf, 0xce, 0x29, 0x85, 0x5e, 0xb8, 0xdc, 0xc6, 0xef, 0x10, 0x16, 0xf6, 0x64,
	0x15, 0x07, 0x98, 0x1d, 0x11, 0x0b, 0x3f, 0x68, 0xa0, 0xe7, 0x19, 0x98, 0x4f, 0x5e, 0x23, 0xb4,
	0x3d, 0x65, 0x02, 0xc7, 0xdf, 0xaa, 0xd2, 0x46, 0x4c, 0x8a, 0x1f, 0x46, 0xfd, 0x7e, 0xf4, 0x6a,
	0x6a, 0xbf, 0x80, 0x93, 0x56, 0xf2, 0xd6, 0x7c, 0xf9, 0xdb, 0xeb, 0xe7, 0x99, 0x9f, 0x40, 0xad,
	0x12, 0xbd, 0xcd, 0x5f, 0xc4, 0xd6, 0x3b, 0x3e, 0xa3, 0x9f, 0x62, 0x8b, 0x07, 0x46, 0x2d, 0x7a,
	0xb0, 0x03, 0xa3, 0xf6, 0xec, 0xb0, 0x5c, 0xbb, 0x38, 0xca, 0xa9, 0xa5, 0xc0, 0x9d, 0xda, 0xd5,
	0x51, 0x90, 0x32, 0xdb, 0xf4, 0xc8, 0x53, 0xf9, 0xa0, 0xa6, 0x88, 0x57, 0x6a, 0x97, 0x47, 0x89,
	0x7d, 0xea, 0xf4, 0x30, 0x4b, 0x53, 0xae, 0xd7, 0x76, 0x46, 0x29, 0x5d, 0xe2, 0x38, 0xc4, 0xb3,
	0x5b, 0x96, 0x45, 0x43, 0x2f, 0x9d, 0x13, 0xfa, 0x1e, 0xc0, 0xb5, 0x31, 0xe1, 0x44, 0xd7, 0x17,
	0x7e, 0xb9, 0x4a, 0xb5, 0x45, 0xa8, 0x4a, 0xee, 0xdf, 0x3d, 0x69, 0x55, 0xe2, 0x8c, 0xea, 0xf1,
	0x34, 0xd7, 0xe5, 0x4b, 0x57, 0x57, 0x3b, 0x2f, 0x9a, 0xb9, 0xa1, 0x9d, 0x8d, 0xd2, 0x57, 0xa6,
	0xe6, 0x71, 0x14, 0xaf, 0x09, 0x6a, 0xe8, 0x3b, 0x00, 0x57, 0x47, 0x15, 0x06, 0x55, 0xa7, 0x09,
	0xc9, 0x34, 0xad, 0x2d, 0x5d, 0x5f, 0x80, 0xa9, 0x12, 0x7d, 0xfb, 0xa4, 0xb5, 0x35, 0xaa, 0xcb,
	0x75, 0x29, 0xa4, 0xf5, 0x58, 0x45, 0x45, 0x9a, 0xeb, 0x5a, 0x21, 0x9d, 0xa6, 0x43, 0x02, 0x1e,
	0x65, 0xf9, 0x33, 0x80, 0x95, 0x79, 0xe2, 0x80, 0x9a, 0x6f, 0xc8, 0x66, 0x01, 0x0d, 0x2b, 0xdd,
	0xfe, 0x4f, 0xbe, 0xaa, 0xb6, 0xaa, 0x48, 0x5d, 0x43, 0x62, 0x5a, 0xdd, 0x59, 0x29, 0x7e, 0x95,
	0x81, 0xb9, 0x78, 0x3d, 0x91, 0xf6, 0xe6, 0xee, 0x25, 0x79, 0x6d, 0xcf, 0xe4, 0xa8, 0xf3, 0x7f,
	0x04, 0x27, 0x2d, 0xa5, 0x22, 0x22, 0x93, 0x6f, 0x01, 0x5a, 0x17, 0xb3, 0x2a, 0x6d, 0xd1, 0x4a,
	0x3c, 0x13, 0xc3, 0x79, 0xb8, 0x85, 0x36, 0xd3, 0xc0, 0x70, 0x9f, 0x14, 0xbe, 0x8d, 0xae, 0xa4,
	0xf1, 0xb1, 0x75, 0x51, 0xa4, 0x4b, 0xa8, 0x9c, 0x26, 0x25, 0xab, 0xa2, 0xe0, 0xab, 0x68, 0x3b,
	0x0d, 0x4f, 0xac, 0x89, 0xa4, 0x95, 0xbe, 0xce, 0xbc, 0x6c, 0x6d, 0x4c, 0x97, 0xc5, 0x5f, 0x5b,
	0x7f, 0x82, 0xc7, 0x9c, 0xfb, 0x41, 0xd3, 0x30, 0x8e, 0x8f, 0x8f, 0xc7, 0x45, 0xd3, 0x0c, 0xf9,
	0x63, 0xc3, 0x72, 0x68, 0xd8, 0xbb, 0xe1, 0x3b, 0x26, 0xef, 0x53, 0xe6, 0xd6, 0xff, 0x1d, 0x5d,
	0x67, 0xd8, 0xec, 0xdd, 0xa0, 0x9e, 0x33, 0x98, 0xeb, 0x18, 0x67, 0x68, 0xf6, 0x5c, 0xe2, 0x2d,
	0xcc, 0x8e, 0xe2, 0x2f, 0x4c, 0x16, 0xbb, 0xb8, 0xfb, 0x0d, 0x80, 0xeb, 0x16, 0x75, 0x27, 0xef,
	0x7b, 0xf7, 0x7f, 0x4a, 0x76, 0xf7, 0x23, 0xc1, 0xdc, 0x07, 0x87, 0xb7, 0x14, 0xc5, 0xa6, 0x8e,
	0xe9, 0xd9, 0x3a, 0x65, 0xb6, 0x61, 0x63, 0x4f, 0xc8, 0xa9, 0x31, 0x3c, 0x27, 0xf5, 0xef, 0xe6,
	0xb6, 0xfa, 0xfc, 0x0b, 0x80, 0x1f, 0x32, 0x17, 0xde, 0x93, 0xde, 0x77, 0xa3, 0x8e, 0xe8, 0x2a,
	0xb4, 0xfe, 0xa0, 0xf1, 0x32, 0x46, 0x1e, 0x09, 0xe4, 0x91, 0x42, 0x1e, 0x3d, 0x68, 0x74, 0x97,
	0x44, 0xec, 0xff, 0xff, 0x13, 0x00, 0x00, 0xff, 0xff, 0xe7, 0xbf, 0x89, 0xb0, 0x09, 0x0e, 0x00,
	0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// LoggingServiceV2Client is the client API for LoggingServiceV2 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type LoggingServiceV2Client interface {
	// Deletes all the log entries in a log. The log reappears if it receives new
	// entries. Log entries written shortly before the delete operation might not
	// be deleted. Entries received after the delete operation with a timestamp
	// before the operation will be deleted.
	DeleteLog(ctx context.Context, in *DeleteLogRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Writes log entries to Logging. This API method is the
	// only way to send log entries to Logging. This method
	// is used, directly or indirectly, by the Logging agent
	// (fluentd) and all logging libraries configured to use Logging.
	// A single request may contain log entries for a maximum of 1000
	// different resources (projects, organizations, billing accounts or
	// folders)
	WriteLogEntries(ctx context.Context, in *WriteLogEntriesRequest, opts ...grpc.CallOption) (*WriteLogEntriesResponse, error)
	// Lists log entries.  Use this method to retrieve log entries that originated
	// from a project/folder/organization/billing account.  For ways to export log
	// entries, see [Exporting Logs](/logging/docs/export).
	ListLogEntries(ctx context.Context, in *ListLogEntriesRequest, opts ...grpc.CallOption) (*ListLogEntriesResponse, error)
	// Lists the descriptors for monitored resource types used by Logging.
	ListMonitoredResourceDescriptors(ctx context.Context, in *ListMonitoredResourceDescriptorsRequest, opts ...grpc.CallOption) (*ListMonitoredResourceDescriptorsResponse, error)
	// Lists the logs in projects, organizations, folders, or billing accounts.
	// Only logs that have entries are listed.
	ListLogs(ctx context.Context, in *ListLogsRequest, opts ...grpc.CallOption) (*ListLogsResponse, error)
}

type loggingServiceV2Client struct {
	cc grpc.ClientConnInterface
}

func NewLoggingServiceV2Client(cc grpc.ClientConnInterface) LoggingServiceV2Client {
	return &loggingServiceV2Client{cc}
}

func (c *loggingServiceV2Client) DeleteLog(ctx context.Context, in *DeleteLogRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.logging.v2.LoggingServiceV2/DeleteLog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *loggingServiceV2Client) WriteLogEntries(ctx context.Context, in *WriteLogEntriesRequest, opts ...grpc.CallOption) (*WriteLogEntriesResponse, error) {
	out := new(WriteLogEntriesResponse)
	err := c.cc.Invoke(ctx, "/google.logging.v2.LoggingServiceV2/WriteLogEntries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *loggingServiceV2Client) ListLogEntries(ctx context.Context, in *ListLogEntriesRequest, opts ...grpc.CallOption) (*ListLogEntriesResponse, error) {
	out := new(ListLogEntriesResponse)
	err := c.cc.Invoke(ctx, "/google.logging.v2.LoggingServiceV2/ListLogEntries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *loggingServiceV2Client) ListMonitoredResourceDescriptors(ctx context.Context, in *ListMonitoredResourceDescriptorsRequest, opts ...grpc.CallOption) (*ListMonitoredResourceDescriptorsResponse, error) {
	out := new(ListMonitoredResourceDescriptorsResponse)
	err := c.cc.Invoke(ctx, "/google.logging.v2.LoggingServiceV2/ListMonitoredResourceDescriptors", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *loggingServiceV2Client) ListLogs(ctx context.Context, in *ListLogsRequest, opts ...grpc.CallOption) (*ListLogsResponse, error) {
	out := new(ListLogsResponse)
	err := c.cc.Invoke(ctx, "/google.logging.v2.LoggingServiceV2/ListLogs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LoggingServiceV2Server is the server API for LoggingServiceV2 service.
type LoggingServiceV2Server interface {
	// Deletes all the log entries in a log. The log reappears if it receives new
	// entries. Log entries written shortly before the delete operation might not
	// be deleted. Entries received after the delete operation with a timestamp
	// before the operation will be deleted.
	DeleteLog(context.Context, *DeleteLogRequest) (*empty.Empty, error)
	// Writes log entries to Logging. This API method is the
	// only way to send log entries to Logging. This method
	// is used, directly or indirectly, by the Logging agent
	// (fluentd) and all logging libraries configured to use Logging.
	// A single request may contain log entries for a maximum of 1000
	// different resources (projects, organizations, billing accounts or
	// folders)
	WriteLogEntries(context.Context, *WriteLogEntriesRequest) (*WriteLogEntriesResponse, error)
	// Lists log entries.  Use this method to retrieve log entries that originated
	// from a project/folder/organization/billing account.  For ways to export log
	// entries, see [Exporting Logs](/logging/docs/export).
	ListLogEntries(context.Context, *ListLogEntriesRequest) (*ListLogEntriesResponse, error)
	// Lists the descriptors for monitored resource types used by Logging.
	ListMonitoredResourceDescriptors(context.Context, *ListMonitoredResourceDescriptorsRequest) (*ListMonitoredResourceDescriptorsResponse, error)
	// Lists the logs in projects, organizations, folders, or billing accounts.
	// Only logs that have entries are listed.
	ListLogs(context.Context, *ListLogsRequest) (*ListLogsResponse, error)
}

// UnimplementedLoggingServiceV2Server can be embedded to have forward compatible implementations.
type UnimplementedLoggingServiceV2Server struct {
}

func (*UnimplementedLoggingServiceV2Server) DeleteLog(ctx context.Context, req *DeleteLogRequest) (*empty.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteLog not implemented")
}
func (*UnimplementedLoggingServiceV2Server) WriteLogEntries(ctx context.Context, req *WriteLogEntriesRequest) (*WriteLogEntriesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method WriteLogEntries not implemented")
}
func (*UnimplementedLoggingServiceV2Server) ListLogEntries(ctx context.Context, req *ListLogEntriesRequest) (*ListLogEntriesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListLogEntries not implemented")
}
func (*UnimplementedLoggingServiceV2Server) ListMonitoredResourceDescriptors(ctx context.Context, req *ListMonitoredResourceDescriptorsRequest) (*ListMonitoredResourceDescriptorsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListMonitoredResourceDescriptors not implemented")
}
func (*UnimplementedLoggingServiceV2Server) ListLogs(ctx context.Context, req *ListLogsRequest) (*ListLogsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListLogs not implemented")
}

func RegisterLoggingServiceV2Server(s *grpc.Server, srv LoggingServiceV2Server) {
	s.RegisterService(&_LoggingServiceV2_serviceDesc, srv)
}

func _LoggingServiceV2_DeleteLog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteLogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoggingServiceV2Server).DeleteLog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.LoggingServiceV2/DeleteLog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoggingServiceV2Server).DeleteLog(ctx, req.(*DeleteLogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LoggingServiceV2_WriteLogEntries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WriteLogEntriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoggingServiceV2Server).WriteLogEntries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.LoggingServiceV2/WriteLogEntries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoggingServiceV2Server).WriteLogEntries(ctx, req.(*WriteLogEntriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LoggingServiceV2_ListLogEntries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLogEntriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoggingServiceV2Server).ListLogEntries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.LoggingServiceV2/ListLogEntries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoggingServiceV2Server).ListLogEntries(ctx, req.(*ListLogEntriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LoggingServiceV2_ListMonitoredResourceDescriptors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMonitoredResourceDescriptorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoggingServiceV2Server).ListMonitoredResourceDescriptors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.LoggingServiceV2/ListMonitoredResourceDescriptors",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoggingServiceV2Server).ListMonitoredResourceDescriptors(ctx, req.(*ListMonitoredResourceDescriptorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LoggingServiceV2_ListLogs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLogsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoggingServiceV2Server).ListLogs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.LoggingServiceV2/ListLogs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoggingServiceV2Server).ListLogs(ctx, req.(*ListLogsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _LoggingServiceV2_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.logging.v2.LoggingServiceV2",
	HandlerType: (*LoggingServiceV2Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DeleteLog",
			Handler:    _LoggingServiceV2_DeleteLog_Handler,
		},
		{
			MethodName: "WriteLogEntries",
			Handler:    _LoggingServiceV2_WriteLogEntries_Handler,
		},
		{
			MethodName: "ListLogEntries",
			Handler:    _LoggingServiceV2_ListLogEntries_Handler,
		},
		{
			MethodName: "ListMonitoredResourceDescriptors",
			Handler:    _LoggingServiceV2_ListMonitoredResourceDescriptors_Handler,
		},
		{
			MethodName: "ListLogs",
			Handler:    _LoggingServiceV2_ListLogs_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/logging/v2/logging.proto",
}
