package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AcceptInvitation invokes the baas.AcceptInvitation API synchronously
// api document: https://help.aliyun.com/api/baas/acceptinvitation.html
func (client *Client) AcceptInvitation(request *AcceptInvitationRequest) (response *AcceptInvitationResponse, err error) {
	response = CreateAcceptInvitationResponse()
	err = client.DoAction(request, response)
	return
}

// AcceptInvitationWithChan invokes the baas.AcceptInvitation API asynchronously
// api document: https://help.aliyun.com/api/baas/acceptinvitation.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AcceptInvitationWithChan(request *AcceptInvitationRequest) (<-chan *AcceptInvitationResponse, <-chan error) {
	responseChan := make(chan *AcceptInvitationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AcceptInvitation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AcceptInvitationWithCallback invokes the baas.AcceptInvitation API asynchronously
// api document: https://help.aliyun.com/api/baas/acceptinvitation.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AcceptInvitationWithCallback(request *AcceptInvitationRequest, callback func(response *AcceptInvitationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AcceptInvitationResponse
		var err error
		defer close(result)
		response, err = client.AcceptInvitation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AcceptInvitationRequest is the request struct for api AcceptInvitation
type AcceptInvitationRequest struct {
	*requests.RpcRequest
	Code       string           `position:"Body" name:"Code"`
	IsAccepted requests.Boolean `position:"Body" name:"IsAccepted"`
}

// AcceptInvitationResponse is the response struct for api AcceptInvitation
type AcceptInvitationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateAcceptInvitationRequest creates a request to invoke AcceptInvitation API
func CreateAcceptInvitationRequest() (request *AcceptInvitationRequest) {
	request = &AcceptInvitationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "AcceptInvitation", "", "")
	return
}

// CreateAcceptInvitationResponse creates a response to parse from AcceptInvitation response
func CreateAcceptInvitationResponse() (response *AcceptInvitationResponse) {
	response = &AcceptInvitationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
