package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// JoinChannel invokes the baas.JoinChannel API synchronously
// api document: https://help.aliyun.com/api/baas/joinchannel.html
func (client *Client) JoinChannel(request *JoinChannelRequest) (response *JoinChannelResponse, err error) {
	response = CreateJoinChannelResponse()
	err = client.DoAction(request, response)
	return
}

// JoinChannelWithChan invokes the baas.JoinChannel API asynchronously
// api document: https://help.aliyun.com/api/baas/joinchannel.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) JoinChannelWithChan(request *JoinChannelRequest) (<-chan *JoinChannelResponse, <-chan error) {
	responseChan := make(chan *JoinChannelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.JoinChannel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// JoinChannelWithCallback invokes the baas.JoinChannel API asynchronously
// api document: https://help.aliyun.com/api/baas/joinchannel.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) JoinChannelWithCallback(request *JoinChannelRequest, callback func(response *JoinChannelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *JoinChannelResponse
		var err error
		defer close(result)
		response, err = client.JoinChannel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// JoinChannelRequest is the request struct for api JoinChannel
type JoinChannelRequest struct {
	*requests.RpcRequest
	Location  string `position:"Body" name:"Location"`
	Do        string `position:"Query" name:"Do"`
	ChannelId string `position:"Query" name:"ChannelId"`
}

// JoinChannelResponse is the response struct for api JoinChannel
type JoinChannelResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Success   bool         `json:"Success" xml:"Success"`
	ErrorCode int          `json:"ErrorCode" xml:"ErrorCode"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateJoinChannelRequest creates a request to invoke JoinChannel API
func CreateJoinChannelRequest() (request *JoinChannelRequest) {
	request = &JoinChannelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "JoinChannel", "", "")
	return
}

// CreateJoinChannelResponse creates a response to parse from JoinChannel response
func CreateJoinChannelResponse() (response *JoinChannelResponse) {
	response = &JoinChannelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
