package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRequiredService invokes the emr.ListRequiredService API synchronously
// api document: https://help.aliyun.com/api/emr/listrequiredservice.html
func (client *Client) ListRequiredService(request *ListRequiredServiceRequest) (response *ListRequiredServiceResponse, err error) {
	response = CreateListRequiredServiceResponse()
	err = client.DoAction(request, response)
	return
}

// ListRequiredServiceWithChan invokes the emr.ListRequiredService API asynchronously
// api document: https://help.aliyun.com/api/emr/listrequiredservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListRequiredServiceWithChan(request *ListRequiredServiceRequest) (<-chan *ListRequiredServiceResponse, <-chan error) {
	responseChan := make(chan *ListRequiredServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRequiredService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRequiredServiceWithCallback invokes the emr.ListRequiredService API asynchronously
// api document: https://help.aliyun.com/api/emr/listrequiredservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListRequiredServiceWithCallback(request *ListRequiredServiceRequest, callback func(response *ListRequiredServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRequiredServiceResponse
		var err error
		defer close(result)
		response, err = client.ListRequiredService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRequiredServiceRequest is the request struct for api ListRequiredService
type ListRequiredServiceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	EmrVersion      string           `position:"Query" name:"EmrVersion"`
	ServiceNameList string           `position:"Query" name:"ServiceNameList"`
}

// ListRequiredServiceResponse is the response struct for api ListRequiredService
type ListRequiredServiceResponse struct {
	*responses.BaseResponse
	RequestId        string                           `json:"RequestId" xml:"RequestId"`
	NeedOtherService bool                             `json:"NeedOtherService" xml:"NeedOtherService"`
	ServiceList      ServiceListInListRequiredService `json:"ServiceList" xml:"ServiceList"`
}

// CreateListRequiredServiceRequest creates a request to invoke ListRequiredService API
func CreateListRequiredServiceRequest() (request *ListRequiredServiceRequest) {
	request = &ListRequiredServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListRequiredService", "emr", "openAPI")
	return
}

// CreateListRequiredServiceResponse creates a response to parse from ListRequiredService response
func CreateListRequiredServiceResponse() (response *ListRequiredServiceResponse) {
	response = &ListRequiredServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
