package ess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyAlertConfig invokes the ess.ModifyAlertConfig API synchronously
// api document: https://help.aliyun.com/api/ess/modifyalertconfig.html
func (client *Client) ModifyAlertConfig(request *ModifyAlertConfigRequest) (response *ModifyAlertConfigResponse, err error) {
	response = CreateModifyAlertConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyAlertConfigWithChan invokes the ess.ModifyAlertConfig API asynchronously
// api document: https://help.aliyun.com/api/ess/modifyalertconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyAlertConfigWithChan(request *ModifyAlertConfigRequest) (<-chan *ModifyAlertConfigResponse, <-chan error) {
	responseChan := make(chan *ModifyAlertConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyAlertConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyAlertConfigWithCallback invokes the ess.ModifyAlertConfig API asynchronously
// api document: https://help.aliyun.com/api/ess/modifyalertconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyAlertConfigWithCallback(request *ModifyAlertConfigRequest, callback func(response *ModifyAlertConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyAlertConfigResponse
		var err error
		defer close(result)
		response, err = client.ModifyAlertConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyAlertConfigRequest is the request struct for api ModifyAlertConfig
type ModifyAlertConfigRequest struct {
	*requests.RpcRequest
	RejectConfig         requests.Integer `position:"Query" name:"RejectConfig"`
	ScalingGroupId       string           `position:"Query" name:"ScalingGroupId"`
	FailConfig           requests.Integer `position:"Query" name:"FailConfig"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SuccessConfig        requests.Integer `position:"Query" name:"SuccessConfig"`
}

// ModifyAlertConfigResponse is the response struct for api ModifyAlertConfig
type ModifyAlertConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyAlertConfigRequest creates a request to invoke ModifyAlertConfig API
func CreateModifyAlertConfigRequest() (request *ModifyAlertConfigRequest) {
	request = &ModifyAlertConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ess", "2014-08-28", "ModifyAlertConfig", "ess", "openAPI")
	return
}

// CreateModifyAlertConfigResponse creates a response to parse from ModifyAlertConfig response
func CreateModifyAlertConfigResponse() (response *ModifyAlertConfigResponse) {
	response = &ModifyAlertConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
