//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package rtc

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeStatis invokes the rtc.DescribeStatis API synchronously
// api document: https://help.aliyun.com/api/rtc/describestatis.html
func (client *Client) DescribeStatis(request *DescribeStatisRequest) (response *DescribeStatisResponse, err error) {
	response = CreateDescribeStatisResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeStatisWithChan invokes the rtc.DescribeStatis API asynchronously
// api document: https://help.aliyun.com/api/rtc/describestatis.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeStatisWithChan(request *DescribeStatisRequest) (<-chan *DescribeStatisResponse, <-chan error) {
	responseChan := make(chan *DescribeStatisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeStatis(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeStatisWithCallback invokes the rtc.DescribeStatis API asynchronously
// api document: https://help.aliyun.com/api/rtc/describestatis.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeStatisWithCallback(request *DescribeStatisRequest, callback func(response *DescribeStatisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeStatisResponse
		var err error
		defer close(result)
		response, err = client.DescribeStatis(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeStatisRequest is the request struct for api DescribeStatis
type DescribeStatisRequest struct {
	*requests.RpcRequest
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	AppId       string           `position:"Query" name:"AppId"`
	StartTime   string           `position:"Query" name:"StartTime"`
	EndTime     string           `position:"Query" name:"EndTime"`
	SortType    string           `position:"Query" name:"SortType"`
	ServiceArea string           `position:"Query" name:"ServiceArea"`
	Interval    string           `position:"Query" name:"Interval"`
	DataType    string           `position:"Query" name:"DataType"`
}

// DescribeStatisResponse is the response struct for api DescribeStatis
type DescribeStatisResponse struct {
	*responses.BaseResponse
	RequestId   string                     `json:"RequestId" xml:"RequestId"`
	StatisInfos DescribeStatisStatisInfos0 `json:"StatisInfos" xml:"StatisInfos"`
}

type DescribeStatisStatisInfos0 struct {
	StatisInfo []DescribeStatisStatisInfo1 `json:"StatisInfo" xml:"StatisInfo"`
}

type DescribeStatisStatisInfo1 struct {
	Time          string                       `json:"Time" xml:"Time"`
	Duration      DescribeStatisDuration1      `json:"Duration" xml:"Duration"`
	UserStatis    DescribeStatisUserStatis1    `json:"UserStatis" xml:"UserStatis"`
	ChannelStatis DescribeStatisChannelStatis1 `json:"ChannelStatis" xml:"ChannelStatis"`
}

type DescribeStatisDuration1 struct {
	Duration []DescribeStatisDuration2 `json:"Duration" xml:"Duration"`
}

type DescribeStatisDuration2 struct {
	TotalDuration float32 `json:"TotalDuration" xml:"TotalDuration"`
	AudioDuration float32 `json:"AudioDuration" xml:"AudioDuration"`
	SdDuration    float32 `json:"SdDuration" xml:"SdDuration"`
	HdDuration    float32 `json:"HdDuration" xml:"HdDuration"`
	FhdDuration   float32 `json:"FhdDuration" xml:"FhdDuration"`
}

type DescribeStatisUserStatis1 struct {
	UserStatis []DescribeStatisUserStatis2 `json:"UserStatis" xml:"UserStatis"`
}

type DescribeStatisUserStatis2 struct {
	ActiveUserCnt      int64  `json:"ActiveUserCnt" xml:"ActiveUserCnt"`
	ConSessionPeak     int64  `json:"ConSessionPeak" xml:"ConSessionPeak"`
	ConSessionPeakTime string `json:"ConSessionPeakTime" xml:"ConSessionPeakTime"`
}

type DescribeStatisChannelStatis1 struct {
	ChannelStatis []DescribeStatisChannelStatis2 `json:"ChannelStatis" xml:"ChannelStatis"`
}

type DescribeStatisChannelStatis2 struct {
	AccChannelCnt      int64  `json:"AccChannelCnt" xml:"AccChannelCnt"`
	ConChannelPeak     int64  `json:"ConChannelPeak" xml:"ConChannelPeak"`
	ConChannelPeakTime string `json:"ConChannelPeakTime" xml:"ConChannelPeakTime"`
}

// CreateDescribeStatisRequest creates a request to invoke DescribeStatis API
func CreateDescribeStatisRequest() (request *DescribeStatisRequest) {
	request = &DescribeStatisRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "DescribeStatis", "rtc", "openAPI")
	return
}

// CreateDescribeStatisResponse creates a response to parse from DescribeStatis response
func CreateDescribeStatisResponse() (response *DescribeStatisResponse) {
	response = &DescribeStatisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
