//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package rtc

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyConference invokes the rtc.ModifyConference API synchronously
// api document: https://help.aliyun.com/api/rtc/modifyconference.html
func (client *Client) ModifyConference(request *ModifyConferenceRequest) (response *ModifyConferenceResponse, err error) {
	response = CreateModifyConferenceResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyConferenceWithChan invokes the rtc.ModifyConference API asynchronously
// api document: https://help.aliyun.com/api/rtc/modifyconference.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyConferenceWithChan(request *ModifyConferenceRequest) (<-chan *ModifyConferenceResponse, <-chan error) {
	responseChan := make(chan *ModifyConferenceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyConference(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyConferenceWithCallback invokes the rtc.ModifyConference API asynchronously
// api document: https://help.aliyun.com/api/rtc/modifyconference.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyConferenceWithCallback(request *ModifyConferenceRequest, callback func(response *ModifyConferenceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyConferenceResponse
		var err error
		defer close(result)
		response, err = client.ModifyConference(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyConferenceRequest is the request struct for api ModifyConference
type ModifyConferenceRequest struct {
	*requests.RpcRequest
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
	AppId          string           `position:"Query" name:"AppId"`
	ConferenceId   string           `position:"Query" name:"ConferenceId"`
	ConferenceName string           `position:"Query" name:"ConferenceName"`
	StartTime      string           `position:"Query" name:"StartTime"`
	Type           string           `position:"Query" name:"Type"`
	RemindNotice   requests.Integer `position:"Query" name:"RemindNotice"`
}

// ModifyConferenceResponse is the response struct for api ModifyConference
type ModifyConferenceResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ConferenceId string `json:"ConferenceId" xml:"ConferenceId"`
}

// CreateModifyConferenceRequest creates a request to invoke ModifyConference API
func CreateModifyConferenceRequest() (request *ModifyConferenceRequest) {
	request = &ModifyConferenceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "ModifyConference", "rtc", "openAPI")
	return
}

// CreateModifyConferenceResponse creates a response to parse from ModifyConference response
func CreateModifyConferenceResponse() (response *ModifyConferenceResponse) {
	response = &ModifyConferenceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
