package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBgpPeers invokes the vpc.DescribeBgpPeers API synchronously
// api document: https://help.aliyun.com/api/vpc/describebgppeers.html
func (client *Client) DescribeBgpPeers(request *DescribeBgpPeersRequest) (response *DescribeBgpPeersResponse, err error) {
	response = CreateDescribeBgpPeersResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBgpPeersWithChan invokes the vpc.DescribeBgpPeers API asynchronously
// api document: https://help.aliyun.com/api/vpc/describebgppeers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeBgpPeersWithChan(request *DescribeBgpPeersRequest) (<-chan *DescribeBgpPeersResponse, <-chan error) {
	responseChan := make(chan *DescribeBgpPeersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBgpPeers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBgpPeersWithCallback invokes the vpc.DescribeBgpPeers API asynchronously
// api document: https://help.aliyun.com/api/vpc/describebgppeers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeBgpPeersWithCallback(request *DescribeBgpPeersRequest, callback func(response *DescribeBgpPeersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBgpPeersResponse
		var err error
		defer close(result)
		response, err = client.DescribeBgpPeers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBgpPeersRequest is the request struct for api DescribeBgpPeers
type DescribeBgpPeersRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	RouterId             string           `position:"Query" name:"RouterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	BgpGroupId           string           `position:"Query" name:"BgpGroupId"`
	BgpPeerId            string           `position:"Query" name:"BgpPeerId"`
	IsDefault            requests.Boolean `position:"Query" name:"IsDefault"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
}

// DescribeBgpPeersResponse is the response struct for api DescribeBgpPeers
type DescribeBgpPeersResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	TotalCount int      `json:"TotalCount" xml:"TotalCount"`
	PageNumber int      `json:"PageNumber" xml:"PageNumber"`
	PageSize   int      `json:"PageSize" xml:"PageSize"`
	BgpPeers   BgpPeers `json:"BgpPeers" xml:"BgpPeers"`
}

// CreateDescribeBgpPeersRequest creates a request to invoke DescribeBgpPeers API
func CreateDescribeBgpPeersRequest() (request *DescribeBgpPeersRequest) {
	request = &DescribeBgpPeersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DescribeBgpPeers", "vpc", "openAPI")
	return
}

// CreateDescribeBgpPeersResponse creates a response to parse from DescribeBgpPeers response
func CreateDescribeBgpPeersResponse() (response *DescribeBgpPeersResponse) {
	response = &DescribeBgpPeersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
