---
layout: "api"
page_title: "/sys/config/cors - HTTP API"
sidebar_title: "<code>/sys/config/cors</code>"
sidebar_current: "api-http-system-config-cors"
description: |-
  The '/sys/config/cors' endpoint configures how the Vault server responds to cross-origin requests.
---

# `/sys/config/cors`

The `/sys/config/cors` endpoint is used to configure CORS settings.

- **`sudo` required** – All CORS endpoints require `sudo` capability in
  addition to any path-specific capabilities.

## Read CORS Settings

This endpoint returns the current CORS configuration.

| Method   | Path                         |
| :--------------------------- | :--------------------- |
| `GET`    | `/sys/config/cors` |

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    http://127.0.0.1:8200/v1/sys/config/cors
```

### Sample Response

```json
{
  "enabled": true,
  "allowed_origins": ["http://www.example.com"],
  "allowed_headers": [
    "Content-Type",
    "X-Requested-With",
    "X-Vault-AWS-IAM-Server-ID",
    "X-Vault-No-Request-Forwarding",
    "X-Vault-Token",
    "Authorization",
    "X-Vault-Wrap-Format",
    "X-Vault-Wrap-TTL",
  ]
}
```

## Configure CORS Settings

This endpoint allows configuring the origins that are permitted to make
cross-origin requests, as well as headers that are allowed on cross-origin requests.

| Method   | Path                         |
| :--------------------------- | :--------------------- |
| `PUT`    | `/sys/config/cors` |

### Parameters

- `allowed_origins` `(string or string array: <required>)` – A wildcard (`*`), comma-delimited string, or array of strings specifying the origins that are permitted to make cross-origin requests.

- `allowed_headers` `(string or string array: "" or [])` – A comma-delimited string or array of strings specifying headers that are permitted to be on cross-origin requests. Headers set via this parameter will be appended to the list of headers that Vault allows by default.

### Sample Payload

```json
{
  "allowed_origins": "*",
  "allowed_headers": "X-Custom-Header"
}
```

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request PUT \
    --data @payload.json \
    http://127.0.0.1:8200/v1/sys/config/cors
```

## Delete CORS Settings

This endpoint removes any CORS configuration.

| Method   | Path                         |
| :--------------------------- | :--------------------- |
| `DELETE` | `/sys/config/cors` |

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request DELETE \
    http://127.0.0.1:8200/v1/sys/config/cors
```
