package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeChaincodeUploadPolicy invokes the baas.DescribeChaincodeUploadPolicy API synchronously
// api document: https://help.aliyun.com/api/baas/describechaincodeuploadpolicy.html
func (client *Client) DescribeChaincodeUploadPolicy(request *DescribeChaincodeUploadPolicyRequest) (response *DescribeChaincodeUploadPolicyResponse, err error) {
	response = CreateDescribeChaincodeUploadPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeChaincodeUploadPolicyWithChan invokes the baas.DescribeChaincodeUploadPolicy API asynchronously
// api document: https://help.aliyun.com/api/baas/describechaincodeuploadpolicy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeChaincodeUploadPolicyWithChan(request *DescribeChaincodeUploadPolicyRequest) (<-chan *DescribeChaincodeUploadPolicyResponse, <-chan error) {
	responseChan := make(chan *DescribeChaincodeUploadPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeChaincodeUploadPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeChaincodeUploadPolicyWithCallback invokes the baas.DescribeChaincodeUploadPolicy API asynchronously
// api document: https://help.aliyun.com/api/baas/describechaincodeuploadpolicy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeChaincodeUploadPolicyWithCallback(request *DescribeChaincodeUploadPolicyRequest, callback func(response *DescribeChaincodeUploadPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeChaincodeUploadPolicyResponse
		var err error
		defer close(result)
		response, err = client.DescribeChaincodeUploadPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeChaincodeUploadPolicyRequest is the request struct for api DescribeChaincodeUploadPolicy
type DescribeChaincodeUploadPolicyRequest struct {
	*requests.RpcRequest
	OrganizationId string `position:"Body" name:"OrganizationId"`
}

// DescribeChaincodeUploadPolicyResponse is the response struct for api DescribeChaincodeUploadPolicy
type DescribeChaincodeUploadPolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeChaincodeUploadPolicyRequest creates a request to invoke DescribeChaincodeUploadPolicy API
func CreateDescribeChaincodeUploadPolicyRequest() (request *DescribeChaincodeUploadPolicyRequest) {
	request = &DescribeChaincodeUploadPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribeChaincodeUploadPolicy", "", "")
	return
}

// CreateDescribeChaincodeUploadPolicyResponse creates a response to parse from DescribeChaincodeUploadPolicy response
func CreateDescribeChaincodeUploadPolicyResponse() (response *DescribeChaincodeUploadPolicyResponse) {
	response = &DescribeChaincodeUploadPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
