package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOrganizationChannels invokes the baas.DescribeOrganizationChannels API synchronously
// api document: https://help.aliyun.com/api/baas/describeorganizationchannels.html
func (client *Client) DescribeOrganizationChannels(request *DescribeOrganizationChannelsRequest) (response *DescribeOrganizationChannelsResponse, err error) {
	response = CreateDescribeOrganizationChannelsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOrganizationChannelsWithChan invokes the baas.DescribeOrganizationChannels API asynchronously
// api document: https://help.aliyun.com/api/baas/describeorganizationchannels.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOrganizationChannelsWithChan(request *DescribeOrganizationChannelsRequest) (<-chan *DescribeOrganizationChannelsResponse, <-chan error) {
	responseChan := make(chan *DescribeOrganizationChannelsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOrganizationChannels(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOrganizationChannelsWithCallback invokes the baas.DescribeOrganizationChannels API asynchronously
// api document: https://help.aliyun.com/api/baas/describeorganizationchannels.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOrganizationChannelsWithCallback(request *DescribeOrganizationChannelsRequest, callback func(response *DescribeOrganizationChannelsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOrganizationChannelsResponse
		var err error
		defer close(result)
		response, err = client.DescribeOrganizationChannels(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOrganizationChannelsRequest is the request struct for api DescribeOrganizationChannels
type DescribeOrganizationChannelsRequest struct {
	*requests.RpcRequest
	OrganizationId string `position:"Query" name:"OrganizationId"`
	Location       string `position:"Body" name:"Location"`
}

// DescribeOrganizationChannelsResponse is the response struct for api DescribeOrganizationChannels
type DescribeOrganizationChannelsResponse struct {
	*responses.BaseResponse
	RequestId string                                     `json:"RequestId" xml:"RequestId"`
	Success   bool                                       `json:"Success" xml:"Success"`
	ErrorCode int                                        `json:"ErrorCode" xml:"ErrorCode"`
	Result    []ResultItemInDescribeOrganizationChannels `json:"Result" xml:"Result"`
}

// CreateDescribeOrganizationChannelsRequest creates a request to invoke DescribeOrganizationChannels API
func CreateDescribeOrganizationChannelsRequest() (request *DescribeOrganizationChannelsRequest) {
	request = &DescribeOrganizationChannelsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribeOrganizationChannels", "", "")
	return
}

// CreateDescribeOrganizationChannelsResponse creates a response to parse from DescribeOrganizationChannels response
func CreateDescribeOrganizationChannelsResponse() (response *DescribeOrganizationChannelsResponse) {
	response = &DescribeOrganizationChannelsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
