package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GroupDetails invokes the cloudwf.GroupDetails API synchronously
// api document: https://help.aliyun.com/api/cloudwf/groupdetails.html
func (client *Client) GroupDetails(request *GroupDetailsRequest) (response *GroupDetailsResponse, err error) {
	response = CreateGroupDetailsResponse()
	err = client.DoAction(request, response)
	return
}

// GroupDetailsWithChan invokes the cloudwf.GroupDetails API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/groupdetails.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GroupDetailsWithChan(request *GroupDetailsRequest) (<-chan *GroupDetailsResponse, <-chan error) {
	responseChan := make(chan *GroupDetailsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GroupDetails(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GroupDetailsWithCallback invokes the cloudwf.GroupDetails API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/groupdetails.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GroupDetailsWithCallback(request *GroupDetailsRequest, callback func(response *GroupDetailsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GroupDetailsResponse
		var err error
		defer close(result)
		response, err = client.GroupDetails(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GroupDetailsRequest is the request struct for api GroupDetails
type GroupDetailsRequest struct {
	*requests.RpcRequest
	Gsid requests.Integer `position:"Query" name:"Gsid"`
}

// GroupDetailsResponse is the response struct for api GroupDetails
type GroupDetailsResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateGroupDetailsRequest creates a request to invoke GroupDetails API
func CreateGroupDetailsRequest() (request *GroupDetailsRequest) {
	request = &GroupDetailsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "GroupDetails", "cloudwf", "openAPI")
	return
}

// CreateGroupDetailsResponse creates a response to parse from GroupDetails response
func CreateGroupDetailsResponse() (response *GroupDetailsResponse) {
	response = &GroupDetailsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
