// Code generated by protoc-gen-go4grpc; DO NOT EDIT
// source: maintner.proto

/*
Package maintpb is a generated protocol buffer package.

It is generated from these files:
	maintner.proto

It has these top-level messages:
	Mutation
	GithubMutation
	GithubIssueMutation
	BoolChange
	GithubLabel
	GithubMilestone
	GithubIssueEvent
	GithubDismissedReviewEvent
	GithubCommit
	GithubReview
	GithubIssueSyncStatus
	GithubIssueCommentMutation
	GithubUser
	GithubTeam
	GitMutation
	GitRepo
	GitCommit
	GitDiffTree
	GitDiffTreeFile
	GerritMutation
	GitRef
*/
package maintpb

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type Mutation struct {
	GithubIssue *GithubIssueMutation `protobuf:"bytes,1,opt,name=github_issue,json=githubIssue" json:"github_issue,omitempty"`
	Github      *GithubMutation      `protobuf:"bytes,3,opt,name=github" json:"github,omitempty"`
	Git         *GitMutation         `protobuf:"bytes,2,opt,name=git" json:"git,omitempty"`
	Gerrit      *GerritMutation      `protobuf:"bytes,4,opt,name=gerrit" json:"gerrit,omitempty"`
}

func (m *Mutation) Reset()                    { *m = Mutation{} }
func (m *Mutation) String() string            { return proto.CompactTextString(m) }
func (*Mutation) ProtoMessage()               {}
func (*Mutation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Mutation) GetGithubIssue() *GithubIssueMutation {
	if m != nil {
		return m.GithubIssue
	}
	return nil
}

func (m *Mutation) GetGithub() *GithubMutation {
	if m != nil {
		return m.Github
	}
	return nil
}

func (m *Mutation) GetGit() *GitMutation {
	if m != nil {
		return m.Git
	}
	return nil
}

func (m *Mutation) GetGerrit() *GerritMutation {
	if m != nil {
		return m.Gerrit
	}
	return nil
}

type GithubMutation struct {
	Owner string `protobuf:"bytes,1,opt,name=owner" json:"owner,omitempty"`
	Repo  string `protobuf:"bytes,2,opt,name=repo" json:"repo,omitempty"`
	// Updated labels. (All must have id set at least)
	Labels []*GithubLabel `protobuf:"bytes,3,rep,name=labels" json:"labels,omitempty"`
	// Updated milestones. (All must have id set at least)
	Milestones []*GithubMilestone `protobuf:"bytes,4,rep,name=milestones" json:"milestones,omitempty"`
}

func (m *GithubMutation) Reset()                    { *m = GithubMutation{} }
func (m *GithubMutation) String() string            { return proto.CompactTextString(m) }
func (*GithubMutation) ProtoMessage()               {}
func (*GithubMutation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *GithubMutation) GetOwner() string {
	if m != nil {
		return m.Owner
	}
	return ""
}

func (m *GithubMutation) GetRepo() string {
	if m != nil {
		return m.Repo
	}
	return ""
}

func (m *GithubMutation) GetLabels() []*GithubLabel {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *GithubMutation) GetMilestones() []*GithubMilestone {
	if m != nil {
		return m.Milestones
	}
	return nil
}

type GithubIssueMutation struct {
	Owner  string `protobuf:"bytes,1,opt,name=owner" json:"owner,omitempty"`
	Repo   string `protobuf:"bytes,2,opt,name=repo" json:"repo,omitempty"`
	Number int32  `protobuf:"varint,3,opt,name=number" json:"number,omitempty"`
	// not_exist is set true if the issue has been found to not exist.
	// If true, the owner/repo/number fields above must still be set.
	// If a future issue mutation for the same number arrives without
	// not_exist set, then the issue comes back to life.
	NotExist         bool                       `protobuf:"varint,13,opt,name=not_exist,json=notExist" json:"not_exist,omitempty"`
	Id               int64                      `protobuf:"varint,12,opt,name=id" json:"id,omitempty"`
	User             *GithubUser                `protobuf:"bytes,4,opt,name=user" json:"user,omitempty"`
	Assignees        []*GithubUser              `protobuf:"bytes,10,rep,name=assignees" json:"assignees,omitempty"`
	DeletedAssignees []int64                    `protobuf:"varint,11,rep,packed,name=deleted_assignees,json=deletedAssignees" json:"deleted_assignees,omitempty"`
	Created          *google_protobuf.Timestamp `protobuf:"bytes,5,opt,name=created" json:"created,omitempty"`
	Updated          *google_protobuf.Timestamp `protobuf:"bytes,6,opt,name=updated" json:"updated,omitempty"`
	Body             string                     `protobuf:"bytes,7,opt,name=body" json:"body,omitempty"`
	Title            string                     `protobuf:"bytes,9,opt,name=title" json:"title,omitempty"`
	NoMilestone      bool                       `protobuf:"varint,15,opt,name=no_milestone,json=noMilestone" json:"no_milestone,omitempty"`
	// When setting a milestone, only the milestone_id must be set.
	// TODO: allow num or title to be used if Github only returns those? So far unneeded.
	// The num and title, if non-zero, are treated as if they were a GithubMutation.Milestone update.
	MilestoneId    int64                         `protobuf:"varint,16,opt,name=milestone_id,json=milestoneId" json:"milestone_id,omitempty"`
	MilestoneNum   int64                         `protobuf:"varint,17,opt,name=milestone_num,json=milestoneNum" json:"milestone_num,omitempty"`
	MilestoneTitle string                        `protobuf:"bytes,18,opt,name=milestone_title,json=milestoneTitle" json:"milestone_title,omitempty"`
	Closed         *BoolChange                   `protobuf:"bytes,19,opt,name=closed" json:"closed,omitempty"`
	Locked         *BoolChange                   `protobuf:"bytes,25,opt,name=locked" json:"locked,omitempty"`
	PullRequest    bool                          `protobuf:"varint,28,opt,name=pull_request,json=pullRequest" json:"pull_request,omitempty"`
	ClosedAt       *google_protobuf.Timestamp    `protobuf:"bytes,21,opt,name=closed_at,json=closedAt" json:"closed_at,omitempty"`
	ClosedBy       *GithubUser                   `protobuf:"bytes,22,opt,name=closed_by,json=closedBy" json:"closed_by,omitempty"`
	RemoveLabel    []int64                       `protobuf:"varint,23,rep,packed,name=remove_label,json=removeLabel" json:"remove_label,omitempty"`
	AddLabel       []*GithubLabel                `protobuf:"bytes,24,rep,name=add_label,json=addLabel" json:"add_label,omitempty"`
	Comment        []*GithubIssueCommentMutation `protobuf:"bytes,8,rep,name=comment" json:"comment,omitempty"`
	CommentStatus  *GithubIssueSyncStatus        `protobuf:"bytes,14,opt,name=comment_status,json=commentStatus" json:"comment_status,omitempty"`
	Event          []*GithubIssueEvent           `protobuf:"bytes,26,rep,name=event" json:"event,omitempty"`
	EventStatus    *GithubIssueSyncStatus        `protobuf:"bytes,27,opt,name=event_status,json=eventStatus" json:"event_status,omitempty"`
	Review         []*GithubReview               `protobuf:"bytes,29,rep,name=review" json:"review,omitempty"`
	ReviewStatus   *GithubIssueSyncStatus        `protobuf:"bytes,30,opt,name=review_status,json=reviewStatus" json:"review_status,omitempty"`
}

func (m *GithubIssueMutation) Reset()                    { *m = GithubIssueMutation{} }
func (m *GithubIssueMutation) String() string            { return proto.CompactTextString(m) }
func (*GithubIssueMutation) ProtoMessage()               {}
func (*GithubIssueMutation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *GithubIssueMutation) GetOwner() string {
	if m != nil {
		return m.Owner
	}
	return ""
}

func (m *GithubIssueMutation) GetRepo() string {
	if m != nil {
		return m.Repo
	}
	return ""
}

func (m *GithubIssueMutation) GetNumber() int32 {
	if m != nil {
		return m.Number
	}
	return 0
}

func (m *GithubIssueMutation) GetNotExist() bool {
	if m != nil {
		return m.NotExist
	}
	return false
}

func (m *GithubIssueMutation) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *GithubIssueMutation) GetUser() *GithubUser {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *GithubIssueMutation) GetAssignees() []*GithubUser {
	if m != nil {
		return m.Assignees
	}
	return nil
}

func (m *GithubIssueMutation) GetDeletedAssignees() []int64 {
	if m != nil {
		return m.DeletedAssignees
	}
	return nil
}

func (m *GithubIssueMutation) GetCreated() *google_protobuf.Timestamp {
	if m != nil {
		return m.Created
	}
	return nil
}

func (m *GithubIssueMutation) GetUpdated() *google_protobuf.Timestamp {
	if m != nil {
		return m.Updated
	}
	return nil
}

func (m *GithubIssueMutation) GetBody() string {
	if m != nil {
		return m.Body
	}
	return ""
}

func (m *GithubIssueMutation) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *GithubIssueMutation) GetNoMilestone() bool {
	if m != nil {
		return m.NoMilestone
	}
	return false
}

func (m *GithubIssueMutation) GetMilestoneId() int64 {
	if m != nil {
		return m.MilestoneId
	}
	return 0
}

func (m *GithubIssueMutation) GetMilestoneNum() int64 {
	if m != nil {
		return m.MilestoneNum
	}
	return 0
}

func (m *GithubIssueMutation) GetMilestoneTitle() string {
	if m != nil {
		return m.MilestoneTitle
	}
	return ""
}

func (m *GithubIssueMutation) GetClosed() *BoolChange {
	if m != nil {
		return m.Closed
	}
	return nil
}

func (m *GithubIssueMutation) GetLocked() *BoolChange {
	if m != nil {
		return m.Locked
	}
	return nil
}

func (m *GithubIssueMutation) GetPullRequest() bool {
	if m != nil {
		return m.PullRequest
	}
	return false
}

func (m *GithubIssueMutation) GetClosedAt() *google_protobuf.Timestamp {
	if m != nil {
		return m.ClosedAt
	}
	return nil
}

func (m *GithubIssueMutation) GetClosedBy() *GithubUser {
	if m != nil {
		return m.ClosedBy
	}
	return nil
}

func (m *GithubIssueMutation) GetRemoveLabel() []int64 {
	if m != nil {
		return m.RemoveLabel
	}
	return nil
}

func (m *GithubIssueMutation) GetAddLabel() []*GithubLabel {
	if m != nil {
		return m.AddLabel
	}
	return nil
}

func (m *GithubIssueMutation) GetComment() []*GithubIssueCommentMutation {
	if m != nil {
		return m.Comment
	}
	return nil
}

func (m *GithubIssueMutation) GetCommentStatus() *GithubIssueSyncStatus {
	if m != nil {
		return m.CommentStatus
	}
	return nil
}

func (m *GithubIssueMutation) GetEvent() []*GithubIssueEvent {
	if m != nil {
		return m.Event
	}
	return nil
}

func (m *GithubIssueMutation) GetEventStatus() *GithubIssueSyncStatus {
	if m != nil {
		return m.EventStatus
	}
	return nil
}

func (m *GithubIssueMutation) GetReview() []*GithubReview {
	if m != nil {
		return m.Review
	}
	return nil
}

func (m *GithubIssueMutation) GetReviewStatus() *GithubIssueSyncStatus {
	if m != nil {
		return m.ReviewStatus
	}
	return nil
}

// BoolChange represents a change to a boolean value.
type BoolChange struct {
	Val bool `protobuf:"varint,1,opt,name=val" json:"val,omitempty"`
}

func (m *BoolChange) Reset()                    { *m = BoolChange{} }
func (m *BoolChange) String() string            { return proto.CompactTextString(m) }
func (*BoolChange) ProtoMessage()               {}
func (*BoolChange) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *BoolChange) GetVal() bool {
	if m != nil {
		return m.Val
	}
	return false
}

type GithubLabel struct {
	Id   int64  `protobuf:"varint,1,opt,name=id" json:"id,omitempty"`
	Name string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
}

func (m *GithubLabel) Reset()                    { *m = GithubLabel{} }
func (m *GithubLabel) String() string            { return proto.CompactTextString(m) }
func (*GithubLabel) ProtoMessage()               {}
func (*GithubLabel) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *GithubLabel) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *GithubLabel) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type GithubMilestone struct {
	Id int64 `protobuf:"varint,1,opt,name=id" json:"id,omitempty"`
	// Following only need to be non-zero on changes:
	Title  string      `protobuf:"bytes,2,opt,name=title" json:"title,omitempty"`
	Closed *BoolChange `protobuf:"bytes,3,opt,name=closed" json:"closed,omitempty"`
	Number int64       `protobuf:"varint,4,opt,name=number" json:"number,omitempty"`
}

func (m *GithubMilestone) Reset()                    { *m = GithubMilestone{} }
func (m *GithubMilestone) String() string            { return proto.CompactTextString(m) }
func (*GithubMilestone) ProtoMessage()               {}
func (*GithubMilestone) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *GithubMilestone) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *GithubMilestone) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *GithubMilestone) GetClosed() *BoolChange {
	if m != nil {
		return m.Closed
	}
	return nil
}

func (m *GithubMilestone) GetNumber() int64 {
	if m != nil {
		return m.Number
	}
	return 0
}

// See https://developer.github.com/v3/activity/events/types/#issuesevent
// for some info.
type GithubIssueEvent struct {
	// Required:
	Id int64 `protobuf:"varint,1,opt,name=id" json:"id,omitempty"`
	// event_type can be one of "assigned", "unassigned", "labeled",
	// "unlabeled", "opened", "edited", "milestoned", "demilestoned",
	// "closed", "reopened", "referenced", "renamed" or anything else
	// that Github adds in the future.
	EventType string                     `protobuf:"bytes,2,opt,name=event_type,json=eventType" json:"event_type,omitempty"`
	ActorId   int64                      `protobuf:"varint,3,opt,name=actor_id,json=actorId" json:"actor_id,omitempty"`
	Created   *google_protobuf.Timestamp `protobuf:"bytes,4,opt,name=created" json:"created,omitempty"`
	// label is populated for "labeled" and "unlabeled" events.
	// The label will usually not have an ID, due to Github's API
	// not returning one.
	Label *GithubLabel `protobuf:"bytes,5,opt,name=label" json:"label,omitempty"`
	// milestone is populated for "milestoned" and "demilestoned" events.
	// The label will usually not have an ID, due to Github's API
	// not returning one.
	Milestone *GithubMilestone `protobuf:"bytes,6,opt,name=milestone" json:"milestone,omitempty"`
	// For "assigned", "unassigned":
	AssigneeId int64 `protobuf:"varint,7,opt,name=assignee_id,json=assigneeId" json:"assignee_id,omitempty"`
	AssignerId int64 `protobuf:"varint,8,opt,name=assigner_id,json=assignerId" json:"assigner_id,omitempty"`
	// For "referenced", "closed":
	Commit *GithubCommit `protobuf:"bytes,9,opt,name=commit" json:"commit,omitempty"`
	// For "renamed" events:
	RenameFrom        string      `protobuf:"bytes,11,opt,name=rename_from,json=renameFrom" json:"rename_from,omitempty"`
	RenameTo          string      `protobuf:"bytes,12,opt,name=rename_to,json=renameTo" json:"rename_to,omitempty"`
	ReviewerId        int64       `protobuf:"varint,13,opt,name=reviewer_id,json=reviewerId" json:"reviewer_id,omitempty"`
	ReviewRequesterId int64       `protobuf:"varint,14,opt,name=review_requester_id,json=reviewRequesterId" json:"review_requester_id,omitempty"`
	TeamReviewer      *GithubTeam `protobuf:"bytes,16,opt,name=team_reviewer,json=teamReviewer" json:"team_reviewer,omitempty"`
	// Contents of a dismissed review event, see dismissed_review in
	// https://developer.github.com/v3/issues/events/ for more info
	DismissedReview *GithubDismissedReviewEvent `protobuf:"bytes,15,opt,name=dismissed_review,json=dismissedReview" json:"dismissed_review,omitempty"`
	// other_json is usually empty. If Github adds event types or fields
	// in the future, this captures those added fields. If non-empty it
	// will be a JSON object with the fields that weren't understood.
	OtherJson []byte `protobuf:"bytes,10,opt,name=other_json,json=otherJson,proto3" json:"other_json,omitempty"`
}

func (m *GithubIssueEvent) Reset()                    { *m = GithubIssueEvent{} }
func (m *GithubIssueEvent) String() string            { return proto.CompactTextString(m) }
func (*GithubIssueEvent) ProtoMessage()               {}
func (*GithubIssueEvent) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *GithubIssueEvent) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *GithubIssueEvent) GetEventType() string {
	if m != nil {
		return m.EventType
	}
	return ""
}

func (m *GithubIssueEvent) GetActorId() int64 {
	if m != nil {
		return m.ActorId
	}
	return 0
}

func (m *GithubIssueEvent) GetCreated() *google_protobuf.Timestamp {
	if m != nil {
		return m.Created
	}
	return nil
}

func (m *GithubIssueEvent) GetLabel() *GithubLabel {
	if m != nil {
		return m.Label
	}
	return nil
}

func (m *GithubIssueEvent) GetMilestone() *GithubMilestone {
	if m != nil {
		return m.Milestone
	}
	return nil
}

func (m *GithubIssueEvent) GetAssigneeId() int64 {
	if m != nil {
		return m.AssigneeId
	}
	return 0
}

func (m *GithubIssueEvent) GetAssignerId() int64 {
	if m != nil {
		return m.AssignerId
	}
	return 0
}

func (m *GithubIssueEvent) GetCommit() *GithubCommit {
	if m != nil {
		return m.Commit
	}
	return nil
}

func (m *GithubIssueEvent) GetRenameFrom() string {
	if m != nil {
		return m.RenameFrom
	}
	return ""
}

func (m *GithubIssueEvent) GetRenameTo() string {
	if m != nil {
		return m.RenameTo
	}
	return ""
}

func (m *GithubIssueEvent) GetReviewerId() int64 {
	if m != nil {
		return m.ReviewerId
	}
	return 0
}

func (m *GithubIssueEvent) GetReviewRequesterId() int64 {
	if m != nil {
		return m.ReviewRequesterId
	}
	return 0
}

func (m *GithubIssueEvent) GetTeamReviewer() *GithubTeam {
	if m != nil {
		return m.TeamReviewer
	}
	return nil
}

func (m *GithubIssueEvent) GetDismissedReview() *GithubDismissedReviewEvent {
	if m != nil {
		return m.DismissedReview
	}
	return nil
}

func (m *GithubIssueEvent) GetOtherJson() []byte {
	if m != nil {
		return m.OtherJson
	}
	return nil
}

// Contents of a dismissed review event - when someone leaves a
// review requesting changes and someone else dismisses it. See
// https://developer.github.com/v3/issues/events for more information.
type GithubDismissedReviewEvent struct {
	ReviewId         int64  `protobuf:"varint,1,opt,name=review_id,json=reviewId" json:"review_id,omitempty"`
	DismissalMessage string `protobuf:"bytes,3,opt,name=dismissal_message,json=dismissalMessage" json:"dismissal_message,omitempty"`
	State            string `protobuf:"bytes,4,opt,name=state" json:"state,omitempty"`
}

func (m *GithubDismissedReviewEvent) Reset()                    { *m = GithubDismissedReviewEvent{} }
func (m *GithubDismissedReviewEvent) String() string            { return proto.CompactTextString(m) }
func (*GithubDismissedReviewEvent) ProtoMessage()               {}
func (*GithubDismissedReviewEvent) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *GithubDismissedReviewEvent) GetReviewId() int64 {
	if m != nil {
		return m.ReviewId
	}
	return 0
}

func (m *GithubDismissedReviewEvent) GetDismissalMessage() string {
	if m != nil {
		return m.DismissalMessage
	}
	return ""
}

func (m *GithubDismissedReviewEvent) GetState() string {
	if m != nil {
		return m.State
	}
	return ""
}

type GithubCommit struct {
	Owner    string `protobuf:"bytes,1,opt,name=owner" json:"owner,omitempty"`
	Repo     string `protobuf:"bytes,2,opt,name=repo" json:"repo,omitempty"`
	CommitId string `protobuf:"bytes,3,opt,name=commit_id,json=commitId" json:"commit_id,omitempty"`
}

func (m *GithubCommit) Reset()                    { *m = GithubCommit{} }
func (m *GithubCommit) String() string            { return proto.CompactTextString(m) }
func (*GithubCommit) ProtoMessage()               {}
func (*GithubCommit) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *GithubCommit) GetOwner() string {
	if m != nil {
		return m.Owner
	}
	return ""
}

func (m *GithubCommit) GetRepo() string {
	if m != nil {
		return m.Repo
	}
	return ""
}

func (m *GithubCommit) GetCommitId() string {
	if m != nil {
		return m.CommitId
	}
	return ""
}

// Contents of a pull request review - when someone
// comments, requests changes, or approves changes
// on a pull request. See
// https://developer.github.com/v3/pulls/reviews/ for more information.
type GithubReview struct {
	// Required:
	Id               int64                      `protobuf:"varint,1,opt,name=id" json:"id,omitempty"`
	ActorId          int64                      `protobuf:"varint,2,opt,name=actor_id,json=actorId" json:"actor_id,omitempty"`
	Created          *google_protobuf.Timestamp `protobuf:"bytes,3,opt,name=created" json:"created,omitempty"`
	Body             string                     `protobuf:"bytes,4,opt,name=body" json:"body,omitempty"`
	State            string                     `protobuf:"bytes,5,opt,name=state" json:"state,omitempty"`
	CommitId         string                     `protobuf:"bytes,6,opt,name=commit_id,json=commitId" json:"commit_id,omitempty"`
	ActorAssociation string                     `protobuf:"bytes,7,opt,name=actor_association,json=actorAssociation" json:"actor_association,omitempty"`
	// other_json is usually empty.
	OtherJson []byte `protobuf:"bytes,8,opt,name=other_json,json=otherJson,proto3" json:"other_json,omitempty"`
}

func (m *GithubReview) Reset()                    { *m = GithubReview{} }
func (m *GithubReview) String() string            { return proto.CompactTextString(m) }
func (*GithubReview) ProtoMessage()               {}
func (*GithubReview) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *GithubReview) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *GithubReview) GetActorId() int64 {
	if m != nil {
		return m.ActorId
	}
	return 0
}

func (m *GithubReview) GetCreated() *google_protobuf.Timestamp {
	if m != nil {
		return m.Created
	}
	return nil
}

func (m *GithubReview) GetBody() string {
	if m != nil {
		return m.Body
	}
	return ""
}

func (m *GithubReview) GetState() string {
	if m != nil {
		return m.State
	}
	return ""
}

func (m *GithubReview) GetCommitId() string {
	if m != nil {
		return m.CommitId
	}
	return ""
}

func (m *GithubReview) GetActorAssociation() string {
	if m != nil {
		return m.ActorAssociation
	}
	return ""
}

func (m *GithubReview) GetOtherJson() []byte {
	if m != nil {
		return m.OtherJson
	}
	return nil
}

// GithubIssueSyncStatus notes where syncing is at for comments
// on an issue,
// This mutation type is only made at/after the same top-level mutation
// which created the corresponding comments.
type GithubIssueSyncStatus struct {
	// server_date is the "Date" response header from Github for the
	// final HTTP response.
	ServerDate *google_protobuf.Timestamp `protobuf:"bytes,1,opt,name=server_date,json=serverDate" json:"server_date,omitempty"`
}

func (m *GithubIssueSyncStatus) Reset()                    { *m = GithubIssueSyncStatus{} }
func (m *GithubIssueSyncStatus) String() string            { return proto.CompactTextString(m) }
func (*GithubIssueSyncStatus) ProtoMessage()               {}
func (*GithubIssueSyncStatus) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *GithubIssueSyncStatus) GetServerDate() *google_protobuf.Timestamp {
	if m != nil {
		return m.ServerDate
	}
	return nil
}

type GithubIssueCommentMutation struct {
	Id      int64                      `protobuf:"varint,1,opt,name=id" json:"id,omitempty"`
	User    *GithubUser                `protobuf:"bytes,2,opt,name=user" json:"user,omitempty"`
	Body    string                     `protobuf:"bytes,3,opt,name=body" json:"body,omitempty"`
	Created *google_protobuf.Timestamp `protobuf:"bytes,4,opt,name=created" json:"created,omitempty"`
	Updated *google_protobuf.Timestamp `protobuf:"bytes,5,opt,name=updated" json:"updated,omitempty"`
}

func (m *GithubIssueCommentMutation) Reset()                    { *m = GithubIssueCommentMutation{} }
func (m *GithubIssueCommentMutation) String() string            { return proto.CompactTextString(m) }
func (*GithubIssueCommentMutation) ProtoMessage()               {}
func (*GithubIssueCommentMutation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *GithubIssueCommentMutation) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *GithubIssueCommentMutation) GetUser() *GithubUser {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *GithubIssueCommentMutation) GetBody() string {
	if m != nil {
		return m.Body
	}
	return ""
}

func (m *GithubIssueCommentMutation) GetCreated() *google_protobuf.Timestamp {
	if m != nil {
		return m.Created
	}
	return nil
}

func (m *GithubIssueCommentMutation) GetUpdated() *google_protobuf.Timestamp {
	if m != nil {
		return m.Updated
	}
	return nil
}

type GithubUser struct {
	Id    int64  `protobuf:"varint,1,opt,name=id" json:"id,omitempty"`
	Login string `protobuf:"bytes,2,opt,name=login" json:"login,omitempty"`
}

func (m *GithubUser) Reset()                    { *m = GithubUser{} }
func (m *GithubUser) String() string            { return proto.CompactTextString(m) }
func (*GithubUser) ProtoMessage()               {}
func (*GithubUser) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *GithubUser) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *GithubUser) GetLogin() string {
	if m != nil {
		return m.Login
	}
	return ""
}

type GithubTeam struct {
	Id   int64  `protobuf:"varint,1,opt,name=id" json:"id,omitempty"`
	Slug string `protobuf:"bytes,2,opt,name=slug" json:"slug,omitempty"`
}

func (m *GithubTeam) Reset()                    { *m = GithubTeam{} }
func (m *GithubTeam) String() string            { return proto.CompactTextString(m) }
func (*GithubTeam) ProtoMessage()               {}
func (*GithubTeam) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *GithubTeam) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *GithubTeam) GetSlug() string {
	if m != nil {
		return m.Slug
	}
	return ""
}

type GitMutation struct {
	Repo *GitRepo `protobuf:"bytes,1,opt,name=repo" json:"repo,omitempty"`
	// commit adds a commit, or adds new information to a commit if fields
	// are added in the future.
	Commit *GitCommit `protobuf:"bytes,2,opt,name=commit" json:"commit,omitempty"`
}

func (m *GitMutation) Reset()                    { *m = GitMutation{} }
func (m *GitMutation) String() string            { return proto.CompactTextString(m) }
func (*GitMutation) ProtoMessage()               {}
func (*GitMutation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *GitMutation) GetRepo() *GitRepo {
	if m != nil {
		return m.Repo
	}
	return nil
}

func (m *GitMutation) GetCommit() *GitCommit {
	if m != nil {
		return m.Commit
	}
	return nil
}

// GitRepo identifies a git repo being mutated.
type GitRepo struct {
	// If go_repo is set, it identifies a go.googlesource.com/<go_repo> repo.
	GoRepo string `protobuf:"bytes,1,opt,name=go_repo,json=goRepo" json:"go_repo,omitempty"`
}

func (m *GitRepo) Reset()                    { *m = GitRepo{} }
func (m *GitRepo) String() string            { return proto.CompactTextString(m) }
func (*GitRepo) ProtoMessage()               {}
func (*GitRepo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *GitRepo) GetGoRepo() string {
	if m != nil {
		return m.GoRepo
	}
	return ""
}

type GitCommit struct {
	Sha1 string `protobuf:"bytes,1,opt,name=sha1" json:"sha1,omitempty"`
	// raw is the "git cat-file commit $sha1" output.
	Raw      []byte       `protobuf:"bytes,2,opt,name=raw,proto3" json:"raw,omitempty"`
	DiffTree *GitDiffTree `protobuf:"bytes,3,opt,name=diff_tree,json=diffTree" json:"diff_tree,omitempty"`
}

func (m *GitCommit) Reset()                    { *m = GitCommit{} }
func (m *GitCommit) String() string            { return proto.CompactTextString(m) }
func (*GitCommit) ProtoMessage()               {}
func (*GitCommit) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *GitCommit) GetSha1() string {
	if m != nil {
		return m.Sha1
	}
	return ""
}

func (m *GitCommit) GetRaw() []byte {
	if m != nil {
		return m.Raw
	}
	return nil
}

func (m *GitCommit) GetDiffTree() *GitDiffTree {
	if m != nil {
		return m.DiffTree
	}
	return nil
}

// git diff-tree --numstat oldtree newtree
type GitDiffTree struct {
	File []*GitDiffTreeFile `protobuf:"bytes,1,rep,name=file" json:"file,omitempty"`
}

func (m *GitDiffTree) Reset()                    { *m = GitDiffTree{} }
func (m *GitDiffTree) String() string            { return proto.CompactTextString(m) }
func (*GitDiffTree) ProtoMessage()               {}
func (*GitDiffTree) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *GitDiffTree) GetFile() []*GitDiffTreeFile {
	if m != nil {
		return m.File
	}
	return nil
}

// GitDiffTreeFile represents one line of `git diff-tree --numstat` output.
type GitDiffTreeFile struct {
	File    string `protobuf:"bytes,1,opt,name=file" json:"file,omitempty"`
	Added   int64  `protobuf:"varint,2,opt,name=added" json:"added,omitempty"`
	Deleted int64  `protobuf:"varint,3,opt,name=deleted" json:"deleted,omitempty"`
	Binary  bool   `protobuf:"varint,4,opt,name=binary" json:"binary,omitempty"`
}

func (m *GitDiffTreeFile) Reset()                    { *m = GitDiffTreeFile{} }
func (m *GitDiffTreeFile) String() string            { return proto.CompactTextString(m) }
func (*GitDiffTreeFile) ProtoMessage()               {}
func (*GitDiffTreeFile) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *GitDiffTreeFile) GetFile() string {
	if m != nil {
		return m.File
	}
	return ""
}

func (m *GitDiffTreeFile) GetAdded() int64 {
	if m != nil {
		return m.Added
	}
	return 0
}

func (m *GitDiffTreeFile) GetDeleted() int64 {
	if m != nil {
		return m.Deleted
	}
	return 0
}

func (m *GitDiffTreeFile) GetBinary() bool {
	if m != nil {
		return m.Binary
	}
	return false
}

type GerritMutation struct {
	// Project is the Gerrit server and project, without scheme (https implied) or
	// trailing slash.
	Project string `protobuf:"bytes,1,opt,name=project" json:"project,omitempty"`
	// Commits to add.
	Commits []*GitCommit `protobuf:"bytes,2,rep,name=commits" json:"commits,omitempty"`
	// git refs to update.
	Refs []*GitRef `protobuf:"bytes,3,rep,name=refs" json:"refs,omitempty"`
}

func (m *GerritMutation) Reset()                    { *m = GerritMutation{} }
func (m *GerritMutation) String() string            { return proto.CompactTextString(m) }
func (*GerritMutation) ProtoMessage()               {}
func (*GerritMutation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *GerritMutation) GetProject() string {
	if m != nil {
		return m.Project
	}
	return ""
}

func (m *GerritMutation) GetCommits() []*GitCommit {
	if m != nil {
		return m.Commits
	}
	return nil
}

func (m *GerritMutation) GetRefs() []*GitRef {
	if m != nil {
		return m.Refs
	}
	return nil
}

type GitRef struct {
	// ref is the git ref name, such as:
	//    HEAD
	//    refs/heads/master
	//    refs/changes/00/14700/1
	//    refs/changes/00/14700/meta
	//    refs/meta/config
	Ref string `protobuf:"bytes,1,opt,name=ref" json:"ref,omitempty"`
	// sha1 is the lowercase hex sha1
	Sha1 string `protobuf:"bytes,2,opt,name=sha1" json:"sha1,omitempty"`
}

func (m *GitRef) Reset()                    { *m = GitRef{} }
func (m *GitRef) String() string            { return proto.CompactTextString(m) }
func (*GitRef) ProtoMessage()               {}
func (*GitRef) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *GitRef) GetRef() string {
	if m != nil {
		return m.Ref
	}
	return ""
}

func (m *GitRef) GetSha1() string {
	if m != nil {
		return m.Sha1
	}
	return ""
}

func init() {
	proto.RegisterType((*Mutation)(nil), "maintpb.Mutation")
	proto.RegisterType((*GithubMutation)(nil), "maintpb.GithubMutation")
	proto.RegisterType((*GithubIssueMutation)(nil), "maintpb.GithubIssueMutation")
	proto.RegisterType((*BoolChange)(nil), "maintpb.BoolChange")
	proto.RegisterType((*GithubLabel)(nil), "maintpb.GithubLabel")
	proto.RegisterType((*GithubMilestone)(nil), "maintpb.GithubMilestone")
	proto.RegisterType((*GithubIssueEvent)(nil), "maintpb.GithubIssueEvent")
	proto.RegisterType((*GithubDismissedReviewEvent)(nil), "maintpb.GithubDismissedReviewEvent")
	proto.RegisterType((*GithubCommit)(nil), "maintpb.GithubCommit")
	proto.RegisterType((*GithubReview)(nil), "maintpb.GithubReview")
	proto.RegisterType((*GithubIssueSyncStatus)(nil), "maintpb.GithubIssueSyncStatus")
	proto.RegisterType((*GithubIssueCommentMutation)(nil), "maintpb.GithubIssueCommentMutation")
	proto.RegisterType((*GithubUser)(nil), "maintpb.GithubUser")
	proto.RegisterType((*GithubTeam)(nil), "maintpb.GithubTeam")
	proto.RegisterType((*GitMutation)(nil), "maintpb.GitMutation")
	proto.RegisterType((*GitRepo)(nil), "maintpb.GitRepo")
	proto.RegisterType((*GitCommit)(nil), "maintpb.GitCommit")
	proto.RegisterType((*GitDiffTree)(nil), "maintpb.GitDiffTree")
	proto.RegisterType((*GitDiffTreeFile)(nil), "maintpb.GitDiffTreeFile")
	proto.RegisterType((*GerritMutation)(nil), "maintpb.GerritMutation")
	proto.RegisterType((*GitRef)(nil), "maintpb.GitRef")
}

func init() { proto.RegisterFile("maintner.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1489 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x57, 0xeb, 0x6e, 0xdb, 0xb6,
	0x17, 0x87, 0xef, 0xd2, 0xb1, 0xe3, 0xb8, 0x4c, 0x2f, 0x6c, 0x7a, 0xf9, 0xe7, 0xaf, 0x0e, 0x6b,
	0xd0, 0x8b, 0xd3, 0x76, 0xc3, 0x56, 0xa0, 0x18, 0x86, 0x34, 0x6d, 0x07, 0x17, 0x6b, 0x3f, 0xb0,
	0xe9, 0x67, 0x41, 0xb6, 0x68, 0x47, 0x9d, 0x24, 0x7a, 0x12, 0x9d, 0x2e, 0xc0, 0xf6, 0xa5, 0x2f,
	0x32, 0x60, 0xef, 0xb4, 0x27, 0xd8, 0x8b, 0x0c, 0x3c, 0x24, 0x25, 0xd9, 0x71, 0x9a, 0x74, 0xdf,
	0x78, 0xce, 0xf9, 0x1d, 0xf2, 0xf0, 0x5c, 0x49, 0xe8, 0x27, 0x41, 0x94, 0xca, 0x94, 0x67, 0xc3,
	0x79, 0x26, 0xa4, 0x20, 0x1d, 0xa4, 0xe7, 0xe3, 0xed, 0x67, 0xb3, 0x48, 0x1e, 0x2d, 0xc6, 0xc3,
	0x89, 0x48, 0xf6, 0x66, 0x22, 0x0e, 0xd2, 0xd9, 0x1e, 0x22, 0xc6, 0x8b, 0xe9, 0xde, 0x5c, 0x9e,
	0xcc, 0x79, 0xbe, 0x27, 0xa3, 0x84, 0xe7, 0x32, 0x48, 0xe6, 0xe5, 0x4a, 0xef, 0xe2, 0xfd, 0x5d,
	0x03, 0xe7, 0xcd, 0x42, 0x06, 0x32, 0x12, 0x29, 0xf9, 0x11, 0x7a, 0x7a, 0x2f, 0x3f, 0xca, 0xf3,
	0x05, 0xa7, 0xb5, 0x9d, 0xda, 0x6e, 0xf7, 0xc9, 0xcd, 0xa1, 0x39, 0x69, 0xf8, 0x13, 0x0a, 0x47,
	0x4a, 0x66, 0x75, 0x58, 0x77, 0x56, 0x32, 0xc9, 0x1e, 0xb4, 0x35, 0x49, 0x1b, 0xa8, 0x7a, 0x6d,
	0x45, 0xb5, 0xd0, 0x32, 0x30, 0xf2, 0x35, 0x34, 0x66, 0x91, 0xa4, 0x75, 0x44, 0x5f, 0xae, 0xa2,
	0x0b, 0xa8, 0x02, 0xe0, 0xc6, 0x3c, 0xcb, 0x22, 0x49, 0x9b, 0xab, 0x1b, 0x23, 0xbb, 0xb2, 0x31,
	0xd2, 0xde, 0x5f, 0x35, 0xe8, 0x2f, 0x9f, 0x49, 0x2e, 0x43, 0x4b, 0x7c, 0x4c, 0x79, 0x86, 0xd7,
	0x72, 0x99, 0x26, 0x08, 0x81, 0x66, 0xc6, 0xe7, 0x02, 0x4d, 0x70, 0x19, 0xae, 0xc9, 0x03, 0x68,
	0xc7, 0xc1, 0x98, 0xc7, 0x39, 0x6d, 0xec, 0x34, 0x56, 0x0d, 0x3b, 0x5a, 0x8c, 0x7f, 0x56, 0x42,
	0x66, 0x30, 0xe4, 0x29, 0x40, 0x12, 0xc5, 0x3c, 0x97, 0x22, 0xe5, 0x39, 0x6d, 0xa2, 0x06, 0x5d,
	0xbd, 0xb8, 0x05, 0xb0, 0x0a, 0xd6, 0xfb, 0xc7, 0x85, 0xad, 0x35, 0x3e, 0xfd, 0x02, 0x4b, 0xaf,
	0x42, 0x3b, 0x5d, 0x24, 0x63, 0x9e, 0xa1, 0xc3, 0x5b, 0xcc, 0x50, 0xe4, 0x06, 0xb8, 0xa9, 0x90,
	0x3e, 0xff, 0x2d, 0xca, 0x25, 0xdd, 0xd8, 0xa9, 0xed, 0x3a, 0xcc, 0x49, 0x85, 0x7c, 0xa9, 0x68,
	0xd2, 0x87, 0x7a, 0x14, 0xd2, 0xde, 0x4e, 0x6d, 0xb7, 0xc1, 0xea, 0x51, 0x48, 0xee, 0x42, 0x73,
	0x91, 0xf3, 0xcc, 0xb8, 0x76, 0x6b, 0xc5, 0xf4, 0xf7, 0x39, 0xcf, 0x18, 0x02, 0xc8, 0x63, 0x70,
	0x83, 0x3c, 0x8f, 0x66, 0x29, 0xe7, 0x39, 0x05, 0xbc, 0xe8, 0x5a, 0x74, 0x89, 0x22, 0xf7, 0xe1,
	0x52, 0xc8, 0x63, 0x2e, 0x79, 0xe8, 0x97, 0xaa, 0xdd, 0x9d, 0xc6, 0x6e, 0x83, 0x0d, 0x8c, 0x60,
	0xbf, 0x00, 0x7f, 0x0b, 0x9d, 0x49, 0xc6, 0x03, 0xc9, 0x43, 0xda, 0x42, 0x5b, 0xb6, 0x87, 0x33,
	0x21, 0x66, 0x31, 0x1f, 0xda, 0x84, 0x1e, 0x1e, 0xda, 0xfc, 0x65, 0x16, 0xaa, 0xb4, 0x16, 0xf3,
	0x10, 0xb5, 0xda, 0xe7, 0x6b, 0x19, 0xa8, 0xf2, 0xe6, 0x58, 0x84, 0x27, 0xb4, 0xa3, 0xbd, 0xa9,
	0xd6, 0xca, 0xef, 0x32, 0x92, 0x31, 0xa7, 0xae, 0xf6, 0x3b, 0x12, 0xe4, 0xff, 0xd0, 0x4b, 0x85,
	0x5f, 0x84, 0x8d, 0x6e, 0xa2, 0x3b, 0xbb, 0xa9, 0x28, 0x82, 0xaa, 0x20, 0x85, 0xdc, 0x8f, 0x42,
	0x3a, 0x40, 0xdf, 0x76, 0x0b, 0xde, 0x28, 0x24, 0x77, 0x60, 0xa3, 0x84, 0xa4, 0x8b, 0x84, 0x5e,
	0x42, 0x4c, 0xa9, 0xf7, 0x76, 0x91, 0x90, 0xbb, 0xb0, 0x59, 0x82, 0xb4, 0x29, 0x04, 0x4d, 0xe9,
	0x17, 0xec, 0x43, 0xb4, 0xe9, 0x3e, 0xb4, 0x27, 0xb1, 0xc8, 0x79, 0x48, 0xb7, 0x56, 0x82, 0xf6,
	0x5c, 0x88, 0xf8, 0xe0, 0x28, 0x48, 0x67, 0x9c, 0x19, 0x88, 0x02, 0xc7, 0x62, 0xf2, 0x0b, 0x0f,
	0xe9, 0xf5, 0xcf, 0x80, 0x35, 0x44, 0x5d, 0x65, 0xbe, 0x88, 0x63, 0x3f, 0xe3, 0xbf, 0x2e, 0x78,
	0x2e, 0xe9, 0x4d, 0x7d, 0x5b, 0xc5, 0x63, 0x9a, 0x45, 0xbe, 0x07, 0x57, 0xef, 0xec, 0x07, 0x92,
	0x5e, 0x39, 0xd7, 0xe5, 0x8e, 0x06, 0xef, 0x4b, 0xf2, 0xa8, 0x50, 0x1c, 0x9f, 0xd0, 0xab, 0x67,
	0x67, 0x9b, 0xd1, 0x78, 0x7e, 0xa2, 0xac, 0xc9, 0x78, 0x22, 0x8e, 0xb9, 0x8f, 0xc5, 0x46, 0xaf,
	0x61, 0xe6, 0x74, 0x35, 0x0f, 0xcb, 0x10, 0x93, 0x32, 0x0c, 0x8d, 0x9c, 0x7e, 0xa6, 0x5e, 0x9d,
	0x20, 0x0c, 0xb5, 0xca, 0x0f, 0xd0, 0x99, 0x88, 0x24, 0xe1, 0xa9, 0xa4, 0x0e, 0x2a, 0xdc, 0x59,
	0xd7, 0xe2, 0x0e, 0x34, 0xa4, 0x68, 0x2d, 0x56, 0x87, 0xbc, 0x84, 0xbe, 0x59, 0xfa, 0xb9, 0x0c,
	0xe4, 0x22, 0xa7, 0x7d, 0xbc, 0xcb, 0xed, 0x75, 0xbb, 0xbc, 0x3b, 0x49, 0x27, 0xef, 0x10, 0xc5,
	0x36, 0x8c, 0x96, 0x26, 0xc9, 0x1e, 0xb4, 0xf8, 0xb1, 0xb2, 0x61, 0x1b, 0x6d, 0xb8, 0xbe, 0x4e,
	0xfb, 0xa5, 0x02, 0x30, 0x8d, 0x23, 0xfb, 0xd0, 0xc3, 0x85, 0x3d, 0xf5, 0xc6, 0x85, 0x4e, 0xed,
	0xa2, 0x8e, 0x39, 0xf3, 0x21, 0xb4, 0x33, 0x7e, 0x1c, 0xf1, 0x8f, 0xf4, 0x16, 0x1e, 0x7a, 0x65,
	0x45, 0x99, 0xa1, 0x90, 0x19, 0x10, 0x39, 0x80, 0x0d, 0xbd, 0xb2, 0x47, 0xde, 0xbe, 0xd0, 0x91,
	0x3d, 0xad, 0xa4, 0x29, 0xef, 0x36, 0x40, 0x99, 0x67, 0x64, 0x00, 0x8d, 0xe3, 0x20, 0xc6, 0xce,
	0xe6, 0x30, 0xb5, 0xf4, 0x1e, 0x43, 0xb7, 0x12, 0x26, 0xd3, 0x9d, 0x6a, 0x45, 0x77, 0x22, 0xd0,
	0x4c, 0x83, 0x84, 0xdb, 0xb6, 0xa7, 0xd6, 0xde, 0xef, 0xb0, 0xb9, 0xd2, 0x57, 0x4f, 0xa9, 0x15,
	0xb5, 0x5c, 0xaf, 0xd6, 0x72, 0x59, 0x37, 0x8d, 0xf3, 0xeb, 0xa6, 0x6c, 0xae, 0x4d, 0xdc, 0xd6,
	0x50, 0xde, 0x9f, 0x2d, 0x18, 0xac, 0xc6, 0xe8, 0xd4, 0xf9, 0xb7, 0x00, 0x74, 0xb0, 0xd4, 0x04,
	0x36, 0x46, 0xb8, 0xc8, 0x39, 0x3c, 0x99, 0x73, 0x72, 0x1d, 0x9c, 0x60, 0x22, 0x45, 0xa6, 0xba,
	0x45, 0x03, 0x95, 0x3a, 0x48, 0x8f, 0xc2, 0x6a, 0x17, 0x6c, 0x5e, 0xbc, 0x0b, 0xde, 0x83, 0x96,
	0x2e, 0x81, 0xd6, 0xe9, 0x59, 0x5a, 0x94, 0x80, 0x86, 0x90, 0xef, 0xc0, 0x2d, 0xdb, 0x99, 0xee,
	0x99, 0x67, 0x0f, 0xac, 0x12, 0x4a, 0xfe, 0x07, 0x5d, 0xdb, 0xc4, 0x95, 0xdd, 0x1d, 0xb4, 0x1b,
	0x2c, 0x6b, 0x14, 0x56, 0x00, 0x78, 0x31, 0x67, 0x09, 0xa0, 0xee, 0xf6, 0x10, 0xda, 0xaa, 0x08,
	0x22, 0x89, 0x2d, 0xf6, 0x74, 0xfe, 0x1d, 0xa0, 0x90, 0x19, 0x90, 0xda, 0x2f, 0xe3, 0x2a, 0xe2,
	0xfe, 0x34, 0x13, 0x09, 0xed, 0xa2, 0x17, 0x41, 0xb3, 0x5e, 0x65, 0x22, 0x51, 0x73, 0xce, 0x00,
	0xa4, 0xc0, 0x89, 0xe6, 0x32, 0x47, 0x33, 0x0e, 0x85, 0xd6, 0x56, 0x89, 0xa8, 0xad, 0xd9, 0xd0,
	0xd6, 0x58, 0xd6, 0x28, 0x24, 0x43, 0xd8, 0x32, 0xe9, 0x6d, 0xba, 0x9d, 0x06, 0xf6, 0x11, 0x78,
	0x49, 0x8b, 0x98, 0x95, 0x8c, 0x42, 0xf2, 0x14, 0x36, 0x24, 0x0f, 0x12, 0xdf, 0x6e, 0x81, 0x7d,
	0xfe, 0x74, 0x0f, 0x3b, 0xe4, 0x41, 0xc2, 0x7a, 0x0a, 0xc9, 0x0c, 0x90, 0xbc, 0x85, 0x41, 0x18,
	0xe5, 0x49, 0x94, 0xab, 0xe6, 0x67, 0x2a, 0x70, 0x13, 0x95, 0x57, 0x5b, 0xcf, 0x0b, 0x0b, 0xd3,
	0xba, 0xba, 0x01, 0x6c, 0x86, 0xcb, 0x5c, 0x95, 0x5d, 0x42, 0x1e, 0xf1, 0xcc, 0xff, 0x90, 0x8b,
	0x94, 0xc2, 0x4e, 0x6d, 0xb7, 0xc7, 0x5c, 0xe4, 0xbc, 0xce, 0x45, 0xea, 0x7d, 0xaa, 0xc1, 0xf6,
	0xd9, 0xdb, 0x69, 0xaf, 0xe1, 0xbd, 0x8b, 0x94, 0x75, 0x34, 0x63, 0x14, 0xe2, 0xc4, 0xd6, 0x4a,
	0x41, 0xec, 0x27, 0x3c, 0xcf, 0x83, 0x19, 0xc7, 0x14, 0x75, 0xd9, 0xa0, 0x10, 0xbc, 0xd1, 0x7c,
	0x55, 0x65, 0xaa, 0x33, 0x70, 0xcc, 0x54, 0x97, 0x69, 0xe2, 0x75, 0xd3, 0xa9, 0x0f, 0x1a, 0xde,
	0x7b, 0xe8, 0x55, 0x83, 0xfa, 0x05, 0xaf, 0x9a, 0x1b, 0xe0, 0xea, 0x04, 0xb0, 0xd5, 0xe1, 0x32,
	0x47, 0x33, 0x46, 0xa1, 0xf7, 0xa9, 0x6e, 0xf7, 0x35, 0xbe, 0x58, 0xad, 0xbc, 0x6a, 0x69, 0xd5,
	0xcf, 0x2c, 0xad, 0xc6, 0xc5, 0x4b, 0xcb, 0x3e, 0x15, 0x9a, 0xcb, 0x4f, 0x05, 0x7d, 0xf1, 0x56,
	0xe5, 0xe2, 0xcb, 0x86, 0xb7, 0x97, 0x0d, 0x57, 0x8e, 0xd5, 0x76, 0x05, 0x79, 0x2e, 0x26, 0x11,
	0x0e, 0x15, 0xf3, 0xfc, 0x18, 0xa0, 0x60, 0xbf, 0xe4, 0xaf, 0x04, 0xd8, 0x59, 0x0d, 0xf0, 0x21,
	0x5c, 0x59, 0xdb, 0x7a, 0xc9, 0x33, 0xe8, 0xe6, 0x3c, 0x3b, 0xe6, 0x99, 0xaf, 0x9e, 0x39, 0xe6,
	0x05, 0xff, 0xb9, 0x5b, 0x82, 0x86, 0xbf, 0x08, 0x24, 0x57, 0x9f, 0x81, 0xed, 0xb3, 0x07, 0xe0,
	0x29, 0x47, 0xdb, 0x77, 0x63, 0xfd, 0xbc, 0x77, 0xa3, 0x75, 0x60, 0xa3, 0xe2, 0xc0, 0xff, 0xd6,
	0xe5, 0x2a, 0x6f, 0xbd, 0xd6, 0x85, 0xdf, 0x7a, 0xde, 0x13, 0x80, 0xd2, 0xa6, 0x75, 0x93, 0x22,
	0x16, 0xb3, 0x28, 0xb5, 0x93, 0x02, 0x09, 0xef, 0x91, 0xd5, 0x51, 0xd5, 0xbc, 0x6e, 0x28, 0xe5,
	0xf1, 0x62, 0x66, 0xb3, 0x56, 0xad, 0x3d, 0x1f, 0xe7, 0x58, 0xe1, 0xad, 0xaf, 0x4c, 0x62, 0xeb,
	0x10, 0x0c, 0xaa, 0xde, 0x61, 0x7c, 0x2e, 0x4c, 0xaa, 0xdf, 0x2b, 0x1a, 0xa2, 0xf6, 0x22, 0xa9,
	0xe2, 0x96, 0xbb, 0xa1, 0xe7, 0x41, 0xc7, 0x28, 0x93, 0x6b, 0xd0, 0x99, 0x09, 0xbf, 0xd8, 0xdf,
	0x65, 0xed, 0x99, 0x50, 0x02, 0x2f, 0x04, 0xb7, 0x50, 0x44, 0x2b, 0x8f, 0x82, 0xc7, 0x06, 0x82,
	0x6b, 0x35, 0x7f, 0xb3, 0xe0, 0x23, 0x9e, 0xd6, 0x63, 0x6a, 0xa9, 0x1e, 0x50, 0x61, 0x34, 0x9d,
	0xfa, 0x32, 0xe3, 0xdc, 0x94, 0xc5, 0xd2, 0xf4, 0x78, 0x11, 0x4d, 0xa7, 0x87, 0x19, 0xe7, 0xcc,
	0x09, 0xcd, 0xca, 0x7b, 0x86, 0x57, 0xb5, 0x02, 0xf2, 0x00, 0x9a, 0xd3, 0x28, 0x56, 0xd9, 0x76,
	0xea, 0xef, 0x63, 0x31, 0xaf, 0xa2, 0x98, 0x33, 0x44, 0x79, 0x09, 0x0e, 0xef, 0xaa, 0x40, 0x19,
	0x6a, 0x36, 0x40, 0x43, 0xd5, 0x5a, 0x85, 0x25, 0x08, 0x43, 0x6e, 0x6b, 0x58, 0x13, 0x84, 0x42,
	0xc7, 0x7c, 0x1b, 0xec, 0xd8, 0x34, 0xa4, 0x9a, 0xd6, 0xe3, 0x28, 0x0d, 0x32, 0x5d, 0xa7, 0x0e,
	0x33, 0x94, 0xf7, 0x07, 0xf4, 0x97, 0xff, 0x88, 0x6a, 0x8f, 0x79, 0x26, 0x3e, 0xf0, 0x89, 0x34,
	0x07, 0x5a, 0x92, 0x3c, 0xd0, 0x0f, 0xc3, 0x48, 0xe6, 0xb4, 0x8e, 0x77, 0x59, 0x17, 0x0e, 0x0b,
	0x21, 0x77, 0x54, 0x84, 0xa7, 0xf6, 0x93, 0xb8, 0xb9, 0x1c, 0xe1, 0x29, 0x43, 0xa1, 0x37, 0x84,
	0xb6, 0xa6, 0xd1, 0xf3, 0x7c, 0x6a, 0x8e, 0x54, 0xcb, 0x22, 0x3e, 0xf5, 0x32, 0x3e, 0xe3, 0x36,
	0x26, 0xf2, 0x37, 0xff, 0x06, 0x00, 0x00, 0xff, 0xff, 0x46, 0xe0, 0x26, 0x49, 0xef, 0x0f, 0x00,
	0x00,
}
