package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSpanNames invokes the arms.GetSpanNames API synchronously
// api document: https://help.aliyun.com/api/arms/getspannames.html
func (client *Client) GetSpanNames(request *GetSpanNamesRequest) (response *GetSpanNamesResponse, err error) {
	response = CreateGetSpanNamesResponse()
	err = client.DoAction(request, response)
	return
}

// GetSpanNamesWithChan invokes the arms.GetSpanNames API asynchronously
// api document: https://help.aliyun.com/api/arms/getspannames.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetSpanNamesWithChan(request *GetSpanNamesRequest) (<-chan *GetSpanNamesResponse, <-chan error) {
	responseChan := make(chan *GetSpanNamesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSpanNames(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSpanNamesWithCallback invokes the arms.GetSpanNames API asynchronously
// api document: https://help.aliyun.com/api/arms/getspannames.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetSpanNamesWithCallback(request *GetSpanNamesRequest, callback func(response *GetSpanNamesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSpanNamesResponse
		var err error
		defer close(result)
		response, err = client.GetSpanNames(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSpanNamesRequest is the request struct for api GetSpanNames
type GetSpanNamesRequest struct {
	*requests.RpcRequest
	EndTime     requests.Integer `position:"Query" name:"EndTime"`
	ServiceName string           `position:"Query" name:"ServiceName"`
	StartTime   requests.Integer `position:"Query" name:"StartTime"`
}

// GetSpanNamesResponse is the response struct for api GetSpanNames
type GetSpanNamesResponse struct {
	*responses.BaseResponse
	RequestId string             `json:"RequestId" xml:"RequestId"`
	Data      DataInGetSpanNames `json:"Data" xml:"Data"`
}

// CreateGetSpanNamesRequest creates a request to invoke GetSpanNames API
func CreateGetSpanNamesRequest() (request *GetSpanNamesRequest) {
	request = &GetSpanNamesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-02-19", "GetSpanNames", "", "")
	return
}

// CreateGetSpanNamesResponse creates a response to parse from GetSpanNames response
func CreateGetSpanNamesResponse() (response *GetSpanNamesResponse) {
	response = &GetSpanNamesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
