package ccs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ProceedTicket invokes the ccs.ProceedTicket API synchronously
// api document: https://help.aliyun.com/api/ccs/proceedticket.html
func (client *Client) ProceedTicket(request *ProceedTicketRequest) (response *ProceedTicketResponse, err error) {
	response = CreateProceedTicketResponse()
	err = client.DoAction(request, response)
	return
}

// ProceedTicketWithChan invokes the ccs.ProceedTicket API asynchronously
// api document: https://help.aliyun.com/api/ccs/proceedticket.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ProceedTicketWithChan(request *ProceedTicketRequest) (<-chan *ProceedTicketResponse, <-chan error) {
	responseChan := make(chan *ProceedTicketResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ProceedTicket(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ProceedTicketWithCallback invokes the ccs.ProceedTicket API asynchronously
// api document: https://help.aliyun.com/api/ccs/proceedticket.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ProceedTicketWithCallback(request *ProceedTicketRequest, callback func(response *ProceedTicketResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ProceedTicketResponse
		var err error
		defer close(result)
		response, err = client.ProceedTicket(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ProceedTicketRequest is the request struct for api ProceedTicket
type ProceedTicketRequest struct {
	*requests.RpcRequest
	Memo          string `position:"Query" name:"Memo"`
	Id            string `position:"Query" name:"Id"`
	CcsInstanceId string `position:"Query" name:"CcsInstanceId"`
	Operation     string `position:"Query" name:"Operation"`
	OperatorId    string `position:"Query" name:"OperatorId"`
}

// ProceedTicketResponse is the response struct for api ProceedTicket
type ProceedTicketResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateProceedTicketRequest creates a request to invoke ProceedTicket API
func CreateProceedTicketRequest() (request *ProceedTicketRequest) {
	request = &ProceedTicketRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ccs", "2017-10-01", "ProceedTicket", "ccs", "openAPI")
	return
}

// CreateProceedTicketResponse creates a response to parse from ProceedTicket response
func CreateProceedTicketResponse() (response *ProceedTicketResponse) {
	response = &ProceedTicketResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
