package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMigrateTasks invokes the rds.DescribeMigrateTasks API synchronously
// api document: https://help.aliyun.com/api/rds/describemigratetasks.html
func (client *Client) DescribeMigrateTasks(request *DescribeMigrateTasksRequest) (response *DescribeMigrateTasksResponse, err error) {
	response = CreateDescribeMigrateTasksResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMigrateTasksWithChan invokes the rds.DescribeMigrateTasks API asynchronously
// api document: https://help.aliyun.com/api/rds/describemigratetasks.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMigrateTasksWithChan(request *DescribeMigrateTasksRequest) (<-chan *DescribeMigrateTasksResponse, <-chan error) {
	responseChan := make(chan *DescribeMigrateTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMigrateTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMigrateTasksWithCallback invokes the rds.DescribeMigrateTasks API asynchronously
// api document: https://help.aliyun.com/api/rds/describemigratetasks.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMigrateTasksWithCallback(request *DescribeMigrateTasksRequest, callback func(response *DescribeMigrateTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMigrateTasksResponse
		var err error
		defer close(result)
		response, err = client.DescribeMigrateTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMigrateTasksRequest is the request struct for api DescribeMigrateTasks
type DescribeMigrateTasksRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	EndTime              string           `position:"Query" name:"EndTime"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	StartTime            string           `position:"Query" name:"StartTime"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
}

// DescribeMigrateTasksResponse is the response struct for api DescribeMigrateTasks
type DescribeMigrateTasksResponse struct {
	*responses.BaseResponse
	RequestId        string                      `json:"RequestId" xml:"RequestId"`
	DBInstanceId     string                      `json:"DBInstanceId" xml:"DBInstanceId"`
	TotalRecordCount int                         `json:"TotalRecordCount" xml:"TotalRecordCount"`
	PageNumber       int                         `json:"PageNumber" xml:"PageNumber"`
	PageRecordCount  int                         `json:"PageRecordCount" xml:"PageRecordCount"`
	Items            ItemsInDescribeMigrateTasks `json:"Items" xml:"Items"`
}

// CreateDescribeMigrateTasksRequest creates a request to invoke DescribeMigrateTasks API
func CreateDescribeMigrateTasksRequest() (request *DescribeMigrateTasksRequest) {
	request = &DescribeMigrateTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribeMigrateTasks", "rds", "openAPI")
	return
}

// CreateDescribeMigrateTasksResponse creates a response to parse from DescribeMigrateTasks response
func CreateDescribeMigrateTasksResponse() (response *DescribeMigrateTasksResponse) {
	response = &DescribeMigrateTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
