## helm

The Helm package manager for Kubernetes.

### Synopsis

The Kubernetes package manager

To begin working with Helm, run the 'helm init' command:

	$ helm init

This will install Tiller to your running Kubernetes cluster.
It will also set up any necessary local configuration.

Common actions from this point include:

- helm search:    Search for charts
- helm fetch:     Download a chart to your local directory to view
- helm install:   Upload the chart to Kubernetes
- helm list:      List releases of charts

Environment:

- $HELM_HOME:           Set an alternative location for Helm files. By default, these are stored in ~/.helm
- $HELM_HOST:           Set an alternative Tiller host. The format is host:port
- $HELM_NO_PLUGINS:     Disable plugins. Set HELM_NO_PLUGINS=1 to disable plugins.
- $TILLER_NAMESPACE:    Set an alternative Tiller namespace (default "kube-system")
- $KUBECONFIG:          Set an alternative Kubernetes configuration file (default "~/.kube/config")
- $HELM_TLS_CA_CERT:    Path to TLS CA certificate used to verify the Helm client and Tiller server certificates (default "$HELM_HOME/ca.pem")
- $HELM_TLS_CERT:       Path to TLS client certificate file for authenticating to Tiller (default "$HELM_HOME/cert.pem")
- $HELM_TLS_KEY:        Path to TLS client key file for authenticating to Tiller (default "$HELM_HOME/key.pem")
- $HELM_TLS_ENABLE:     Enable TLS connection between Helm and Tiller (default "false")
- $HELM_TLS_VERIFY:     Enable TLS connection between Helm and Tiller and verify Tiller server certificate (default "false")
- $HELM_TLS_HOSTNAME:   The hostname or IP address used to verify the Tiller server certificate (default "127.0.0.1")
- $HELM_KEY_PASSPHRASE: Set HELM_KEY_PASSPHRASE to the passphrase of your PGP private key. If set, you will not be prompted for the passphrase while signing helm charts



### Options

```
      --debug                           Enable verbose output
  -h, --help                            help for helm
      --home string                     Location of your Helm config. Overrides $HELM_HOME (default "~/.helm")
      --host string                     Address of Tiller. Overrides $HELM_HOST
      --kube-context string             Name of the kubeconfig context to use
      --kubeconfig string               Absolute path of the kubeconfig file to be used
      --tiller-connection-timeout int   The duration (in seconds) Helm will wait to establish a connection to Tiller (default 300)
      --tiller-namespace string         Namespace of Tiller (default "kube-system")
```

### SEE ALSO

* [helm completion](helm_completion.md)	 - Generate autocompletions script for the specified shell (bash or zsh)
* [helm create](helm_create.md)	 - Create a new chart with the given name
* [helm delete](helm_delete.md)	 - Given a release name, delete the release from Kubernetes
* [helm dependency](helm_dependency.md)	 - Manage a chart's dependencies
* [helm fetch](helm_fetch.md)	 - Download a chart from a repository and (optionally) unpack it in local directory
* [helm get](helm_get.md)	 - Download a named release
* [helm history](helm_history.md)	 - Fetch release history
* [helm home](helm_home.md)	 - Displays the location of HELM_HOME
* [helm init](helm_init.md)	 - Initialize Helm on both client and server
* [helm inspect](helm_inspect.md)	 - Inspect a chart
* [helm install](helm_install.md)	 - Install a chart archive
* [helm lint](helm_lint.md)	 - Examines a chart for possible issues
* [helm list](helm_list.md)	 - List releases
* [helm package](helm_package.md)	 - Package a chart directory into a chart archive
* [helm plugin](helm_plugin.md)	 - Add, list, or remove Helm plugins
* [helm repo](helm_repo.md)	 - Add, list, remove, update, and index chart repositories
* [helm reset](helm_reset.md)	 - Uninstalls Tiller from a cluster
* [helm rollback](helm_rollback.md)	 - Rollback a release to a previous revision
* [helm search](helm_search.md)	 - Search for a keyword in charts
* [helm serve](helm_serve.md)	 - Start a local http web server
* [helm status](helm_status.md)	 - Displays the status of the named release
* [helm template](helm_template.md)	 - Locally render templates
* [helm test](helm_test.md)	 - Test a release
* [helm upgrade](helm_upgrade.md)	 - Upgrade a release
* [helm verify](helm_verify.md)	 - Verify that a chart at the given path has been signed and is valid
* [helm version](helm_version.md)	 - Print the client/server version information

###### Auto generated by spf13/cobra on 16-May-2019
