// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/hive/pkg/apis/hive/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// SyncSetLister helps list SyncSets.
// All objects returned here must be treated as read-only.
type SyncSetLister interface {
	// List lists all SyncSets in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.SyncSet, err error)
	// SyncSets returns an object that can list and get SyncSets.
	SyncSets(namespace string) SyncSetNamespaceLister
	SyncSetListerExpansion
}

// syncSetLister implements the SyncSetLister interface.
type syncSetLister struct {
	indexer cache.Indexer
}

// NewSyncSetLister returns a new SyncSetLister.
func NewSyncSetLister(indexer cache.Indexer) SyncSetLister {
	return &syncSetLister{indexer: indexer}
}

// List lists all SyncSets in the indexer.
func (s *syncSetLister) List(selector labels.Selector) (ret []*v1.SyncSet, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.SyncSet))
	})
	return ret, err
}

// SyncSets returns an object that can list and get SyncSets.
func (s *syncSetLister) SyncSets(namespace string) SyncSetNamespaceLister {
	return syncSetNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// SyncSetNamespaceLister helps list and get SyncSets.
// All objects returned here must be treated as read-only.
type SyncSetNamespaceLister interface {
	// List lists all SyncSets in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.SyncSet, err error)
	// Get retrieves the SyncSet from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.SyncSet, error)
	SyncSetNamespaceListerExpansion
}

// syncSetNamespaceLister implements the SyncSetNamespaceLister
// interface.
type syncSetNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all SyncSets in the indexer for a given namespace.
func (s syncSetNamespaceLister) List(selector labels.Selector) (ret []*v1.SyncSet, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.SyncSet))
	})
	return ret, err
}

// Get retrieves the SyncSet from the indexer for a given namespace and name.
func (s syncSetNamespaceLister) Get(name string) (*v1.SyncSet, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("syncset"), name)
	}
	return obj.(*v1.SyncSet), nil
}
