---
layout: "docs"
page_title: "AWS Marketplace"
sidebar_current: "docs-platform-aws-mp-index"
sidebar_title: "AWS Marketplace"
description: |-
  This section documents the official AWS Marketplace AMIs for Vault Open Source and Vault Enterprise.
---

# AWS Marketplace 

Vault can be deployed onto Amazon Web Services (AWS) using HashiCorp’s official AWS Marketplace offerings. HashiCorp packages the latest version of both Vault Open Source and Vault Enterprise as Amazon Machine Images (AMIs).

There are two varieties of Vault AMIs available through the AWS Marketplace. Vault Open Source is available as a public listing and can be subscribed to using the standard process for the AWS Marketplace. Vault Enterprise is also available through the AWS Marketplace. To learn more about consuming Vault Enterprise through the AWS Marketplace, please reach out to our sales team at the following address: <aws-marketplace@hashicorp.com>

The AWS Marketplace listings can be found below.

* [HashiCorp Vault OSS](http://aws.amazon.com/marketplace/pp/B07YLYPLYB)
* [HashiCorp Vault Enterprise](http://aws.amazon.com/marketplace/pp/B07YLXD9TD)

## Use Cases

The Vault AMIs listed in the AWS Marketplace are intended to serve as an easy starting point for a Vault installation. Vault AMIs are built on top of a minimal Ubuntu distribution and contain up to date packages for both Vault and the underlying operating system dependencies.

The Open Source Vault AMI is intended for development and test use cases. This listing will launch a non-HA Vault instance with Vault running and the Vault UI available. For production use cases, please see the [Architecture](/docs/platform/aws-mp/run.html#Architecture) section of this documentation.
