---
layout: "docs"
page_title: "Upgrading to Vault 0.5.0 - Guides"
sidebar_title: "Upgrade to 0.5.0"
sidebar_current: "docs-upgrading-to-0.5.0"
description: |-
  This page contains the full list of breaking changes for Vault 0.5, including
  actions you must take to facilitate a smooth upgrade path.
---

# Overview

This page contains the list of breaking changes for Vault 0.5. Please read it
carefully.

Please note that these are changes to Vault itself. Client libraries maintained
by HashiCorp have been updated with support for these changes, but if you are
using community-supported libraries, you should ensure that they are ready for
Vault 0.5 before upgrading.

## Rekey Requires Nonce

Vault now generates a nonce when a rekey operation is started in order to
ensure that the operation cannot be hijacked. The nonce is output when the
rekey operation is started and when rekey status is requested.

The nonce must be provided as part of the request parameters when providing an
unseal key. The nonce can be communicated from the request initiator to unseal
key holders via side channels; the unseal key holders can then verify the nonce
(by providing it) when they submit their unseal key.

As a convenience, if using the CLI interactively to provide the unseal key, the
nonce will be displayed for verification but the user will not be required to
manually re-type it.

## `TTL` Field in Token Lookup

Previously, the `ttl` field returned when calling `lookup` or `lookup-self` on
the token auth method displayed the TTL set at token creation. It
now displays the time remaining (in seconds) for the token's validity period.
The original behavior has been moved to a field named `creation_ttl`.

## Grace Periods Removed

Vault no longer uses grace periods internally for leases or token TTLs.
Previously these were set by backends and could differ greatly from one backend
to another, causing confusion. TTLs (the `lease_duration` field for a lease,
or, for a token lookup, the `ttl`) are now exact.

## `token-renew` CLI Command

If the token given for renewal is the same as the token in use by the client,
the `renew-self` endpoint will be used in the API rather than the `renew`
endpoint. Since the `default` policy contains `auth/token/renew-self` this
makes it much more likely that the request will succeed rather than somewhat
confusingly failing due to a lack of permissions on `auth/token/renew`.

## `status` CLI Command
The `status` CLI command now returns an exit code of `0` for an unsealed Vault
(as before), `2` for a sealed Vault, and `1` for an error. This keeps error
return codes consistent across commands.

## Transit Upsertion Behavior Uses Capabilities

Previously, attempting to encrypt with a key that did not exist would create a
key with default values. This was convenient but ultimately allowed a client to
potentially escape an ACL policy restriction, albeit without any dangerous
access. Now that Vault supports more granular capabilities in policies,
upsertion behavior is controlled by whether the client has the `create`
capability for the request (upsertion is allowed) or only the `update`
capability (upsertion is denied).

## etcd Physical Backend Uses `sync`

The `etcd` physical backend now supports `sync` functionality and it is turned
on by default, which maps to the upstream library's default. It can be
disabled; see the configuration page for information.

## S3 Physical Backend Prefers Environment Variables

The `s3` physical backend now prefers environment variables over configuration
file variables. This matches the behavior of the rest of the backends and of
Vault generally.

## Lease Default and Renewal Handling

All backends now honor system and mount-specific default and maximum lease
times, except when specifically overridden by backend configuration or role
parameters, or when doing so would not make sense (e.g. AWS STS tokens cannot
have a lifetime of greater than 1 hour).

This allows for a *much* more uniform approach to managing leases on both the
operational side and the user side, and removes much ambiguity and uncertainty
resulting from backend-hardcoded limits.

However, also this means that the leases generated by the backends may return
significantly different TTLs in 0.5 than in previous versions, unless they have
been preconfigured. You can use the `mount-tune` CLI command or the
`/sys/mounts/<mount point>/tune` endpoint to adjust default and max TTL
behavior for any mount. This is supported in 0.4, so you can perform this
tuning before upgrading.

The following list details the ways in which lease handling has changed
per-backend. In all cases the "mount TTL" means the mount-specific value for
default or max TTL; however, if no value is set on a given mount, the system
default/max values are used. This lists only the changes; any lease-issuing
or renew function not listed here behaves the same as in 0.4.

(As a refresher: the default TTL is the amount of time that the initial
lease/token is valid for before it must be renewed; the maximum TTL is the
amount of time a lease or token is valid for before it can no longer be renewed
and must be reissued. A mount can be more restrictive with its maximum TTL, but
cannot be less restrictive than the mount's maximum TTL.)

#### Credential (Auth) Backends

- `github` – The renewal function now uses the backend's configured maximum
  TTL, if set; otherwise, the mount maximum TTL is used.
- `ldap` – The renewal function now uses the mount default TTL instead of always
  using one hour.
- `token` – Tokens can no longer be renewed forever; instead, they now honor the
  mount default/max TTL.
- `userpass` – The renew function now uses the backend's configured maximum TTL,
  if set; otherwise the mount maximum TTL is used.

#### Secrets Engines

- `aws` – New IAM roles no longer always have a default TTL of one hour, instead
  honoring the configured default if available and the mount default TTL if not
  (renewal always used the configured values if available). STS tokens return a
  TTL corresponding to the lifetime of the token in AWS and cannot be renewed.
- `cassandra` – `lease_grace_period` has been removed since Vault no longer uses
  grace periods.
- `consul` – The mount default TTL is now used as the default TTL if there is no
  backend configuration parameter. Renewal now uses the mount default and
  maximum TTLs.
- `mysql` – The mount default TTL is now used as the default TTL if there is no
  backend configuration parameter.
- `postgresql` – The mount default TTL is now used as the default TTL if there
  is no backend configuration parameter. In addition, there is no longer any
  grace period with the time configured for password expiration within Postgres
  itself.
