package imagesearchapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/cognitiveservices/v1.0/imagesearch"
)

// ImagesClientAPI contains the set of methods on the ImagesClient type.
type ImagesClientAPI interface {
	Details(ctx context.Context, query string, acceptLanguage string, contentType string, userAgent string, clientID string, clientIP string, location string, cropBottom *float64, cropLeft *float64, cropRight *float64, cropTop *float64, cropType imagesearch.ImageCropType, countryCode string, ID string, imageURL string, insightsToken string, modules []imagesearch.ImageInsightModule, market string, safeSearch imagesearch.SafeSearch, setLang string) (result imagesearch.ImageInsights, err error)
	Search(ctx context.Context, query string, acceptLanguage string, userAgent string, clientID string, clientIP string, location string, aspect imagesearch.ImageAspect, colorParameter imagesearch.ImageColor, countryCode string, count *int32, freshness imagesearch.Freshness, height *int32, ID string, imageContent imagesearch.ImageContent, imageType imagesearch.ImageType, license imagesearch.ImageLicense, market string, maxFileSize *int64, maxHeight *int64, maxWidth *int64, minFileSize *int64, minHeight *int64, minWidth *int64, offset *int64, safeSearch imagesearch.SafeSearch, size imagesearch.ImageSize, setLang string, width *int32) (result imagesearch.Images, err error)
	Trending(ctx context.Context, acceptLanguage string, userAgent string, clientID string, clientIP string, location string, countryCode string, market string, safeSearch imagesearch.SafeSearch, setLang string) (result imagesearch.TrendingImages, err error)
}

var _ ImagesClientAPI = (*imagesearch.ImagesClient)(nil)
