// Code generated by vfsgen; DO NOT EDIT

package idiomaticgo_test

import (
	"bytes"
	"compress/gzip"
	"fmt"
	"io"
	"io/ioutil"
	"net/http"
	"os"
	pathpkg "path"
	"time"
)

// issuesFS is issues test data.
var issuesFS = func() http.FileSystem {
	mustUnmarshalTextTime := func(text string) time.Time {
		var t time.Time
		err := t.UnmarshalText([]byte(text))
		if err != nil {
			panic(err)
		}
		return t
	}

	fs := vfsgen۰FS{
		"/": &vfsgen۰DirInfo{
			name:    "/",
			modTime: mustUnmarshalTextTime("2016-09-24T21:49:28Z"),
		},
		"/dmitri.shuralyov.com": &vfsgen۰DirInfo{
			name:    "dmitri.shuralyov.com",
			modTime: mustUnmarshalTextTime("2016-09-24T21:49:28Z"),
		},
		"/dmitri.shuralyov.com/idiomatic-go": &vfsgen۰DirInfo{
			name:    "idiomatic-go",
			modTime: mustUnmarshalTextTime("2016-09-24T21:49:52Z"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues": &vfsgen۰DirInfo{
			name:    "issues",
			modTime: mustUnmarshalTextTime("2016-10-15T22:19:46Z"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/1": &vfsgen۰DirInfo{
			name:    "1",
			modTime: mustUnmarshalTextTime("2016-10-04T03:45:53Z"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/1/0": &vfsgen۰CompressedFileInfo{
			name:             "0",
			modTime:          mustUnmarshalTextTime("2016-10-03T21:36:41Z"),
			uncompressedSize: 1206,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xc4\x93\x5f\x6b\xe3\x38\x14\xc5\xdf\xf7\x53\x88\x0b\xcb\x26\xac\x6b\x5b\x8a\xe5\xc4\x82\x7d\x48\x9b\x6e\x59\x58\x86\xa1\xcd\xbc\xb4\x0e\x44\x96\xaf\x13\x4d\x6d\xc9\x58\xf2\xd0\x10\xf2\xdd\x07\x27\x1d\x52\x86\xa6\xcc\xdb\x3c\x0a\x9d\xfb\x3b\x87\xfb\x67\x0f\x0f\x5e\x7a\x04\x01\xb6\x45\x03\x01\x2c\xb5\xaf\x87\xe7\xc2\x9a\xbf\x3c\xb1\x2e\xbc\x7d\xd1\x7e\xc4\xc6\x44\x1b\xa7\x4b\x24\x55\x2d\x37\xe1\x17\x27\x37\x08\x01\xfc\x2f\x0b\xac\x1d\x88\xa7\x3d\x7c\x92\xcd\x50\x36\x57\x0a\x5b\x8f\x25\x04\x70\x63\x6b\xdb\x81\xd8\xc3\x3d\x08\xc6\x92\x00\xee\x40\xb0\x09\x0f\xe0\x1a\x04\x4b\xf8\xe1\xb0\x0a\x60\xde\xfb\xed\x49\xf4\xdf\x02\x04\xcd\x58\x42\x27\x49\x00\x0b\xdb\x48\x6d\x40\xc0\x46\xfb\x6d\x5f\x84\xca\x36\x70\x08\xe0\xa6\x43\xe9\xb1\x9c\x7b\x10\xc0\x62\x9a\x5e\xc5\xd9\x15\x4b\x96\x8c\x89\x38\x16\x3c\x0e\xd3\x84\x71\x46\xa7\x3c\x7d\x84\x00\x6e\x4b\x3d\xe4\x10\x7b\xb8\xde\xfd\xaa\xc1\x99\x4c\xe3\xab\x98\x2d\xe9\x4c\xf0\xa9\x60\x2c\xcc\x68\x9c\x66\x9c\x31\xfe\x38\xc8\xae\x6d\xb9\x3b\xb6\x88\xf8\xad\x76\x22\x37\xb9\x59\xaf\xd7\x77\x36\x37\xe7\xee\x90\x7f\x48\xd5\x1b\x35\x1a\x93\x7d\x6e\x72\x5f\x35\x3e\xfc\xb7\xed\xb4\xf1\xd5\xc8\xba\xf0\xc1\x97\xd8\x75\x01\xc9\xe1\x24\xb6\x15\xf9\xd3\x89\x3c\x37\x39\x04\x43\xd3\xe7\xdd\xc6\x3d\xc5\xab\xf1\xb1\x74\x60\x7e\x1e\x4a\x17\x58\xc9\xbe\xf6\x6e\x34\xce\xcd\xe1\xe8\x39\x58\x9f\x26\x55\xfe\xce\x30\xb9\x3f\x2f\xca\xdb\x68\xcb\x2d\x92\xf5\xeb\xd7\x9a\x28\x59\xd7\x44\x3b\xd2\x1b\x83\x0a\x9d\x93\xdd\x8e\x14\xa8\x64\xef\x90\xac\x07\xf0\x9a\xb4\x52\x3d\x0f\x11\xb4\x23\xb2\xee\x50\x96\x3b\xd2\xa1\x6b\xad\x71\xba\xa8\x91\x54\xb6\x23\xa5\xd5\x66\x43\xb4\x0f\xc9\x03\x22\x79\xda\x62\x87\xab\xd1\xd6\xfb\xd6\x89\x28\x3a\x8f\x33\x6a\x4a\x6c\x5a\xf7\xbc\x8b\x7a\xa3\xac\xf9\x86\x9d\x8f\x94\x6d\x1a\xed\xa3\x49\x91\x49\x99\x50\x35\xa5\x72\xc6\xb9\xe4\x15\xaf\x10\xb3\xb4\x54\x53\x4e\xb3\x69\xa6\x30\xc5\x99\x2a\x0a\x1c\x13\x69\xca\x0f\x1c\x94\x6c\x5a\xbb\x8b\xb0\x29\xb0\x6c\xca\xa8\xed\xeb\x3a\xa2\x2c\xaa\x74\x8d\x6e\x7c\xcc\x8a\x2f\xb2\x69\x6b\x74\x21\x04\x70\x8f\x52\x79\x6d\xcd\xe9\x5c\x6e\x1b\xfb\x55\x0f\x2b\x09\x9b\x4e\x1b\xa3\xcd\x06\x7e\x5c\xc3\x49\x30\xfc\xb1\x2c\x66\x19\x9d\x5d\x58\xd7\xd5\x21\x78\xcb\xf9\x9b\xbe\x43\x48\xe3\xe9\x2c\xbd\x04\x08\x5e\x5d\x12\x9e\x0c\x67\xf9\xa1\x86\xf2\x98\xa7\xd3\x8f\x45\x74\xc2\xb2\x8c\x5f\x22\xfd\x14\xb7\xe9\xdd\xb6\xb3\xb6\x79\x2f\xf4\x6c\xc6\x26\xf4\x22\x66\x75\xf8\xe3\x7b\x00\x00\x00\xff\xff\xbd\xfa\xc6\x22\xb6\x04\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/1/1": &vfsgen۰CompressedFileInfo{
			name:             "1",
			modTime:          mustUnmarshalTextTime("2016-10-02T12:31:50Z"),
			uncompressedSize: 295,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x24\x8d\x41\x4b\xc3\x40\x10\x85\xef\xfe\x8a\x61\x2e\x2a\xa4\x49\x36\xa5\x51\xf6\x52\xaa\xbd\xf4\x2e\x08\x8a\xd0\x69\x32\xdd\x5d\x9a\xee\x84\xdd\x09\x45\x4a\xff\xbb\x34\x5e\x1e\x3c\x78\xdf\xfb\xae\xb8\x99\xd4\x4b\x42\x7b\xc5\xdd\x16\xad\x69\x9b\x7a\x55\xe0\x56\xce\x14\x22\x5a\x74\x41\xfd\x74\x28\x3b\x39\xe3\xad\xc0\xf7\xc4\xa4\xdc\x6f\x14\x2d\x36\xb5\x69\x17\xa6\x5e\xd4\xcd\x87\x69\xec\xd2\xd8\x55\x5d\xbe\x9a\xa5\x69\x5f\xda\xba\xf9\xc2\x02\xdf\xa4\xff\x45\x8b\x9f\x9e\x14\x42\x04\xf5\x0c\xfb\xe3\x40\x6e\x0f\x23\x75\x27\x72\x0c\xbd\x70\x06\xf5\x21\xaf\x61\x07\x9e\x7a\x20\x18\x44\x4e\x40\x0a\xdf\xf7\x79\x96\x29\x75\xfc\xf3\xe4\x55\xc7\x6c\xab\xca\xc9\x40\xd1\x95\x92\x5c\x95\x53\x57\xdd\xcf\xe6\x28\x9d\x3c\x03\xc5\x1e\x32\x33\xe8\xec\x53\xb8\x84\x61\x80\x5e\xfe\xfb\x51\x12\x8c\x94\x72\x88\x0e\x38\x25\x49\xb9\x80\xc3\xa4\xb0\x83\x8e\xe2\xa3\xce\xa0\x97\x0b\xf0\x90\xf9\x0e\x9f\x83\xf3\x0a\x9e\xc6\x91\xe3\x1a\x6f\x0f\x7f\x01\x00\x00\xff\xff\x54\xa1\x1b\x78\x27\x01\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/1/2": &vfsgen۰CompressedFileInfo{
			name:             "2",
			modTime:          mustUnmarshalTextTime("2016-10-02T18:57:47Z"),
			uncompressedSize: 1792,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x8c\x54\x6d\x6b\xe3\x46\x10\xfe\xde\x5f\x31\xa8\x94\xb3\xc1\x91\x2c\x27\x8e\x6d\x1d\x07\x4d\xee\xa5\x0d\x1c\xd7\x83\x4b\x5b\xb8\xe8\x40\x63\xed\x48\xda\x66\xb5\x23\x76\x57\x76\x4c\xc8\x7f\x2f\xbb\xb2\x13\x27\xa4\xd0\x2f\xb6\x91\x67\x9e\x99\xe7\x45\x73\x1f\x5d\xf4\xae\x61\x13\x65\xf7\xd1\xd5\x87\x28\x4b\x57\xb3\xb3\xf4\xf4\x6c\x12\x7d\xe0\x16\xa5\x8e\xb2\xa8\x96\xae\xe9\xd7\x71\xc9\x6d\xf4\x30\x89\xde\x1b\x42\x47\xe2\xc2\x45\x59\x34\x9b\xa6\xe7\x27\xe9\xf4\x64\x3a\xbb\x4e\x97\xd9\x3c\xcd\xd2\xb3\x78\x36\x9f\x2e\x66\xf3\xf9\x74\xf9\x3d\x9a\x44\x1f\x85\x74\x24\x3c\xf4\xe5\xee\xff\x0e\x78\x0d\x79\x91\x9d\x2d\xe2\xd5\xe9\x72\x99\x9e\xa6\x8b\xd5\x77\x5f\x76\xc9\x62\x17\x65\xd1\xaf\xff\xe0\x5a\xd1\x0e\xae\xf1\x96\x00\x41\x31\xdf\x02\x3a\x70\x0d\x81\xa0\x0a\x7b\xe5\x60\x83\xaa\x27\xe0\x0a\x8a\x3f\x2d\xd6\x54\x4c\x40\x3a\x10\x4c\x16\x34\x3b\x28\x51\x29\x28\xd8\xc6\x1f\xef\xa4\x1b\xcd\xc6\x45\x96\xeb\x5c\x17\x45\xf1\x1b\xe7\x3a\x49\x20\xf4\x40\x67\xa4\x76\x16\x1c\x83\x75\xa8\x05\x1a\x01\x64\x0c\x1b\x40\xe8\x43\x41\x4b\x36\x7c\x0b\x2e\xfb\x96\xb4\x93\xba\x06\x8f\x2c\xa8\x92\x9a\x04\x94\xdc\xb6\xa8\xc5\x89\x92\x9a\xa0\x52\x58\xdb\x38\xc0\x5f\x39\x90\x36\x2c\x41\x02\xb6\x0d\x69\x40\xbd\x87\xe6\xb2\xec\x8d\x85\x6d\x23\x15\x41\x87\xc6\x7a\xcc\xa3\xd6\xeb\x86\xa0\xea\x75\xe9\x24\x6b\x0f\x82\xb0\x41\x23\xbd\x1c\xe0\x1a\x74\xd0\xe2\x0e\xd6\x04\x65\x83\xba\x26\xe1\x77\xef\x58\x6a\xe7\x7f\x20\x94\xbd\x75\xdc\x3e\xf6\x0f\x88\x97\xbb\x47\xd1\xa4\x3b\x70\x46\xb0\xb2\xed\x14\x41\x43\x28\xc8\x00\x6a\x11\xf6\xb5\xf0\xd5\x17\x7c\x18\x1a\xec\x5b\xa8\xd8\x80\x20\x87\x52\x59\xc0\x35\xf7\xc1\x85\x80\x5b\xb1\x69\xd1\x79\x0b\xbc\x2f\xdc\xbb\xae\x77\x01\xa7\xe1\xad\x5f\xa7\x64\xed\x0c\x2b\x90\x6e\x02\x96\x68\x70\x6f\x2f\x24\x06\x7a\x1e\xfb\xd9\xb8\x38\xd7\x1b\x34\x7b\x77\xde\x05\x1e\xa3\x31\xdc\xe7\x3a\x77\x55\xeb\xe2\x4f\x61\xf9\x6a\xc4\x36\xfe\xe6\x04\x19\x33\x81\x3c\x1a\x8a\xb9\x82\x5f\x6c\x96\xe7\x3a\x8f\x26\xc0\x36\xbe\x30\xb5\xbd\x99\xfe\x18\xfb\xd6\x67\x23\x46\xe3\x5c\x3f\x84\x28\xf8\x44\xfc\xed\xbd\xd9\x71\xff\xc6\x10\xf4\xc1\x8a\xe3\x8c\x79\x5b\xc0\xd2\xc0\x6a\xc7\xfd\x3e\x56\xfe\x71\xfc\x15\x8d\xa5\xd1\x78\xc8\x1d\xdd\x51\xd9\x3b\xb2\x2f\x52\x76\x55\x6b\x36\x34\x18\x6f\xdf\xc2\xfb\x21\x2d\x9f\x7d\x58\xa4\x0d\xc0\x5e\x01\x1f\xd1\x3f\xf4\x47\x5f\x14\xe7\xfa\xa8\x68\x3f\xe3\xc0\x26\xcd\x3c\x9d\xfd\xe2\xc5\x51\x5d\xe1\xd1\x0e\x91\xc4\x97\x4b\xbc\x98\x7a\xcc\xcf\x6f\xc0\xd5\x2b\x29\x9e\x84\x64\x92\x80\xca\x70\x7b\x90\xf3\x29\x9f\x8e\xbb\x13\x45\x1b\x52\x8f\x49\xb3\x60\xfb\xb2\x01\xb4\x70\xc9\xac\xfe\x42\x33\x81\x0b\x53\x4f\x82\x70\x96\x81\x35\xa0\x21\xd8\x1a\xec\x3a\x32\x36\xd0\x3e\xc4\xa8\x25\xd7\xb0\xb0\x7e\x91\x63\xee\x43\x12\x8e\x97\x7f\x07\x5f\x68\xfb\x49\x61\xfd\x8d\xdc\xe8\xc9\xe2\xc9\xb1\x80\x4f\x02\x7d\x61\x27\x4b\x82\xe2\xe8\xcf\x02\x7a\x1b\x14\x0a\x22\x14\xe1\xd9\xef\xa8\x85\x92\xba\x2e\x86\x83\x12\xfb\xd6\x6b\xff\x9e\x95\xd8\x5b\xb2\xcf\x6e\x88\x0f\x75\x4d\x8f\x6e\x0b\x4f\xeb\xc6\x35\xd2\x82\x57\xee\xc7\xa8\x71\xae\xb3\x59\x92\x3c\x5d\xbe\xa4\x66\x85\xba\x4e\x6a\x4e\xd6\x8a\xd7\x49\xcd\x69\xbc\x88\xd3\xc4\x9a\x32\xf1\x42\x87\x8f\xb8\xe6\x9f\x3f\xaf\x66\xf3\x93\xcf\xab\xd9\xf9\x78\x38\x17\xae\x21\x43\x6f\xec\xd3\xd9\x78\x79\x29\x72\x7d\xf5\x66\x43\x80\xca\x32\x50\xb8\xc7\xc3\x5b\x68\x64\x2d\x35\x2a\xe8\xd8\x86\x9b\x20\x75\xa9\x7a\x41\xe0\xb6\x0c\x74\x87\xfe\x95\x0f\x52\x6f\xfd\x00\xb8\x02\x8b\x5b\x08\x14\x1a\x6f\x8d\x06\xa9\xc1\x10\x2a\xd8\xb2\x51\x22\x24\x29\xef\xa7\xd3\x53\x82\x6f\x44\x70\xe3\x9b\x5e\xe5\xd9\x0a\x6a\x3b\x7b\xbb\x4b\x7a\x5d\xb2\xde\x90\x71\x89\x4f\x95\x74\xc9\xe9\x7a\x85\x78\x96\x96\x8b\x14\x97\xf3\x39\xce\xab\x79\x45\xb4\x3a\x17\xe5\x62\x9e\xae\x16\xab\x92\xce\x69\x59\xae\xd7\x34\x0e\x59\xf9\xef\x09\x25\xb6\x1d\xef\x12\x6a\xd7\x24\x5a\x91\x74\xbd\x52\x49\x3a\x4b\x2a\xa9\xc8\x8e\x43\xa0\x0e\xf4\xe2\xe8\xe1\xa7\x7f\x03\x00\x00\xff\xff\xde\x7d\xfb\xf0\x00\x07\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/1/events": &vfsgen۰DirInfo{
			name:    "events",
			modTime: mustUnmarshalTextTime("2016-09-24T22:00:50Z"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/10": &vfsgen۰DirInfo{
			name:    "10",
			modTime: mustUnmarshalTextTime("2016-10-26T06:43:00Z"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/10/0": &vfsgen۰CompressedFileInfo{
			name:             "0",
			modTime:          mustUnmarshalTextTime("2016-10-26T06:42:58Z"),
			uncompressedSize: 1524,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xbc\x93\x41\x6f\xe2\x30\x10\x85\xef\xfb\x2b\xac\xb9\xec\xae\x36\x4d\xe2\x89\xed\xd8\xbe\xb5\xa5\x5b\xad\x54\xed\xa1\xe5\xd4\x82\x44\x08\x16\xc9\x2a\xb1\x51\x62\x84\x00\xf1\xdf\x57\x81\x56\xd5\x56\x84\xf4\xb4\xc7\x68\xbe\xc9\x9b\x79\x6f\xbc\x87\x27\x9f\x79\x03\x1a\xdc\xca\x58\x08\x60\x5c\xfa\xaa\xfb\x7c\x2a\xed\xb2\x32\xa4\x5d\x65\xb9\x69\xc9\xdc\xf8\x8d\x31\x96\xb4\xc6\x7a\x63\x73\xd3\x42\x00\x0f\xd9\xdc\x54\x2d\xe8\x97\x3d\xfc\xce\xea\xae\xe7\x3a\xcf\xcd\xca\x9b\x05\x04\x70\xeb\x2a\xd7\x80\xde\xc3\x23\x68\x44\x16\xc0\x3d\x68\x4c\x78\x00\x37\xa0\x91\xf1\xc3\x61\x1a\xc0\xf5\xda\x17\x27\xe8\xd7\x08\x34\x55\xc8\x68\xc2\x02\x18\xb9\x3a\x2b\x2d\x68\x58\x96\xbe\x58\xcf\xc3\xdc\xd5\x70\x08\xe0\xb6\x31\x99\x37\x8b\x6b\x0f\x1a\x30\xa6\xe2\x2a\x56\x57\xc8\xc6\x88\x9a\x26\x1a\xd3\x50\x29\xa9\x52\x29\x53\xf1\x0c\x01\xdc\x2d\xca\x6e\x0e\xbd\x87\x9b\xed\x67\x05\xfe\xfd\xb3\x1c\xc7\x52\x33\xa1\x91\x87\x94\x09\x8a\x29\x93\xf4\xb9\xc3\x6e\xdc\x62\x0b\x1a\x46\x8e\xf8\xa2\x6c\xf5\xc4\x4e\xec\x6c\x36\x9b\xd8\x28\x22\x4f\xaf\xee\x10\x67\x4d\xf8\xfe\xe5\x37\x2e\x7c\x85\x26\x76\xe4\xec\x57\x4f\x16\x83\xdd\x3d\xed\x3f\x5d\x43\x72\x67\xdb\xb2\xed\x8a\x5b\xb2\x29\x7d\x41\xee\x1d\x69\xfd\xb6\x3a\x6a\x1a\xf2\x72\xfb\x40\x30\x8e\x11\xa7\xdf\x0a\xef\x57\xad\x8e\xa2\xa5\xab\x32\xbb\x0c\x5d\xb3\x8c\xf2\x2a\x3a\x16\xbf\x87\x10\xc0\xa3\xc9\x72\x5f\x3a\x7b\x4a\xf1\xae\x76\x7f\xca\xce\x29\x28\x4c\xd6\x78\x78\x4b\xe8\x54\x3d\x5a\x18\xa3\x14\x3c\x91\x7d\x1e\x9e\x28\x4c\xb8\xe2\x2c\xb9\x0c\x29\x96\x70\x95\x5e\x66\xa8\x42\x29\x14\x1d\x80\x90\x31\x15\xc7\x43\x90\x94\x82\x73\x31\x44\x61\x3a\xa0\x86\x8c\xb3\xee\x8c\x2f\x31\x4c\x70\x14\xaa\xf7\xd0\xde\xac\x64\x29\x8a\x3e\xb5\x69\x87\xbd\xe7\xf1\x83\x9e\x09\xe3\xb8\x12\xfe\x37\x73\x44\x9c\x4a\x31\x94\xfc\x27\xdc\x41\xca\x63\x2e\x06\x92\x4f\xa8\xe8\x1e\xeb\x65\x88\xa3\x1c\xda\x5f\xf0\x78\x60\x64\xc9\x24\x1f\x1c\x99\x89\x44\xf6\x5e\xfd\x87\xac\xea\x75\x5b\x34\xce\xd5\x67\x12\x13\x52\x62\x32\x70\x60\x17\x26\xfe\x20\xb4\xdb\xed\xce\x3d\xd1\x04\x95\xe2\x7d\x0b\x4d\x0f\xd3\xc3\x97\xbf\x01\x00\x00\xff\xff\xc7\xbb\x12\x7f\xf4\x05\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/10/events": &vfsgen۰DirInfo{
			name:    "events",
			modTime: mustUnmarshalTextTime("2016-09-24T22:13:27Z"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/11": &vfsgen۰DirInfo{
			name:    "11",
			modTime: mustUnmarshalTextTime("2016-09-30T03:56:06Z"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/11/0": &vfsgen۰CompressedFileInfo{
			name:             "0",
			modTime:          mustUnmarshalTextTime("2016-09-29T18:07:08Z"),
			uncompressedSize: 668,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x90\x3d\x6f\x22\x31\x10\x86\xfb\xfb\x15\x73\xd3\xdc\x9d\xb4\x7c\xec\xf2\x21\xd6\x12\x05\x97\x4d\x91\x1a\xaa\xc8\x85\x9d\xdd\x61\xd7\x92\xb1\x91\x3d\x14\x08\xed\x7f\x8f\x8c\x44\x14\x10\xa1\x88\x52\x7a\xe6\xd5\x33\xef\xe3\x13\xae\x59\x33\xa1\xc0\xda\xfa\x48\x0d\x66\xb8\x31\x6c\xd3\x60\x13\x8e\xc0\x1e\x3a\xed\x1a\x4b\x40\x21\xf8\x10\x61\x6b\x42\x64\x88\x1e\xb8\x23\xe8\xf4\x7e\x7f\x84\xbd\xe6\x0e\x4c\x84\xda\x92\x0e\x98\xe1\xea\xc0\x9d\x0f\x28\x4e\xf8\x52\xa1\x28\x26\xb3\x72\x36\x9d\x64\x58\xf9\x9d\x36\x0e\x05\xb6\x86\xbb\xc3\xdb\xb0\xf6\x3b\xec\x33\x7c\x0a\xa4\x99\x9a\x15\xa3\xc0\x62\x9c\xcf\x07\xe3\x72\x50\x2c\x36\x79\x29\x8a\x85\x98\x96\xc3\x62\x9e\xcf\xca\x71\xbe\x98\xbc\x62\x86\xff\x7d\x73\x44\x81\x55\x3a\x6f\xa2\x90\x4e\x3a\xa5\x54\xeb\xad\x76\x6d\x7a\x50\x08\x20\x96\xd0\xf8\xb5\xdf\x11\x77\xc6\xb5\x7f\xff\xa5\xb9\xd9\xa6\xfe\xf0\x7b\x09\xce\x58\x38\x49\x27\x79\x34\xba\x98\x25\x93\xb3\x9d\x74\x7d\x0a\x9f\x37\x1f\x62\xb5\x77\x6c\xdc\x81\xe2\x85\x7f\x85\x7f\xb6\x91\x7e\xf2\x84\x52\x2a\xed\x2b\xef\xfe\x30\x34\xdf\xd4\x5c\xde\x76\xb8\x2f\x23\xf9\x81\x8e\xe4\x3b\xb0\x47\x38\xee\x81\x6c\xa4\xab\xe0\xad\xbb\xe4\x5e\xba\xcf\xb9\xaf\x7e\x48\x29\x85\xfd\xaf\xf7\x00\x00\x00\xff\xff\xc7\x80\xd7\xff\x9c\x02\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/11/1": &vfsgen۰CompressedFileInfo{
			name:             "1",
			modTime:          mustUnmarshalTextTime("2016-09-29T01:42:58Z"),
			uncompressedSize: 557,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x8c\x90\x31\x6f\xdb\x40\x0c\x85\xf7\xfe\x8a\x57\x2e\x59\x14\xc1\x92\xe5\x34\xd6\xd4\xc4\x09\x52\x6f\x45\x9b\x29\xd0\x72\x96\x28\xe9\x60\x99\x14\xee\x28\xb7\x46\x90\xff\x5e\x9c\xbb\x76\xe8\x4c\xf2\x7b\xdf\xe3\x3b\x3d\x2c\x36\x6a\xa0\xfa\x9d\xf6\x4f\x54\x17\xdb\xb2\x2a\xd6\x55\x46\x4f\x7a\x72\x5e\xa8\xa6\xc1\xdb\xb8\x1c\xf2\x56\x4f\xf4\x91\xd1\x2e\xb0\x33\xee\x1e\x8c\x6a\x2a\x57\xc5\xdd\xed\x6a\x7b\x5b\x6e\x5f\x57\x45\xbd\xde\xd6\x55\x99\x97\x9b\x75\x55\x6e\x8a\xa2\x7c\xa3\x8c\x9e\x3b\x6f\xdc\x25\xf4\xe3\xe5\x7f\x03\xfe\x41\xae\xca\x7a\x73\x9f\x57\xeb\x2f\xe5\xfd\xea\x6e\xf3\x96\xb6\x1e\xb5\xbb\x50\x4d\xdf\xf8\x82\xaf\x81\xc5\x89\xcc\xc1\x75\x9a\xc1\x46\x27\xc7\x88\x5e\x03\x5a\x15\x0b\xfe\xb0\x98\x97\x01\x36\x32\x7a\x1f\xa2\x61\x0e\x3a\x6b\x74\xd3\xe7\x46\x1a\xd9\xc3\x46\x2f\x47\xec\x6f\xce\x8c\xc8\x2c\x09\x60\x50\x61\xb8\x29\xb0\xeb\x2e\x19\xbc\xdd\x44\xb0\xb7\x91\x03\x1c\x66\x17\x0c\xda\xe3\xb9\xef\xb9\x35\x7f\x66\xbc\x28\x34\x60\xa7\x1d\xff\xe0\xb3\xe7\x5f\x3b\x3d\x9d\x58\x2c\xe6\xd8\xf7\x88\x57\x27\x0e\x7c\x13\x21\x8a\x59\xbd\x18\xbc\x20\xf0\xcc\xee\x6a\xe6\x0d\x69\x9e\x21\x7a\x69\x39\xf9\x44\x4c\x3e\x1a\x22\x87\x33\x47\x98\xc2\x2d\x43\x22\xc2\x46\x8d\x8c\x12\x9d\xb6\xcb\xdf\x88\xd4\xe1\x7b\xfe\x33\xc7\xab\x62\x60\x43\xbc\x88\xb9\xdf\x18\xfd\x30\x4e\x7e\x18\x53\x40\x86\x25\xf2\xb5\xff\xe4\x64\x58\xdc\xc0\x10\x77\x62\x34\xf4\xa2\x0d\x25\x97\xeb\x6f\x58\x5a\xee\xd0\x6a\xc7\x38\x4c\xda\x1e\x33\x88\x1a\x1a\x1a\x34\x9d\x35\x94\xd3\xc7\xa7\x3f\x01\x00\x00\xff\xff\xba\xa8\xaa\x49\x2d\x02\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/11/2": &vfsgen۰CompressedFileInfo{
			name:             "2",
			modTime:          mustUnmarshalTextTime("2016-09-29T01:41:39Z"),
			uncompressedSize: 264,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x44\xcd\xbf\x6e\xc2\x30\x10\x80\xf1\xbd\x4f\x71\xba\x0e\x2c\x09\x21\x7f\x84\x14\x2f\x15\x85\x85\xb5\xea\xd2\x8a\xc5\x8d\x8f\xf8\x84\xe3\x43\xf6\xa5\x11\x42\xbc\x7b\xd5\x2e\x9d\x3f\xe9\xfb\xdd\x71\x37\xab\x97\x84\xe6\x8e\xc7\x03\x9a\xba\x6f\xba\xba\xed\x0a\x3c\xc8\x64\x39\xa2\xc1\x91\xd5\xcf\x5f\xeb\x41\x26\x7c\x14\xb8\x4f\x64\x95\xdc\x4e\xd1\x60\xb3\xa9\xb7\xe5\xa6\x2f\x9b\xfe\x7d\x53\x9b\xae\x36\x6d\xbf\xde\xd6\x6d\xd7\x76\x6d\xb3\xfd\xc4\x02\x5f\xc5\xdd\xd0\xe0\x07\x5d\x0b\x38\xcb\x1c\x1d\xb0\x42\xe2\xd1\x2b\x78\x4a\x64\x4e\xf1\x14\xbd\xea\x35\x9b\xaa\xfa\x67\xaa\x51\x82\x8d\x63\x35\x4a\xb5\xf0\x85\xab\xbd\x38\x7a\xa3\x6f\xa6\x65\x2f\xd3\x44\x51\xf3\x33\x47\x47\x51\x4b\x4a\x49\x52\x79\x0e\xb2\xfc\x9e\x8e\xab\x10\x60\x08\x92\x09\xd4\x73\x06\xf5\x14\x21\x73\x1c\x08\x58\x57\x19\x2c\xb8\xf9\x1a\x78\xb0\x4a\x05\xfc\x75\xab\x20\x17\x7b\x7b\xc1\xc7\xd3\x4f\x00\x00\x00\xff\xff\xd1\xe4\xc5\x30\x08\x01\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/11/3": &vfsgen۰CompressedFileInfo{
			name:             "3",
			modTime:          mustUnmarshalTextTime("2016-09-29T16:50:18Z"),
			uncompressedSize: 256,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x44\xcc\xb1\x4e\xc3\x30\x10\x80\xe1\x9d\xa7\x38\x6e\x61\x49\xa3\x24\x25\x25\xf6\x56\xe8\xd2\x99\x2e\xa0\x2e\x57\x7c\xc1\x56\xd3\x3b\xe4\x5e\x40\x56\xd5\x77\x47\xaa\x90\x98\xff\x5f\xdf\x05\xd7\xb3\x45\xcd\xe8\x2f\xb8\xdd\xa0\xef\x96\xbd\xeb\x1f\x97\x15\x6e\xf4\x44\x49\xd0\xe3\x67\xb2\x38\x1f\xea\x0f\x3d\xe1\xb5\xc2\x97\xcc\x64\x1c\xd6\x86\x1e\xbb\xa6\x5d\x2d\x1a\xb7\xe8\xdc\xae\x5d\xf9\xbe\xf1\xed\x50\x3b\xd7\x0f\x4f\xdd\xe0\xde\xb1\xc2\x67\x0d\x05\x3d\xbe\x6a\xce\x05\xe8\xa0\xb3\x81\x45\xb2\x1a\xb6\x10\x52\x90\x07\x83\x2f\x2a\x40\x66\x2c\x96\x54\x6e\x11\x8a\xce\x10\x29\x80\xc5\x74\x06\x15\x06\x9a\x32\x53\x28\x90\xfe\x06\xb5\xc8\x19\xa6\x24\xc7\x1a\xde\x98\x62\x05\x23\xf3\x04\x63\x66\x06\x53\xe0\x6f\x16\x08\x3c\xb1\xf1\xbf\x91\xc6\x9b\xfb\x43\x62\xf5\x5e\xf6\xb2\x8b\x24\xc7\xf3\x3d\x5e\xef\x7e\x03\x00\x00\xff\xff\x45\xf8\x48\xb4\x00\x01\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/11/4": &vfsgen۰FileInfo{
			name:    "4",
			modTime: mustUnmarshalTextTime("2016-09-29T18:07:08Z"),
			content: []byte("\x7b\x22\x41\x75\x74\x68\x6f\x72\x22\x3a\x7b\x22\x49\x44\x22\x3a\x31\x39\x32\x34\x31\x33\x34\x2c\x22\x44\x6f\x6d\x61\x69\x6e\x22\x3a\x22\x67\x69\x74\x68\x75\x62\x2e\x63\x6f\x6d\x22\x7d\x2c\x22\x43\x72\x65\x61\x74\x65\x64\x41\x74\x22\x3a\x22\x32\x30\x31\x36\x2d\x30\x39\x2d\x32\x39\x54\x31\x38\x3a\x30\x37\x3a\x30\x38\x2e\x37\x34\x35\x32\x37\x31\x32\x32\x37\x5a\x22\x2c\x22\x42\x6f\x64\x79\x22\x3a\x22\x4e\x6f\x20\x77\x6f\x72\x72\x69\x65\x73\x2c\x20\x74\x68\x61\x6e\x6b\x20\x79\x6f\x75\x20\x61\x6e\x79\x77\x61\x79\x21\x20\x49\x20\x61\x70\x70\x72\x65\x63\x69\x61\x74\x65\x20\x69\x74\x2e\x20\x3a\x29\x22\x7d\x0a"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/11/events": &vfsgen۰DirInfo{
			name:    "events",
			modTime: mustUnmarshalTextTime("2016-09-30T03:56:13Z"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/11/events/1": &vfsgen۰FileInfo{
			name:    "1",
			modTime: mustUnmarshalTextTime("2016-09-29T18:07:08Z"),
			content: []byte("\x7b\x22\x41\x63\x74\x6f\x72\x22\x3a\x7b\x22\x49\x44\x22\x3a\x31\x39\x32\x34\x31\x33\x34\x2c\x22\x44\x6f\x6d\x61\x69\x6e\x22\x3a\x22\x67\x69\x74\x68\x75\x62\x2e\x63\x6f\x6d\x22\x7d\x2c\x22\x43\x72\x65\x61\x74\x65\x64\x41\x74\x22\x3a\x22\x32\x30\x31\x36\x2d\x30\x39\x2d\x32\x39\x54\x31\x38\x3a\x30\x37\x3a\x30\x38\x2e\x38\x30\x32\x33\x30\x33\x38\x34\x38\x5a\x22\x2c\x22\x54\x79\x70\x65\x22\x3a\x22\x63\x6c\x6f\x73\x65\x64\x22\x7d\x0a"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/12": &vfsgen۰DirInfo{
			name:    "12",
			modTime: mustUnmarshalTextTime("2016-12-14T21:37:34Z"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/12/0": &vfsgen۰CompressedFileInfo{
			name:             "0",
			modTime:          mustUnmarshalTextTime("2016-12-14T21:37:30Z"),
			uncompressedSize: 1238,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x9c\x93\x51\x4f\xdb\x3a\x14\xc7\xdf\xef\xa7\x38\x3a\x2f\xf7\x56\x84\xa4\x76\x1b\x68\x2c\x5d\x4d\x85\x32\x34\x09\x6d\x12\x74\x2f\xb4\xd5\x30\xce\x59\x62\x96\xd8\x99\xed\x80\x50\xd5\xef\x3e\xa5\x1d\xd0\x15\xa1\x01\x8f\x27\xf9\x9d\xdf\xb1\xfc\xf7\x59\xe2\x45\x90\x81\x50\xa0\x6d\xc8\x60\x84\x53\x1d\xaa\xae\xfc\xea\x09\x94\x35\x5e\xfb\x40\x26\x80\x6f\xa8\xaa\xb4\x29\xc0\x7e\x07\x45\x2e\x48\x6d\xe0\xce\xba\xdc\x63\x84\x67\xf2\x9a\x2a\x8f\x62\xb6\xc4\xcf\xb2\xee\x9a\xc7\x4a\x51\x13\x28\xc7\x08\x8f\x6d\x65\x1d\x8a\x25\x9e\xa3\xe0\x7c\x18\xe1\x29\x0a\x3e\x48\x23\x3c\x42\xc1\x87\xe9\x6a\xb5\x88\x70\xdc\x86\x72\x03\x7d\x9a\xa0\x60\x19\x1f\xb2\xc1\x30\xc2\x89\xad\xa5\x36\x28\xb0\xd0\xa1\x6c\xaf\x63\x65\x6b\x5c\x45\x78\xec\x48\x06\xca\xc7\x01\x05\xf2\x3e\x3b\xd8\x67\xfd\x7d\x96\x4e\x39\x17\x2c\x13\xc3\x34\xe6\xac\x3f\x62\x59\xca\xf9\x25\x46\x78\x92\xeb\xee\x1c\x62\x89\x47\xf7\xaf\x1d\xb0\x65\xe6\xfb\x6c\x30\x65\x99\xe0\xa9\x48\x47\x71\x7a\xc0\x87\xfd\xf4\x30\xbb\xec\xa8\x23\x9b\xdf\xa3\xc0\x89\x85\x50\x6a\x2f\xe6\x66\x6e\xae\xae\xae\xe6\x26\x49\xa0\x96\xce\x97\xb2\xbb\xae\x75\xd9\x9a\x9d\x0f\x4a\x1a\x45\x3b\x95\x0c\xda\x3e\x28\xe6\x66\x62\xcd\xbf\x01\xf2\x97\xdd\xcf\xe5\x3b\xbe\xdd\xf2\x4f\xff\x47\xeb\x9e\xd2\x55\xf7\x70\xa7\x43\x09\xa1\x24\x38\xb5\xd0\x38\x7b\x43\x2a\xc4\x30\x2d\xc9\xd3\x26\x65\x28\xe5\x2d\x41\xdd\x56\x41\x37\x15\xc1\xad\xac\x74\xfe\xf8\x26\xfc\x1a\xdd\x6a\x85\x46\xab\x1f\x1e\xac\xa1\x18\x2e\x88\x60\x76\x7c\x06\x6c\xc8\xd2\xfe\xe2\xbf\x32\x84\xc6\x8b\x24\x29\x6c\x25\x4d\x11\x5b\x57\x24\xaa\x4a\xd6\x3f\x7b\x11\xcc\xb4\xf7\x2d\x01\x3b\xcc\x06\xa3\x2d\xf6\x31\x9d\xdf\x6d\x49\x61\x93\x35\xe9\x93\x35\xda\x8b\x61\x5c\x79\x0b\xca\xd6\x8d\x74\x04\xb3\xee\xd6\xfe\xd2\xef\x49\x3a\x55\x7e\xf8\xf9\xff\x53\x36\x7b\x5f\xce\xf7\xb6\xb3\xea\xc1\xad\x7f\x97\xeb\x99\x6c\x6d\x8b\x40\x9a\xfc\x6d\xbe\xad\xa7\xf1\xf6\xc3\x6c\x07\xdf\x8b\x31\xc2\x73\x92\xaa\x2b\x36\xab\x7a\x52\xdb\x1b\xdd\xad\x03\x06\xa7\xa5\x29\xda\x4a\xba\x6f\xae\xad\xc8\xe1\xc3\x46\x6e\xc0\x57\xac\xcc\x06\x3a\x18\x8d\xf8\x80\xbd\xc0\x2c\x3a\xea\x69\x66\x4d\xb5\x7d\xf7\x1c\x7e\x38\xca\x5e\x9e\xb3\x58\xfd\xf3\x2b\x00\x00\xff\xff\x56\x78\x0d\x7d\xd6\x04\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/12/events": &vfsgen۰DirInfo{
			name:    "events",
			modTime: mustUnmarshalTextTime("2016-10-15T22:19:45Z"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/2": &vfsgen۰DirInfo{
			name:    "2",
			modTime: mustUnmarshalTextTime("2016-10-22T22:32:44Z"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/2/0": &vfsgen۰CompressedFileInfo{
			name:             "0",
			modTime:          mustUnmarshalTextTime("2016-10-03T21:36:32Z"),
			uncompressedSize: 1989,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xcc\x55\x4d\x6f\x1b\x37\x10\xbd\xf7\x57\x0c\xa6\x87\x1e\xc2\xac\x76\xa9\xd5\x17\x6f\xfe\x08\xd2\x00\x49\x0f\xb6\x81\x02\x89\x0c\x8b\x5a\x8e\xb5\x6c\x76\x49\x95\x9c\x95\x23\x08\xfa\xef\x05\xa5\xc8\x4e\x0b\xc5\x72\x51\xa0\x88\xa0\x83\x56\xf3\xf8\xe6\xbd\x37\xe2\x68\x83\xd7\xac\x99\x50\xa1\x5f\x92\x43\x81\x37\x96\x9b\xf4\xf8\xa1\x63\xfa\x02\xb5\x66\x14\xf8\x5e\xcf\xa9\x89\xa8\x3e\x6d\xf0\x37\xdd\xa6\xea\x59\x55\xd1\x92\xc9\xa0\xc0\x0b\xdf\xf8\x80\x6a\x83\x57\xa8\xa4\x2c\x05\xbe\x45\x25\xfb\x03\x81\xe7\xa8\x64\x39\xd8\x6e\x6f\x05\x9e\x75\x5c\xef\x41\xef\x2e\x51\x15\x13\x59\x16\xfd\x52\xe0\xa5\x6f\xb5\x75\xa8\x70\x61\xb9\xee\xe6\x59\xe5\x5b\xdc\x0a\xbc\x08\xa4\x99\xcc\x19\xa3\x42\x99\x17\xc3\xd7\xf9\xe4\xb5\x2c\x6f\xa4\x54\x79\x5f\x15\xc3\x4c\xca\xbc\xcc\x47\x83\x5c\x7e\x44\x81\x6f\x8c\x4d\x3a\xd4\x06\xcf\xd7\x2f\x6d\xf0\x77\xe6\xf1\x4d\x31\x51\x32\x57\xfd\x7e\x36\x9e\x8c\x86\xe5\x20\x1f\x95\x1f\x13\xec\xdc\x9b\x35\x2a\x9c\xcd\x66\x6f\xfd\xd4\x45\x0e\x5d\xc5\xb0\x99\xba\x29\x67\x59\x36\x75\xe9\x43\xd0\x4c\x1f\x3a\x48\xaf\xb8\x76\x55\xb6\x4b\xed\x50\x78\x6f\x5b\xcb\x11\x3e\x55\x9a\x69\xe1\x83\xa5\x78\x7b\xa5\x99\x52\xb9\xf5\x91\xaf\xa8\x22\xc7\xf0\x88\xbc\xd8\xc3\xd6\x53\xb7\x9d\xba\xd9\x6c\x96\x3a\xfc\x4a\x81\x04\xcc\xf6\x6d\x66\x60\x23\x68\x68\x0f\x93\xc9\xe0\x1d\x43\xb4\x1c\x05\x34\xf6\x33\x81\x4e\x5f\x0a\xf0\x0e\xd8\x2f\xc1\xdf\x03\xd7\x04\x2b\x1d\xac\x9e\x37\x14\x81\x6b\xcd\x60\x19\x96\xc1\x33\x55\x1c\x77\x16\xae\xbd\x80\x07\xcb\xb5\xef\x18\x1c\x91\xb1\x6e\x01\xec\xe1\x21\x58\xa6\xdd\xf9\xca\xb7\x2d\x39\x16\xbb\x07\x3d\xf7\x2b\x4a\x2a\x6c\xbb\x6c\x6c\x65\xb9\x59\x43\xe7\x0c\x85\xc8\xde\x9b\x74\x70\x4e\x40\x7f\x76\x76\xa5\x9b\xe4\x8d\xbd\x4a\x4d\x9e\x4b\xb0\xd7\x83\xaf\x21\x1e\x74\xc1\x37\xd9\x69\x67\xe0\x29\xab\xec\xff\x88\xfc\xf7\x9a\x1c\x68\xb3\x4b\x42\x83\xa3\x07\x01\x9d\x0b\xd4\xa4\x9f\x24\xdc\x5b\x6a\xcc\xd7\x24\xa3\xfb\xe5\x31\x4c\x32\x30\x5f\x3f\xce\x49\x80\xf1\xc0\xb5\x8d\x07\xf7\xc6\xde\xdf\x4f\x1d\x3c\x05\x00\x8f\x09\xc0\x77\x1d\xc1\x09\x4b\x70\xca\xd3\xab\xf4\xe6\x34\x40\xef\x20\x52\x58\xd9\x2a\x1d\x7b\xb2\x7a\xe9\x93\x85\x1f\x44\xeb\x41\xe8\x8e\xfa\x88\xd8\x6b\x22\xa8\x99\x97\x51\xf5\x7a\xac\x9b\xcf\x31\x5b\xf8\x46\xbb\x45\xe6\xc3\xa2\x27\xf3\xa2\xec\x05\xd2\x46\xcf\x6d\x63\x79\x9d\xc5\xc6\x1a\xfa\x59\x16\x19\x0a\xbc\x22\x5d\xb1\xf5\x6e\xbf\xc1\xde\xb4\xfe\x0f\x9b\xb6\x04\xa6\x8b\x84\x87\xe5\xb4\x2f\x9e\xde\x1e\xb7\x5b\xf1\x2d\x47\x4d\x7a\xb5\xbe\x6b\xbb\x86\x6d\xba\x11\x3a\xf5\xb9\xfb\xf2\x5f\x59\xd9\x2f\xf7\x9b\xf7\xdf\xb1\x88\x3d\x68\x30\x1e\x16\xe3\xe7\x21\xb2\x9f\x4b\xf9\x3c\xa4\x90\x72\x54\xbc\x4c\xee\xab\xe2\x88\xd4\x61\x3e\x1a\x0f\x4f\xc9\x28\x07\x65\xfa\xab\x78\x0e\xd3\x2f\x86\xc9\xf3\x09\xb1\x7d\x39\x99\x0c\xbe\xc7\xf4\x0f\xb9\x6d\x17\xeb\xe0\x7d\x7b\x4c\xf4\x78\x2c\xfb\x2f\x74\x1d\xb4\x8d\x64\xee\x6a\xed\x4c\x3c\x42\x25\xc7\x72\x34\x90\x2f\xe4\x5a\x04\xeb\x9c\x75\x8b\x63\x23\x3f\x61\xed\x76\xfb\xd3\x5f\x01\x00\x00\xff\xff\x14\xe6\xe3\xed\xc5\x07\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/2/1": &vfsgen۰FileInfo{
			name:    "1",
			modTime: mustUnmarshalTextTime("2016-09-28T13:16:24Z"),
			content: []byte("\x7b\x22\x41\x75\x74\x68\x6f\x72\x22\x3a\x7b\x22\x49\x44\x22\x3a\x31\x37\x36\x37\x31\x31\x38\x2c\x22\x44\x6f\x6d\x61\x69\x6e\x22\x3a\x22\x67\x69\x74\x68\x75\x62\x2e\x63\x6f\x6d\x22\x7d\x2c\x22\x43\x72\x65\x61\x74\x65\x64\x41\x74\x22\x3a\x22\x32\x30\x31\x36\x2d\x30\x39\x2d\x32\x38\x54\x31\x33\x3a\x31\x36\x3a\x32\x34\x2e\x36\x35\x36\x37\x30\x38\x39\x39\x37\x5a\x22\x2c\x22\x42\x6f\x64\x79\x22\x3a\x22\x45\x76\x65\x6e\x20\x62\x65\x74\x74\x65\x72\x20\x68\x65\x72\x65\x20\x69\x73\x20\x74\x6f\x20\x6d\x6f\x76\x65\x20\x74\x68\x65\x20\x6e\x65\x77\x20\x66\x69\x65\x6c\x64\x20\x61\x62\x6f\x76\x65\x20\x74\x68\x65\x20\x6d\x75\x74\x65\x78\x2e\x22\x7d\x0a"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/2/2": &vfsgen۰CompressedFileInfo{
			name:             "2",
			modTime:          mustUnmarshalTextTime("2016-09-28T15:34:49Z"),
			uncompressedSize: 266,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x1c\x8e\x31\x6f\xc2\x30\x10\x46\xf7\xfe\x8a\x4f\x37\x87\x28\x09\x2e\x2d\x9e\x0a\x65\x61\x67\xea\xe6\xc4\x27\x6c\x29\xdc\x45\xe1\x5c\x11\x21\xfe\x7b\x95\xee\xef\x3d\xbd\x27\x1d\x8a\x25\x9d\xc9\x3f\xe9\x7c\x22\xdf\xee\x3b\xd7\x6e\x5d\x45\x27\xbd\x85\x2c\xe4\xe9\x9a\x2d\x95\xbe\x1e\xf4\x46\xaf\x8a\xbe\x67\x0e\xc6\xf1\x60\xe4\xa9\x6b\xda\xdd\xa6\xd9\x6f\xba\xcf\x4b\xfb\xee\xb7\xce\xbb\x7d\xdd\x34\xae\xeb\xda\xdd\x87\xfb\xa1\x8a\x8e\x1a\x17\xf2\xf4\x25\xf9\x9a\x6c\x5c\x54\x18\x67\xc3\xcc\x61\x1c\x17\x44\x9e\x58\xe2\x1d\x2a\xb0\xc4\x18\x54\x8c\x1f\x56\xe3\x58\x0c\x0b\x87\x54\x21\x1b\x86\x20\xe8\x19\x21\x46\x8e\x08\xbd\xfe\x32\x4c\xb5\xc6\x25\x31\x26\xcd\x62\xc8\x77\x98\x42\xd4\xd0\x8f\x59\xe2\xb8\xac\xf0\xaa\x9a\xfe\x77\x6f\xc5\xf8\xb1\x99\x66\x35\x1e\x8c\x23\xae\xb3\x96\x09\x45\xb2\x18\x8b\x65\x95\x75\xa6\xa6\xd7\xdb\x5f\x00\x00\x00\xff\xff\x93\x54\x85\xa0\x0a\x01\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/2/3": &vfsgen۰CompressedFileInfo{
			name:             "3",
			modTime:          mustUnmarshalTextTime("2016-10-22T22:30:39Z"),
			uncompressedSize: 694,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x74\x92\x41\x8b\xdb\x4c\x0c\x86\xef\xdf\xaf\x10\xba\x7c\x87\x7a\x4d\xec\x94\x24\xf6\xa5\xa4\xbb\x3d\x04\xba\x14\x42\xa1\xd0\x75\x20\xe3\xb1\x1a\xab\xf1\x8c\x82\x47\xce\xae\x1b\xf2\xdf\x8b\xed\xdd\x2e\xa5\xec\x1c\x66\xc4\xab\x47\xd2\x3b\xa0\x0b\xae\x3b\xad\xa5\xc5\xfc\x82\x9b\x3b\xcc\xd3\x65\x92\xad\xd2\x08\xef\xc4\x19\xf6\x98\xe3\x81\xb5\xee\xca\xd8\x8a\xc3\x6b\x84\xb7\x2d\x19\xa5\x6a\xad\x98\x63\x3a\x4b\x16\x37\xb3\xec\x26\x5d\x7d\x4d\xb2\x3c\xc9\xf2\xf9\x32\x4e\xb2\xe5\x62\x36\x9f\xbd\x5f\x7e\xc7\x08\x3f\x4a\xd5\x63\x8e\xfb\xfd\xbe\xf0\x41\xdb\xce\x2a\x5c\x0a\x0f\x00\x10\xc7\x71\xe1\xa7\xb0\x35\x4a\xf0\x77\x76\x38\xa1\xf7\x36\xbe\xef\x94\x9e\x5e\xb5\x86\x1d\x6b\x18\xc3\x07\x6b\x94\x0e\xd2\x32\x85\xdd\xd6\x28\xbd\x42\x4e\x82\x6e\xc9\x92\xd7\xb1\xf5\xe7\xa1\xe6\x76\x82\xfb\x89\xba\x4e\xcf\x74\x5b\x71\x4e\x3c\x04\x6a\xcf\x6c\xa9\xf0\xd7\xc2\x8f\x7e\x0b\xff\xad\xee\xc1\x8b\x42\x6d\xce\x04\xc6\x03\x7b\x4f\xed\x8b\xd3\x47\xd6\x7a\x10\xc9\x95\x54\x55\x54\x81\x1b\xac\x7e\x80\x8d\xfe\x1f\xc0\x34\x2d\x99\xaa\x07\xae\x58\x9c\x51\xb6\xa0\x02\x5d\xa0\x7f\x0b\xe0\xb1\x26\x0f\xac\xd0\x88\x3d\x0e\x85\x0d\xb8\x81\x68\x03\xc8\x0f\xd0\x9a\x40\x3a\xfd\x33\x35\x82\x20\xa0\x35\x07\x08\xd2\x74\xca\xa3\x6f\x72\x01\x1a\x3e\x8e\xcd\xa5\x3c\xb3\x74\x01\x0e\xe4\xa9\x35\x0d\xff\x32\x23\xa4\x02\x8e\x62\x58\xfb\x6a\x6c\x49\x4f\xa7\x86\x2d\xeb\xcb\x5f\x82\x95\x13\x01\x07\x28\x49\x87\x61\x5a\x1b\x3f\x82\xcf\x09\x77\x6a\x98\x2a\x28\xfb\x51\x2c\x1b\xe3\x8f\xd0\xb0\x27\xd8\xdc\x7f\x89\x31\xc2\x2d\x19\x3b\xcc\x09\x98\x3f\x5c\xf0\x93\x93\x9f\x3c\x6c\x12\xbe\x4b\x30\x7a\xde\xae\x29\x35\xa8\xf3\x55\xba\x58\xcc\xde\xda\xaf\x89\x59\xa4\xcb\x55\x96\xbc\xc1\xec\xae\xbb\xeb\x7f\xbf\x03\x00\x00\xff\xff\xcd\x94\x02\xcc\xb6\x02\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/2/4": &vfsgen۰CompressedFileInfo{
			name:             "4",
			modTime:          mustUnmarshalTextTime("2016-10-22T22:32:42Z"),
			uncompressedSize: 383,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x8c\xce\xb1\x92\xda\x30\x10\xc6\xf1\x3e\x4f\xb1\xb3\x0d\x8d\xf1\x20\x61\x0c\xa8\x0a\x84\x14\xd4\xa1\xa2\x93\xa5\x05\xed\x60\xa4\x8c\xbc\x0a\xf1\x31\xbc\xfb\x8d\xef\xaa\xeb\xae\xff\xe6\xff\xfb\x9e\xb8\x2b\x12\x52\x46\xf3\xc4\xe3\x01\x8d\xda\xea\x46\x2d\x9b\x0a\x0f\xe9\x6e\x39\xa2\xc1\x2b\x4b\x28\x5d\xed\xd2\x1d\x5f\x15\xfe\xca\x64\x85\xfc\x4e\xd0\xa0\x5e\xa8\x76\xae\x16\x73\xa5\x4f\x8b\xb5\x51\xad\xd1\x4d\xad\x36\x2b\xb5\x5a\xb7\xcd\x19\x2b\xfc\xed\x59\xc8\x4f\xe5\xfd\xf8\xdd\xfe\x97\xb0\xd6\x27\xad\xcd\x52\x9b\x46\xd7\x4b\xd5\x6e\x37\x5a\x6f\xf5\x79\x9a\xed\x93\x1f\xd1\xe0\x4f\xd7\xd9\x9c\xd9\xdd\xe0\x4f\xc9\x54\x81\x04\x2b\xe0\x6c\x84\x8e\xc0\xc2\x3f\xb6\x5d\x4f\x90\xfe\x0a\xa7\x58\x01\x5f\x80\x05\x1e\x29\xdf\x06\x48\x45\x20\xb2\xa3\x7e\x04\x8e\x20\x81\xc0\xa5\x28\xf4\x5f\xe0\x11\x28\xd3\x34\xe4\xa1\x86\x63\x64\x61\xdb\xf3\x1b\xc7\x2b\x0c\xc5\x05\xb0\x30\x48\x2e\x4e\xe0\xce\xd7\x20\x93\x13\x6c\xf6\x94\x2b\xe8\x8a\x00\xcb\xac\xef\x3f\x88\x49\x1b\x53\x01\x9f\xe2\x4c\x20\x12\x79\x90\x04\x3e\x7d\x5e\x4c\x17\xa1\x58\xe3\xeb\xc7\x7b\x00\x00\x00\xff\xff\x50\x52\xcd\xad\x7f\x01\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/2/events": &vfsgen۰DirInfo{
			name:    "events",
			modTime: mustUnmarshalTextTime("2016-09-24T22:03:16Z"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/3": &vfsgen۰DirInfo{
			name:    "3",
			modTime: mustUnmarshalTextTime("2016-10-20T05:07:53Z"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/3/0": &vfsgen۰CompressedFileInfo{
			name:             "0",
			modTime:          mustUnmarshalTextTime("2016-10-19T16:08:39Z"),
			uncompressedSize: 2070,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xa4\x94\x4f\x6f\xe3\x36\x10\xc5\xef\xfd\x14\xd3\xe9\x21\x2d\xaa\xc8\x14\xf5\x8f\x16\xb0\x87\xfc\xeb\x22\x68\xd1\x43\x36\xbd\x6c\x15\xd4\xb4\x3c\xb6\xd8\x48\xa4\x2b\x52\xdb\x1a\x86\xbf\x7b\x41\x27\xee\x76\x0d\x39\xda\x20\x47\x9b\x3f\x3d\xbd\x99\xf7\xa8\x2d\x7e\x70\xd2\x11\x16\x68\xd6\xa4\x31\xc0\x7b\xe5\x1a\xff\xf3\xa6\x5d\xbb\x0d\x58\xd7\x29\xbd\x82\xaa\xa6\xea\x11\x03\xfc\x45\xce\xa9\xb1\x58\xfc\xbe\xc5\x5f\x65\xeb\xb1\x8b\xaa\xa2\xb5\xa3\x05\x06\x78\x65\x1a\xd3\x61\xb1\xc5\x3b\x2c\x38\x4f\x02\x7c\x8f\x05\x8f\xd3\x00\x2f\xb1\xe0\x49\xba\xdb\x3d\x04\x78\xd1\xbb\xfa\x09\xba\xbd\xc6\x22\x9a\xf2\x24\x8a\x93\x00\xaf\x4d\x2b\x95\xc6\x02\x57\xca\xd5\xfd\x3c\xac\x4c\x8b\xbb\x00\xaf\x3a\x92\x8e\x16\x17\x0e\x0b\xe4\x2c\xca\xce\xd9\xf4\x9c\x27\xf7\x9c\x17\x2c\x2e\x92\x38\x14\x8c\xc5\x71\xc2\x92\xf8\x23\x06\x78\xb3\x50\xde\x47\xb1\xc5\xcb\xcd\xd7\xbe\xe0\x4b\x65\x71\x1f\x89\x22\x49\x0b\x36\x0d\xb3\x3c\xce\x44\xcc\x98\xf8\xe8\xb1\x4b\xb3\xd8\x60\x81\xd7\x06\x5c\xad\x6c\x51\xea\x52\xcf\x66\xb3\xf7\xa6\xd4\x6a\xe9\x57\x04\xef\xde\x41\x89\x25\xc2\xb6\xd4\xa5\x0b\xc3\xb0\xd4\xbb\x3d\xe2\xc9\x6b\xa3\xcf\x1c\x2c\x06\x9f\x6d\x48\x7f\x6f\x5d\xf7\x83\x17\x60\x83\x4f\xdf\x2e\x61\x63\xfa\xb3\x8e\x9e\x32\xf0\x61\xa8\x25\xcc\xac\xeb\x66\xa0\x2c\xb8\x9a\x80\xfe\x97\x54\x08\xbf\x59\xcf\xcc\x0e\xca\x7b\x6a\xa9\x34\xc1\xd2\x74\x60\x5c\x4d\x1d\xf4\x96\x6c\xe8\xc5\xef\x6b\x82\xa5\xea\xac\xf3\x87\xad\x27\x5b\xd3\x11\x74\x24\x17\x72\xde\x10\xcc\xa9\x92\xbd\x25\x50\xee\xec\xf9\xc8\xcc\x3f\x29\xd3\xdb\xcf\x06\xe4\xa1\x22\x52\x2f\x40\x1b\xe7\xff\x68\x54\x45\x7b\xfd\x0f\x44\x70\xd7\x5b\x0b\x57\xe6\x9f\x33\x0b\x95\x69\x5b\xd2\x0e\x94\x86\xda\xb9\xb5\x2d\x26\x93\x55\x67\xfa\xb5\x0d\x57\xc6\xac\x1a\xf2\xa9\x4c\x96\xa6\xeb\xdb\xc9\x77\xdf\x3a\xb3\x56\xd5\x64\x65\x1a\xa9\x57\xe7\xba\x77\x76\x92\xff\x6c\x23\xf5\x17\xb7\xf9\x4f\x17\xfb\x35\x96\x3d\x63\x31\xf9\x75\xdc\x42\x25\x3b\x02\x39\x37\xbd\x83\x12\x95\x05\xe5\xf6\xeb\x06\xbb\xa6\x4a\x2d\x55\xf5\xec\xb2\x44\xb8\x05\x47\x7a\x01\xce\xc0\xdf\x9d\x72\x04\xf6\x10\x5e\x88\x01\xde\x91\xac\x9c\x32\xfa\xa9\xe2\x37\xad\xf9\x53\xf9\x1a\xe1\x27\x3c\x54\xf7\xe9\x64\xdf\x2d\xc6\x45\x96\xc6\xe2\x54\xb9\x9e\xa9\x3c\xcb\xa3\x68\x04\xe2\x49\x9a\xf8\x8b\xf2\x22\xc3\xd3\x3c\x4a\xa6\x27\xa0\x07\x8f\x7d\xf6\x7b\x1e\x0d\x18\x4e\xf2\x7c\x3a\x1d\x71\x92\xb3\x28\x12\xd1\xa9\xb7\xfc\x37\x53\x9e\x30\xc6\x46\x20\x9e\x24\xd3\x51\x28\xe7\x22\x17\xf9\x1b\xb6\x73\x34\x78\x2d\xf5\x23\x6d\x5e\x3b\xfc\x91\xc8\xda\x28\xed\xfe\x68\x68\xe9\x86\x62\x7f\xf1\x93\x72\xa4\x64\x5b\xd5\x0c\xda\x79\x95\x4a\x2b\xed\xe3\x80\x46\x2a\xb2\x93\xc5\x3a\x52\xf8\x71\xa8\x0f\x5c\x88\x2c\xe5\x63\x29\xf2\x3c\x7a\x19\xc9\x58\x2e\xb2\xb1\x82\x47\x29\x4b\xb3\x91\x9c\x45\x22\xd2\xb7\xdd\x82\x83\xe9\x98\x4f\xa7\xe9\x88\x52\x9a\xa6\x39\x8b\xb2\xaf\x4c\xa0\xb7\x75\x67\x4c\x3b\xb0\xc5\x4c\x08\x1e\x9f\x5a\xd1\x91\x4c\x23\xfb\x55\xad\xf4\x6a\x40\x26\x8e\x32\xdf\x88\x91\xc1\x5e\xd5\xbd\xaa\x23\x39\xe4\xf8\xe5\xf5\x3c\xec\x1e\x76\xdf\xfc\x1b\x00\x00\xff\xff\x41\xdf\x85\x5f\x16\x08\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/3/1": &vfsgen۰CompressedFileInfo{
			name:             "1",
			modTime:          mustUnmarshalTextTime("2016-09-28T16:32:41Z"),
			uncompressedSize: 1241,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x74\x54\xdf\x6f\xdb\x36\x10\x7e\xdf\x5f\xf1\x81\x2f\xdb\x30\x55\xb0\x93\xa6\x89\xf5\x96\xb5\xeb\x90\xd7\xb5\xc3\x80\xd5\x01\x4c\x51\x27\x8b\x35\xc5\x53\xef\x28\x1b\x42\x90\xff\x7d\xa0\xe4\x06\xde\x90\x3d\x8a\xba\xfb\xee\xfb\x71\xe4\x93\xb9\x1f\x53\xc7\x62\xaa\x27\xf3\xf0\xc1\x54\x6f\x6f\x6f\x37\x9b\xbb\xc2\x7c\xe0\xde\xfa\x68\x2a\xb3\xf7\xa9\x1b\xeb\xd2\x71\x6f\x9e\x0b\xf3\x5e\xc8\x26\x6a\xee\x93\xa9\xcc\xd5\x6a\xfd\xee\xcd\x6a\xf3\xe6\xea\xee\xf3\x6a\x53\xad\x6e\xaa\x9b\xeb\xf2\xdd\xf5\xe6\x66\x73\xf3\x76\xb5\xf9\xdb\x14\xe6\x57\x6e\x26\x53\x99\x07\x28\x11\x22\x43\xc8\x2a\x47\xf4\xf6\xe0\xe3\x1e\x5c\x1f\x3d\x8f\x8a\xd4\x11\x1a\xdf\xb6\x24\x14\x1d\xa1\xa6\x74\x22\x8a\xd8\x69\x12\x1f\xf7\x3b\xd8\xd8\x60\xf7\xe5\xb1\x9e\x12\xed\x0a\xf4\x2c\xc4\x47\x92\x22\xf7\x4d\xb0\x42\xf8\x36\xfa\x44\xf0\x31\x91\xb8\xce\xc6\x3d\xd9\x3a\x50\xb9\x8d\xdb\xf8\x51\xb8\xc7\xef\x0c\x1d\xc8\x55\xf9\x60\x3b\xae\x56\xd7\x84\x7b\x68\xf0\x8e\xe0\x15\x16\x0d\xa9\x13\x3f\x24\x16\xb4\x2c\xb0\x70\x1c\x93\xdf\x8f\x99\x9b\xd2\xbe\xa7\x98\xc0\x2d\x6c\xc4\x18\x1b\x92\x30\x65\xf2\x56\xc4\x4e\x33\xb5\x41\xf8\xe8\x1b\x52\x58\xe7\x48\x15\x89\x61\x11\xc7\xbe\x26\xa1\x06\x4a\xdf\xc6\x59\x16\xb7\xa0\x40\x19\x4c\xd1\x66\x5a\xa9\xb3\x69\x81\x29\xbf\xf3\xba\xe4\x37\x8b\xc7\xd1\x86\xf1\x4c\xf3\xa7\x81\x55\x7d\x1d\x26\x50\x3f\xa4\xe9\xe7\x7f\x41\x67\x73\x74\x96\xfc\x9e\xa3\xfa\x86\x04\x42\xad\x75\x89\x67\x18\x6e\x91\x3a\xaf\x18\x3c\x2d\xf5\x8e\x1b\x2a\xf1\xd1\x8b\x26\x38\xab\x54\x61\xe2\x11\x91\xa8\xc9\xfc\x35\xf8\x7d\x97\xc2\x04\xdb\x7c\x1d\x35\xcd\x09\xc9\x18\xa8\x40\x6f\xe5\x70\xe6\xa6\xb0\xba\x50\x81\x6f\x97\x30\x3a\x7b\x24\x84\xd9\x84\xce\x46\x5c\xc1\x75\x56\x4a\xfc\xe5\x53\x87\xad\xf1\xd1\xb1\x08\xb9\xb4\x35\xf3\xcc\x3c\xf2\xc7\x10\xa0\xbe\x1f\xc2\x84\x25\xba\x8b\x59\x3e\xce\x1f\x5b\xf3\x7a\x9b\xd0\x49\x72\xee\xb9\xe6\xd4\x71\x20\x28\xc5\x94\x0d\x29\xf1\xe9\xe4\x93\xeb\xb2\xf2\xda\xba\x43\xf6\x6f\xb0\x19\x8e\x79\xf6\xe8\x13\x39\x8e\xcd\x59\xf8\x79\xee\xcb\xba\x25\x7e\xd9\x36\x9c\x3a\x1f\x08\x0d\x67\xa4\x81\xa4\x65\xe9\x6d\x76\xdc\xf7\x39\xf5\x39\xcd\x4b\x9f\x4b\x3c\x7c\xe7\x7c\x29\x36\xb7\x2d\x11\x9c\x17\xf6\x3f\xab\xfa\xaa\xd4\xb9\xe9\xa5\x23\x72\x2a\xe6\x6d\xcb\x31\xe5\x83\x96\xc5\x2d\x61\x09\x35\x7c\x61\x82\xeb\xc8\x1d\xca\x59\xe6\xe7\x8e\x94\xe6\x6a\xed\x6d\x08\xf9\x9e\xc8\x41\x0b\xd4\xe3\x12\xe9\x79\xc7\x02\xc5\x7d\xea\x96\xc6\xfc\xdd\xdb\x09\xec\xdc\x28\x99\x56\x6f\xe3\x84\x21\x58\x47\x5a\xe2\x4f\xcd\xff\x5f\x65\xea\x15\xc1\x1f\x72\x1a\xc2\xa7\x5c\xb5\x8c\x14\x76\x07\x05\x2f\xf2\x84\x6d\x93\x31\x5b\xe1\xf3\x95\x82\x9b\x5c\xf0\x9a\x4a\x53\x98\x3f\xc8\xba\xe4\x39\xaa\xa9\xbe\x3c\x99\xdf\x7a\xfe\xea\xf3\x7b\x64\x7e\x59\x9b\xe2\xfc\x46\x2d\xbf\xf2\xe9\xed\x6a\xbd\xbe\x5b\x6f\xfe\xe7\x99\x7a\x7c\x7e\x7c\xfe\xe1\x9f\x00\x00\x00\xff\xff\x4a\x49\xe2\x91\xd9\x04\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/3/2": &vfsgen۰CompressedFileInfo{
			name:             "2",
			modTime:          mustUnmarshalTextTime("2016-09-28T09:47:35Z"),
			uncompressedSize: 497,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x8c\x8f\x31\x6f\xdb\x30\x10\x85\xf7\xfe\x8a\x07\x2e\x59\x1c\xc1\xb6\x1c\x4b\xe2\x54\xa7\x29\x5a\x6f\x1d\x3a\x05\x59\x28\xf3\x2c\x12\xa6\x79\x2e\x79\x6c\x2b\x04\xfe\xef\x05\x85\x8e\x1d\x3a\xde\xe1\xde\xf7\xbe\x7b\x57\x87\x22\x8e\x93\xd2\xef\xea\xf8\xa2\xf4\x66\xd8\xee\x36\xed\x6e\xa5\x5e\xf8\x6a\x7c\x54\x5a\x4d\x5e\x5c\x19\x9b\x13\x5f\xd5\x7d\xa5\x3e\x25\x32\x42\xf6\x20\x4a\xab\xed\x7a\xb3\x7f\x5c\x0f\x8f\xdb\xfe\xfb\x7a\xd0\xeb\x41\xef\x86\xa6\xed\xbb\xae\x7d\x1a\xda\xee\x55\xad\xd4\x67\xeb\x85\x6c\x45\x3f\xcf\xff\x5b\xf0\x0f\xf2\xae\xd3\xed\x53\x33\xf4\xfd\x7e\xdf\x6d\xfa\xfe\xb5\x9e\x3d\xb3\x9d\x95\x56\x5f\x69\xc6\xc7\xdf\xc1\x8c\x2b\x88\x33\xf1\x92\x71\xe6\x84\x5b\xe2\x9f\xde\xfa\x38\x21\xf3\x95\x90\x8c\x78\x8e\x26\x10\x7e\xb9\x19\x33\x17\x88\xf3\xf1\x02\x71\x04\xbe\xdd\x38\x7b\x21\xf8\x0c\x83\x91\x44\x28\x21\xcb\x1c\xa8\xc1\x21\x88\xe3\x32\x39\x1c\x71\xe6\x12\xed\x12\x48\x64\x4e\x15\x97\xf1\xa3\xd4\xdc\xb9\x44\x08\x73\x03\xfd\xed\x2d\xbe\xc5\xe3\x43\x08\x7f\xf1\x4b\xb7\x19\xb9\x48\x5d\x64\x98\x68\x31\x91\x60\x34\xa7\x0b\x84\xab\x48\xb3\x44\xe4\x21\xc3\x84\xcc\x98\xb8\x3a\x0b\x63\x24\x38\x0a\xb7\x73\x09\x75\x0a\xcc\x17\x98\xb4\x28\x5c\x39\x11\xbe\x30\xb2\x98\x68\x4d\xb2\x08\x7e\x4c\x26\xcd\x38\xb1\xa5\xa5\x22\x53\xfd\xd3\x54\xe8\x48\x95\x67\x39\x52\x55\x4f\xd4\xa8\xfb\x87\x3f\x01\x00\x00\xff\xff\xcc\xce\xad\xd6\xf1\x01\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/3/events": &vfsgen۰DirInfo{
			name:    "events",
			modTime: mustUnmarshalTextTime("2016-09-24T22:03:43Z"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/4": &vfsgen۰DirInfo{
			name:    "4",
			modTime: mustUnmarshalTextTime("2016-11-04T07:33:28Z"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/4/0": &vfsgen۰CompressedFileInfo{
			name:             "0",
			modTime:          mustUnmarshalTextTime("2016-10-19T16:08:43Z"),
			uncompressedSize: 1348,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xa4\x92\x5f\x4b\xe4\x3c\x14\x87\xef\xdf\x4f\x71\x38\x37\x2a\x6f\x2d\x6d\xda\x64\xd2\xdc\xa9\x23\x22\x2c\x7b\xe1\x7a\xe5\x8e\xd0\x4c\x7b\x66\x9b\xa5\x4d\x24\x4d\x05\x19\xe6\xbb\x2f\x75\x46\x96\x95\x69\x75\xd9\xcb\x36\x4f\x7e\xe7\xcf\x93\x2d\x7e\x0b\x3a\x10\x2a\x74\x4f\x64\x31\xc2\x7b\x13\xda\xf1\xf3\xe2\xd9\x99\x1a\x06\x3b\xf4\x54\x43\x47\xa1\x71\x35\x78\xaa\xc8\x3c\x93\x07\xab\x3b\xea\x31\xc2\x2f\x7a\x4d\x6d\x8f\xea\xfb\x16\xbf\xea\xee\xf5\x5a\x55\xd1\x53\xa0\x1a\x23\xbc\x72\xad\xf3\xa8\xb6\x78\x87\x8a\xb1\x3c\xc2\x1b\x54\x2c\xe3\x11\x5e\xa2\x62\x39\xdf\xed\x1e\x23\xbc\x18\x42\xb3\x87\x6e\x97\xa8\xd2\x82\xe5\x69\x96\x47\xb8\x74\x9d\x36\x16\x15\xfe\x30\xa1\x19\xd6\x71\xe5\x3a\xdc\x45\x78\xe5\x49\x07\xaa\x2f\x02\x2a\x64\x49\x2a\xce\x93\xe2\x9c\xe5\xf7\x8c\xa9\x84\xab\x4c\xc6\xb9\xc8\x44\x9e\xf2\x4c\x3c\x60\x84\xd7\xb5\x19\xfb\x50\x5b\xbc\x7c\xf9\x6c\x81\x3f\x93\xc5\x7d\xc2\x15\x4b\x14\xe3\x71\x51\x48\x91\xb1\x44\xc8\x87\x11\xbb\x74\xf5\x0b\x2a\x5c\x3a\x08\x8d\xe9\xd5\xca\xae\x6c\x59\x96\x37\x6e\x65\x37\x83\xad\xe0\x74\xe3\xdc\xd9\x61\x67\xa7\x67\xb0\x5d\xd9\x55\x88\xe3\x78\x65\x77\xaf\xdc\x88\x2f\x9d\x3d\x09\x50\x4f\x06\xc0\xc7\x11\xb7\x1b\x28\x37\x25\x98\xfe\x20\x29\x86\xdb\x70\xd2\x43\xe7\x3c\x81\x27\x5d\xeb\x75\x4b\xb0\xa6\x4a\x0f\x3d\x81\x19\x8f\xaa\x96\xb4\x87\xd0\xe8\x00\x1b\x43\x6d\xdd\x83\xf3\x87\x1a\x3d\xb8\x31\xce\xb9\x12\xb4\x27\xb0\x2e\xc0\xab\x78\x63\xa1\xdc\x13\x65\x8c\x11\xde\x91\xae\x82\x71\x76\xaf\xfc\xba\x73\x3f\xcd\xb8\x56\xac\x5a\xfd\x84\x6f\x36\xf7\x87\xe3\xff\x05\x67\x45\x5a\x4c\x6d\x7b\xcf\x30\xc9\xf3\x74\xd2\xc8\x41\x1b\x63\x8b\x74\x1e\x11\x42\x2e\x58\xf6\x41\xa9\x9c\xe7\xe3\xfb\x9b\x2d\x95\xb1\xa2\xe0\x53\xd0\xe3\x88\xfd\x1e\xfb\xff\xf4\xc8\xd0\x22\x59\x48\x21\xff\xbd\x13\x96\xf2\x84\x8b\xc5\x3c\x94\xa5\x62\x7c\xd1\xf3\x10\x67\x92\xb3\x79\x44\xe6\x92\x4f\x36\xf4\x6e\xea\x6e\xe8\x1b\xef\x5c\x77\x6c\x76\x29\x59\x36\x65\xea\x5d\x4c\x43\xda\x87\x63\x19\x9f\x30\xf9\x57\x96\xfa\xca\x93\x3e\xd6\xed\x7c\xca\xdb\xf2\x38\x5f\x24\xa9\x98\x2c\xf5\xb8\xfb\xef\x57\x00\x00\x00\xff\xff\x82\xfe\x8f\x44\x44\x05\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/4/1": &vfsgen۰CompressedFileInfo{
			name:             "1",
			modTime:          mustUnmarshalTextTime("2016-09-28T17:38:32Z"),
			uncompressedSize: 301,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x24\xcc\xc1\x6e\x82\x40\x10\x06\xe0\x7b\x9f\xe2\xcf\x5c\xd0\x04\x89\x60\x63\xe9\xde\x6c\xbd\x70\xf7\xd4\x90\xd4\x2d\x3b\xc2\xa6\x30\x6b\x96\x01\xb5\xc6\x77\x6f\xd2\xde\xbf\x7c\x77\xda\x4d\xda\x85\x48\xe6\x4e\xd5\x9e\x4c\x9e\xe7\x45\x4a\xfb\x30\x58\x2f\x64\xa8\xf5\xda\x4d\x5f\x59\x13\x06\x7a\xa4\xf4\x1e\xd9\x2a\xbb\x9d\x92\xa1\x62\x9d\x6f\x57\xeb\xd7\x55\x51\x1e\xf2\x17\xb3\x29\xcd\xa6\xc8\x36\x65\x5e\x94\xeb\xed\x73\xfe\x41\x29\xbd\x05\x77\x23\x43\x87\xce\x6a\x32\xc2\x8b\x72\xe4\x51\xbd\xb4\x29\x2a\x38\xef\x24\x51\xf0\xcc\x82\xc8\xb6\xf7\x3f\x0c\xed\xac\xe2\x62\x47\xcc\xb6\xf7\x0e\xe3\x4d\xd4\x5e\x61\x96\x19\xaa\x64\x66\xd8\xfe\x62\x6f\x23\xce\x91\x4f\x1c\xd9\x61\x12\xc7\x71\x6c\x42\x64\x68\xc0\x60\xbf\x19\x5e\xc1\xd7\x73\xef\x1b\xaf\xff\x5b\x95\x0c\x90\xa0\x98\x46\x2f\x2d\xb4\x63\x44\x6e\xd8\xcf\x1c\x4d\x2d\xb5\x1c\x8f\xc7\x36\xd4\x72\x9a\xa4\xc1\xe2\x13\xa7\x10\x96\x18\x58\xbb\xe0\x16\x4b\xdc\x6b\xa9\x35\xcb\xb2\x5a\x1e\x7f\x92\x1e\x4f\xbf\x01\x00\x00\xff\xff\x44\x2a\xb5\x8e\x2d\x01\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/4/2": &vfsgen۰CompressedFileInfo{
			name:             "2",
			modTime:          mustUnmarshalTextTime("2016-09-28T17:41:25Z"),
			uncompressedSize: 476,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x2c\x8f\x31\x6f\xdb\x40\x0c\x85\xf7\xfe\x8a\x87\x5b\xd2\x04\x8e\x60\xb9\x76\x1b\x6b\x6a\xda\x0c\xd5\xde\xa9\x30\x10\xb3\x3a\xca\x22\x7a\x3a\x0a\x77\x3c\x3b\x42\x90\xff\x5e\x28\xce\x48\x3c\xf2\xe3\xf7\x5e\xdd\x63\xb1\x41\x93\x6b\x5e\x5d\xfb\xe4\x9a\x7a\xbf\xd9\xd6\x5f\xb6\x2b\xf7\xa4\x23\x49\x74\x8d\x3b\x89\x0d\xe5\x6f\xd5\xe9\xe8\xde\x56\xee\x67\x62\x32\xf6\x8f\xe6\x1a\xb7\x59\xd7\x5f\xef\xd7\xfb\xfb\xcd\xc3\xef\xfa\x5b\xb3\xad\x9b\xcd\xae\x7a\xa8\x77\xeb\xfd\x6e\x5d\xff\x71\x2b\xf7\x43\xfd\xec\x1a\xf7\xfd\x22\x21\x44\x4d\x49\x32\x5a\x50\x67\x85\x42\x98\x71\x57\x32\x7b\x98\xde\x81\x42\x56\x4c\x89\x7b\x4e\xb0\x81\x71\xfc\xfc\x8c\x5e\xf5\xf6\x88\x3c\x47\xa3\x97\x15\x7a\xbd\x26\x99\x46\x46\x62\xca\x1a\x31\x6b\x41\x26\xf1\x15\x5a\xbb\xc9\x20\x8c\x9a\x18\xfc\x32\x05\xe9\xc4\x70\xa1\x19\xda\x23\xd3\x2c\xf1\x04\x1b\xc8\x70\x70\xed\xcd\x88\x20\xc6\xe9\xdd\x20\xaa\xa1\xe4\x6b\xbc\x60\x3b\x96\x33\x27\x90\x81\x42\xa8\x0e\xee\x10\x0f\xf1\x97\x5e\xf8\xcc\x69\x85\x16\x81\x8c\x13\x7a\x2d\xd1\x83\xcf\xe2\x39\x76\x7c\x05\xcb\x22\xf0\xfe\x5e\xbc\xe8\x48\x26\x1d\x4c\x91\xff\xc9\x74\x2d\xf4\x7c\x04\x05\xd3\x13\xdb\xb0\xb0\xb2\xa2\x45\x96\x71\x0a\xd2\x0b\x7b\x8c\x33\xb2\xcd\x81\x97\xa3\x5e\x43\xd0\x0b\x72\x11\xab\x96\xad\x41\x4b\xf0\xf0\x72\x82\x18\xca\x04\x8a\x1e\xe4\xfd\x32\x99\x7e\x88\xf7\x9c\x16\x99\x8c\xcc\x9d\x89\xc6\x0a\xcd\xad\x7b\xfb\xf4\x3f\x00\x00\xff\xff\xda\x11\x97\x69\xdc\x01\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/4/3": &vfsgen۰CompressedFileInfo{
			name:             "3",
			modTime:          mustUnmarshalTextTime("2016-10-07T23:16:11Z"),
			uncompressedSize: 207,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x24\xca\xbd\x4e\xc3\x30\x10\x07\xf0\x9d\xa7\xf8\xeb\x16\x40\x4a\x23\x3b\x05\x83\xbc\x05\xba\x64\x67\x62\x73\x9b\xa3\xb6\xe4\x8f\xc8\x39\x43\xab\x2a\xef\xce\xd0\xfd\x77\xa3\xb1\x89\x2f\x95\xec\x8d\xa6\x03\xd9\xfd\xfb\x60\x8c\xea\xe8\x50\x92\x0b\x99\x2c\x9d\x83\xf8\x76\xec\x4f\x25\xd1\xd6\xd1\x67\x65\x27\x3c\x8f\x42\x96\x06\xa5\xcd\x4e\xab\x9d\x7a\xfb\x1a\xf6\x56\x1b\xab\x75\xff\xa2\x8c\xd2\xaf\xdf\xd4\xd1\x47\x99\xaf\x64\x69\xca\x48\x57\xc4\x90\x82\xf0\x0c\xbe\x2c\x65\x6d\x95\x3b\x4c\xf0\xee\x97\xf3\xa3\x60\x65\xce\x10\x1f\x56\xb4\xd5\x9d\xb9\xc7\x98\xc1\x17\x97\x96\xc8\x78\x2a\x15\x4b\x09\x59\xb8\x42\x0a\xdc\x49\x9a\x8b\x77\xf7\x8c\xbf\xd2\xe2\x8c\x23\xc3\x73\x5c\x7e\x5a\xec\x69\x7b\xf8\x0f\x00\x00\xff\xff\x6d\x7d\x64\x40\xcf\x00\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/4/4": &vfsgen۰CompressedFileInfo{
			name:             "4",
			modTime:          mustUnmarshalTextTime("2016-10-08T19:49:48Z"),
			uncompressedSize: 579,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x6c\x90\x31\x6f\xdb\x30\x10\x85\xf7\xfe\x8a\x07\x2e\x5e\x1c\xc1\x72\xd4\xc2\xd6\xd4\xb4\x59\x3c\xd7\x53\xe1\xc1\x94\x78\x12\x89\x4a\x3c\x83\x77\x8c\x6b\x04\xf9\xef\x05\xad\x26\x53\x36\x02\xfc\xee\xbd\x0f\xef\xd5\x3c\x65\xf5\x9c\x4c\xfb\x6a\x0e\xcf\xa6\xad\xf7\xdb\xa6\x7e\x6c\xd6\xe6\x99\x67\x1b\xa2\x69\xcd\x18\xd4\xe7\xae\xea\x79\x36\x6f\x6b\xf3\x33\x91\x55\x72\x4f\x6a\x5a\xb3\xdd\xd4\xdf\x1e\xea\xcd\xc3\x66\x77\xac\xf7\x6d\xb3\x6f\x9b\x5d\xb5\xdd\x36\xbb\x7a\xf7\xb5\xd9\xfe\x36\x6b\xf3\x83\xdd\xcd\xb4\xe6\xbb\x92\xbb\x71\x8e\x23\x8e\x3e\x08\x82\x80\x23\x81\x07\xa8\x27\x0c\x74\x85\xe4\x71\x24\xd1\xc0\x51\xa0\xde\x2a\x0e\xe8\xed\x4c\xc8\x17\x5c\x83\x7a\x70\xc4\x7c\x03\x5f\xe3\x1a\xc9\xaa\xa7\x54\xa8\x88\x21\xf1\x0c\xb9\xb0\x6a\x88\x23\x6c\x04\xfd\x0d\x72\x7f\x5f\xac\x2a\xa5\x58\xe1\xe8\x09\x33\x6b\x78\xb1\x25\x1d\x03\x27\x38\x2e\x84\xfe\x37\xb1\x02\x47\xd2\xa7\xd0\x91\x6b\x4f\xf1\x14\x4f\x79\xb3\x79\x24\x1c\x74\x25\x98\x39\x11\x12\x59\x67\xbb\x89\xd0\x51\x6f\xb3\x10\x42\xf9\xea\x27\xb2\x69\x91\x1d\x02\x4d\x4e\xc0\x09\x33\xa9\xe7\xf2\x1c\x70\x1e\x98\xcf\xb0\x89\x10\x59\x91\x85\x1c\x42\xc4\x79\x21\xce\x55\x69\xfa\xc5\xf7\x01\x12\x59\xf9\x54\x4d\x19\x9e\xa6\x0b\x42\xec\x0b\x43\xe8\xd9\xbd\xeb\x84\x29\xe8\x6d\xbd\xa8\x94\x82\x72\xdd\x73\x94\x20\x4a\xb1\xbf\x2d\xb3\x7d\xcc\x51\x0e\x2b\x1c\x56\x33\x24\x27\xfa\x28\x78\xb7\x12\x9e\x97\xf0\xce\x0a\x09\xba\xac\xf7\x4c\x2e\x4b\x4b\x85\x03\x1c\xc7\x95\xc2\xdb\x17\xc2\x14\xe2\x1f\x41\x0a\xa3\x2f\xd0\xb5\x32\x6f\x5f\xfe\x05\x00\x00\xff\xff\xfe\x6c\xc2\x4a\x43\x02\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/4/5": &vfsgen۰CompressedFileInfo{
			name:             "5",
			modTime:          mustUnmarshalTextTime("2016-11-03T16:28:36Z"),
			uncompressedSize: 269,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x8c\xcc\xb1\x6a\xc3\x30\x10\x80\xe1\xbd\x4f\x71\xdc\xec\x18\xdd\xb9\x58\x89\x96\x92\x34\x1d\xba\x17\x0a\xd9\x54\xeb\x88\x04\x8e\x2f\xd8\xe7\x16\x13\xfc\xee\xc5\x7b\x87\xae\x3f\x3f\xdf\x03\x8f\xb3\x65\x1d\x31\x3c\xf0\xfd\x8c\xe1\xe0\x7c\xe3\x5d\x85\x67\xbd\xc5\x32\x60\xc0\x6b\xb1\x3c\x7f\xd5\x9d\xde\x70\xad\xf0\x75\x94\x68\x92\x8e\x86\x01\xd9\x51\xbb\x23\xda\xb9\xe6\x83\xda\xc0\xfb\xc0\xbe\x66\x7e\x6e\x99\x98\xfc\x05\x2b\x7c\x4b\xc5\x24\x6d\xf2\x69\xf9\xa7\xff\x37\xdc\xb4\x35\x3b\xe2\xbd\x23\x7f\xb8\x6c\xdb\x49\xd3\x82\x01\x3f\xb3\x0c\xf0\xa3\x73\x9f\x60\xd1\x19\x92\x82\xe5\x32\x41\x9c\x40\xef\x77\x9d\x24\x81\x29\x0c\x6a\x10\xcd\x62\x97\xcb\x70\x85\x62\x5b\xb3\x2c\x30\x4a\x27\xe5\x5b\x46\x88\x06\xb1\xef\x5f\x70\x7d\xfa\x0d\x00\x00\xff\xff\xd6\x27\x8a\x13\x0d\x01\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/4/6": &vfsgen۰CompressedFileInfo{
			name:             "6",
			modTime:          mustUnmarshalTextTime("2016-11-04T07:33:26Z"),
			uncompressedSize: 707,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x8c\x90\x31\x6f\xdb\x4c\x0c\x86\xf7\xef\x57\x10\xb7\xe4\x2b\xa0\x08\xb1\x6c\x39\x8d\xa6\xc6\x49\x87\x6c\x1d\x3a\x05\x59\x68\x1d\xa5\x23\x22\x91\xc6\x1d\xcf\x86\x11\xe4\xbf\x17\x27\x07\x05\x52\x74\xe8\x76\xc0\xbd\x7c\x1e\xf2\x7d\x73\xf7\xd9\x82\x46\xd7\xbd\xb9\xa7\x47\xd7\xad\xee\x9a\xcd\x6a\xbd\xa9\xdc\xa3\xce\xc8\xe2\x3a\x37\xb2\x85\xbc\xaf\x7b\x9d\xdd\x7b\xe5\x1e\x22\xa1\x91\xbf\x37\xd7\xb9\xe6\x66\xb5\xbd\x5e\xad\xae\x6f\x36\x3f\x6f\x6e\xbb\x66\xdb\xb5\x4d\xdd\x6c\xef\xda\x6d\x73\xf7\xf5\xf6\xd9\x55\xee\xbb\x67\x23\x5f\xd0\xbb\xf3\xbf\x0a\xfe\x42\x5e\xaf\xbb\x66\x5b\x6f\xd6\xeb\x4d\xdb\xb6\x4d\xfb\x5c\x62\x3b\xf5\x67\xd7\xb9\x6f\x16\x74\x4e\x21\x9b\xc1\x4e\x2d\x00\x46\x82\x23\x4e\xec\x2b\x60\x03\x4f\x07\x12\x9f\x40\x05\x2c\x10\x24\xb6\x8c\xc6\x2a\xf5\x8b\xbc\xc8\x43\x40\x19\x59\x46\x40\x98\xc9\x82\x7a\x30\x05\x84\x21\x4b\x5f\x32\xc0\x09\x10\xf6\x3c\x8e\x14\xa1\x2f\x59\x02\x0b\x68\xd0\x6b\x9e\x3c\xec\x23\xe1\x2b\x24\x9d\x09\xd4\x42\x89\xa8\xa7\x0a\x4e\x81\x22\x61\x02\x51\x03\x96\x7e\xca\xbe\x18\x8a\x3c\x52\x4f\x7c\xa4\x08\xff\x9f\x02\x09\xb0\x5d\x25\xc8\x92\x13\xf9\x2f\x17\x55\x9a\x71\x9a\xfe\x70\x9d\x16\x97\x50\x99\xc3\x61\xa0\xde\x16\xd6\x9e\x02\x1e\x59\xe3\x72\xc7\xd3\xf0\x99\xcf\x09\x7a\x9d\x0f\x13\x19\x4d\xe7\x0f\x45\xb5\xe0\xae\x12\x78\x1a\x58\x78\xf9\x41\x48\x3c\xca\xc5\x33\xe3\x79\x4f\x97\x9d\x10\x46\x55\x0f\xec\x09\x4b\x21\x96\x63\x59\x16\x58\x3e\xb7\x13\x71\xb9\xda\x02\xca\x47\x7d\x35\xec\xb2\x2d\x8d\x18\xcf\x94\xe0\xac\x19\x66\x1e\x83\xc1\x09\xc5\x0a\xeb\x95\xe8\x50\x58\xbf\x0b\x1f\x34\xc2\x11\x23\x6b\x4e\x50\x6a\x53\x49\x35\xfc\xa0\x18\xf0\x90\xca\x40\xaf\x62\x2c\x99\xca\x9b\xcb\x49\x33\x89\x01\x4a\xd9\x86\xe2\x80\x3d\xd5\xee\xfd\xbf\x5f\x01\x00\x00\xff\xff\x01\xf8\xa9\x15\xc3\x02\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/4/events": &vfsgen۰DirInfo{
			name:    "events",
			modTime: mustUnmarshalTextTime("2016-09-24T22:05:38Z"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/5": &vfsgen۰DirInfo{
			name:    "5",
			modTime: mustUnmarshalTextTime("2016-10-04T03:45:53Z"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/5/0": &vfsgen۰CompressedFileInfo{
			name:             "0",
			modTime:          mustUnmarshalTextTime("2016-10-03T21:34:57Z"),
			uncompressedSize: 1509,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xa4\x94\x41\x4f\xdb\x4c\x10\x86\xef\xdf\xaf\x58\xcd\x85\xc3\x67\x62\x7b\x63\x3b\xc9\xde\x08\x41\xa8\x12\xe2\x40\xe9\x85\x3a\x12\x9b\xf5\x10\x2f\x5d\xef\x58\xde\x8d\xc0\x8a\xf2\xdf\xab\x25\xb4\xb4\x88\xa4\xae\x7a\xb1\x64\xcf\xb3\x33\xf3\x48\x7e\x77\x0b\x9f\xbd\xf4\x08\x02\xa8\x45\x0b\x11\xdc\x6a\x6f\xc2\xeb\x17\x87\xcc\x69\xbb\xde\x18\xd9\xb1\x07\xea\x9a\xf0\x60\x8a\x8c\x41\xe5\x35\x59\xd6\x61\x4b\xf1\x03\x99\x0a\x3b\x66\x65\x83\x10\xc1\x95\x5c\xa1\x71\x20\xbe\x6e\xe1\x3a\x7c\x11\x70\xa6\x14\xb6\x1e\x2b\x88\xe0\x9c\x0c\x75\x20\xb6\x70\x03\x82\xf3\x2c\x82\x4b\x10\x7c\x9c\x47\x30\x07\xc1\xb3\x7c\xb7\x5b\x46\x70\xb6\xf1\xf5\x1e\xfa\xb4\x00\x91\xce\x78\x96\x8e\xb3\x08\x16\xd4\x48\x6d\x41\xc0\x5a\xfb\x7a\xb3\x1a\x29\x6a\x60\x17\xc1\x79\x87\xd2\x63\x75\xe6\x41\x00\x4f\xd2\xe2\x34\x99\x9d\xf2\xec\x96\x73\x91\x14\x22\x2b\x46\x29\x2f\x78\x9e\xa4\x49\x7e\x07\x11\x5c\x54\x3a\xec\x21\xb6\x30\xef\x87\x0e\xf8\xbd\xf3\xf4\x36\x99\x89\x2c\x13\xd9\x74\x34\xe6\xc9\xac\xc8\x92\x64\x7a\x17\xb0\x39\x55\x3d\x08\x58\x10\xf3\xb5\x76\xa2\xb4\xa5\xbd\xbf\xbf\x2f\xed\x9a\x8c\xb4\xeb\x11\x75\xeb\xf8\x39\xc6\x67\xd9\xb4\x06\xe3\x1a\x8d\xa1\x03\x35\xda\xf8\x1e\xfd\xbb\x62\x43\x2b\x6d\xf0\x27\xb3\x92\x4e\xab\xe3\xc8\x83\x91\x6d\xdb\x97\xf6\x4d\x26\x76\xf5\xa6\x53\x44\x57\xb1\xd7\xca\x4b\xe5\x09\xe3\xd6\xc8\x1e\xbb\x78\x25\xab\x81\x64\x27\x6d\x45\xcd\xab\x5b\x69\x17\x64\x4f\x3c\xab\x86\x48\xbb\x63\xd6\x6e\x88\xb6\x1b\xe0\xed\xfe\x4a\xdc\x0d\x37\x77\xef\xd5\xaf\xc9\x6b\x85\xac\xa6\x27\x56\xc2\xeb\xf4\x12\x22\x56\xc2\xfe\x40\x09\xec\x97\x60\x38\xe6\x74\xd3\x9a\x9e\x29\xb2\x5e\x6a\xcb\x1a\x69\x7b\xd6\xa1\x09\x3f\x2f\x6b\xa5\xfa\x26\xd7\xe8\x22\xd6\xa3\x67\xbe\xc6\x9e\x6d\xde\x47\x6f\x14\x86\xce\x51\xc9\x50\xd1\xfe\xc4\x85\x56\x4e\x3b\x8f\xd6\xb3\x27\xed\xeb\x70\x8e\x39\xdf\x1b\x64\xbe\x96\x9e\x5d\x12\x6b\x3b\x7a\x44\xe5\x43\x33\x37\x82\x08\x6e\x50\xbe\xe4\x76\x1f\xcf\x8b\x86\x1e\x75\x88\x00\x28\x23\x5b\xf8\x91\xbc\x7d\xf1\x25\x1a\x93\x62\x92\xa6\xd3\x43\xd1\x78\x85\x38\x9f\xa4\xc7\x11\x9e\xe5\x59\x08\xf9\xd1\x36\x63\x3e\x9b\xe5\x87\xa0\x65\xc0\xde\xf6\xfd\x3f\xfd\x68\x5b\x9e\x65\xb3\x24\xf9\xe7\x6d\x8b\x64\x32\x2d\xfe\x20\x3d\xc4\x88\xa7\x79\x92\x17\x93\xe3\xd0\x38\x2d\xc2\xf5\x33\x4c\xbb\xd9\xb8\xba\x23\x6a\x3e\x90\x2f\xa6\x53\x3e\x3e\x24\xb6\xdc\x2d\x77\xff\x7d\x0f\x00\x00\xff\xff\x22\xad\x47\xd2\xe5\x05\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/5/1": &vfsgen۰CompressedFileInfo{
			name:             "1",
			modTime:          mustUnmarshalTextTime("2016-09-28T09:33:19Z"),
			uncompressedSize: 194,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x14\xc8\xb1\x6e\x02\x31\x0c\x00\xd0\xbd\x5f\x61\x79\x3e\x4e\x09\x70\x88\x64\xa3\x65\xe9\xce\xd4\xcd\x97\xb8\x17\xab\x90\x54\x8e\x51\x75\x42\xfc\x7b\xc5\xfa\x1e\x78\xba\x5b\x69\x8a\xf1\x81\x9f\x67\x8c\x7e\x72\x61\xda\x0f\x78\x6e\x37\x92\x8a\x11\x17\xb1\x72\x9f\xc7\xd4\x6e\xf8\x1c\xf0\x43\x99\x8c\xf3\xc9\x30\xe2\xd6\xf9\xc3\xc6\x85\xcd\xf6\x78\x71\x21\xee\x76\xd1\x87\x31\xec\xdd\x71\x0a\xde\x1f\xbe\x70\xc0\xf7\x96\x57\x8c\x78\x29\xac\x0c\xa4\x0c\xbf\x94\x7e\x68\xe1\x0e\x52\xc1\x0a\x43\x37\xaa\x99\x34\xc3\x55\x66\x25\x5d\x5f\x9e\x5a\xfd\xbe\x4a\x32\xf8\x13\x2b\x60\x45\x7a\x84\x79\x35\xee\x03\xb0\x6a\xd3\x0e\x54\x33\x74\x53\xa9\x4b\x1f\xf1\xf9\xf6\x1f\x00\x00\xff\xff\xda\xaa\x53\xef\xc2\x00\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/5/2": &vfsgen۰CompressedFileInfo{
			name:             "2",
			modTime:          mustUnmarshalTextTime("2016-09-29T13:54:48Z"),
			uncompressedSize: 776,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x8c\x52\x41\x4f\xe3\x3c\x10\xbd\x7f\xbf\x62\xe4\x0b\x87\x2f\xa4\x49\x28\x85\xe4\xb4\x74\xe1\xd0\x0b\x87\x15\x27\x16\xa4\xb8\xf1\x34\x31\xb5\x3d\x91\x67\xc2\x12\x55\xfd\xef\xab\xb4\x54\xb0\xda\x5d\x69\x6f\xf6\xbc\x37\xcf\xe3\x37\x6f\xa7\x6e\x06\xe9\x28\xaa\x6a\xa7\x56\xb7\xaa\xca\xcb\x62\x9e\x5f\xcc\x13\x75\x4b\x5e\xdb\xa0\x2a\xd5\x5a\xe9\x86\x75\xda\x90\x57\xfb\x44\x7d\x8d\xa8\x05\xcd\x8d\xa8\x4a\x15\x59\xbe\x38\xcf\xca\xf3\xe2\xfa\x21\x2b\xab\x79\x5e\xe5\x8b\x34\x5f\x14\x79\xbe\xb8\xba\xbe\x7a\x54\x89\xba\x33\x56\xd0\x4c\xd2\xcb\xf1\x5f\x1f\xf8\x93\x72\x51\x65\x65\x7a\xb1\xc8\x8a\xf9\x45\x9e\x95\x8f\x13\x6d\x49\x66\x54\x95\xfa\xf2\xea\xb4\xb1\xde\x46\xda\x6c\x60\x05\x86\xc2\x99\x80\x74\x36\x6c\x41\x3a\x62\x04\x1d\x11\x1a\x1a\x82\x60\x3c\xc7\x37\xed\x7b\x87\x9c\xc2\x3d\x5a\xe9\x30\x42\xbd\x1e\x05\xb9\x4e\xa0\xc6\x18\x29\x4e\xa7\x40\x11\x6a\x96\x68\x43\xcb\xf5\x7b\xbb\x73\xd8\x88\xa5\xc0\x29\x3c\x74\x38\x9e\x45\x04\x1b\x8c\x7d\xb5\x66\xd0\x0e\x7a\xdd\x6c\x75\x8b\x9c\x3e\x85\xa7\xb0\x1c\x3f\xf1\x13\x58\x81\x47\x1d\x80\xc9\xe3\x34\x55\x0b\xce\x6e\x31\x4d\x0f\xd4\x4e\xa4\xe7\x6a\x36\x6b\xc9\x50\x93\x52\x6c\x67\x18\x1a\x32\x36\xb4\x13\xba\x12\x68\x28\x88\xb6\x81\xa1\x3e\x01\xb3\x17\xa6\x70\x18\xf7\x54\x78\xf3\xee\x97\x7b\x4b\xeb\x3a\x01\x94\x26\x85\x7b\x12\xdb\x20\x74\xf4\x03\xac\x9c\xfd\xa6\x02\x3a\x18\x08\x24\x1f\x75\x3e\x02\x29\xac\x26\xfa\x1a\x1b\x3d\x30\x82\x74\x9f\x2d\x80\x0d\x39\x33\x39\x77\x6a\xaa\x61\x60\x64\x60\x1b\xda\xc1\xe9\x08\x1b\x8a\xfe\xf0\xbd\x1b\xc7\x94\x4c\xbb\x60\xe0\xa1\x6d\x91\x0f\xed\x96\xa1\x8f\xd6\xeb\x68\xdd\x38\x71\x01\x7d\x2f\xe3\x49\x35\x68\x8f\x0c\xd2\x69\x01\xb6\xbe\x77\xe3\xc9\x03\xf0\x3a\x8c\x1f\x4e\xab\x44\x7d\x43\x7d\xdc\x89\xaa\xbe\xef\xd4\x9d\xa7\x17\x3b\xc5\x4b\xfd\x9f\xab\xe4\x3d\xd3\x47\xe8\x10\xba\xcb\xac\xbc\xfc\x5b\xe6\x9e\xf7\xcf\xfb\xff\x7e\x06\x00\x00\xff\xff\xcb\x80\x8a\x5f\x08\x03\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/5/events": &vfsgen۰DirInfo{
			name:    "events",
			modTime: mustUnmarshalTextTime("2016-09-24T22:06:46Z"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/6": &vfsgen۰DirInfo{
			name:    "6",
			modTime: mustUnmarshalTextTime("2016-10-04T03:45:53Z"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/6/0": &vfsgen۰CompressedFileInfo{
			name:             "0",
			modTime:          mustUnmarshalTextTime("2016-10-03T21:34:31Z"),
			uncompressedSize: 1021,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x8c\x92\xcb\x6e\xdb\x3c\x10\x85\xf7\xff\x53\x0c\x66\xf3\x2f\xaa\xc8\x12\x4d\xdd\xb8\xcb\x0d\x45\x81\xa2\x8b\x5c\x36\x69\xb2\xa0\xa5\x91\xc5\x56\x22\x0d\x72\x94\xc6\x30\xfc\xee\x05\x9d\xde\x50\xc4\x49\x97\x23\x1d\x9e\x6f\xe6\xcc\xec\xf0\x9a\x35\x13\x2a\x74\x1b\xb2\x98\xe0\x8d\xe1\x31\x96\xb7\x81\xa0\xa3\x9e\x3c\x98\x1e\x0c\x07\x70\x8f\xe4\x07\xd2\x1d\x98\x00\x9e\x46\xcd\xe6\x91\xc6\x2d\x58\x5a\x8f\x66\x6d\x56\x23\x25\xe0\x3c\x18\x86\xd5\xbc\x0d\x30\x91\xb6\xc6\xae\xfb\x79\x04\x4f\xba\xd3\x2b\x33\x1a\xde\x62\x82\x1f\xf5\x8a\xc6\x80\xea\xf3\x0e\x3f\xe9\x29\x92\x4e\xdb\x96\x36\x4c\x1d\x26\x78\xee\x46\xe7\x51\xed\xf0\x0a\x95\x10\x32\xc1\xf7\xa8\xc4\xb2\x48\xf0\x0c\x95\x90\xc5\x7e\xff\x90\xe0\xe9\xcc\xc3\xb3\xe8\xc3\x05\xaa\xbc\x11\x32\x5f\xca\x04\x2f\xdc\xa4\x8d\x45\x85\x6b\xc3\xc3\xbc\x4a\x5b\x37\xe1\x3e\xc1\x73\x4f\x9a\xa9\x3b\x65\x54\x28\xb2\xbc\x3c\xc9\x9a\x13\x21\x6f\x84\x50\x59\xa5\x64\x95\x66\xa2\xa8\x8a\x46\x36\xf5\x1d\x26\x78\xd9\x99\xd8\x87\xda\xe1\xd9\xf6\x5f\x01\x2f\x3b\x17\x55\x5a\xe6\x79\x51\x57\x45\x5d\xde\x45\xd9\x99\xeb\xb6\xa8\xf0\xc2\xd9\xff\x19\xe6\x40\x31\x28\xd3\x03\x0f\xf4\x67\x3e\x10\x58\x6f\xc3\xe1\x6b\xd0\x13\x25\xa0\x43\x8c\x3b\xd6\xad\x8e\x8f\x2c\x84\xc1\x79\x86\xfc\x44\x00\x3d\x19\x86\x7e\xb6\x6d\x48\xef\xed\xbd\xbd\x0d\xc6\xae\xa3\xed\xa0\x03\x68\xe8\xcd\x13\x75\xb0\x21\xdf\x3b\x3f\x69\xdb\xd2\xaf\x05\x26\xf0\x6d\x30\xed\x10\x8d\xad\x63\xd3\x92\x5e\x8d\x04\xbd\xf3\xe0\x36\xe4\x35\x1b\x67\x23\x52\x33\xf8\xd9\x82\xb3\x07\xbc\xf3\x1d\x79\x70\x3d\x58\x6d\x5d\xa0\xd6\xd9\xee\x19\x7b\x4d\x04\x03\xf3\x26\xa8\xc5\x62\xfc\x2a\x3b\x99\x76\xda\xf3\x90\x1a\xb7\xd8\xb8\xc0\x61\x71\x38\xa2\x45\x8a\x09\x5e\x91\x6e\x0f\xee\x87\xed\x5f\x4e\xee\x8b\x89\x09\xe3\xbb\x1c\x7f\xae\xf5\xf9\xd7\x21\xf7\x32\x6b\x96\x65\x7d\x2c\xf7\x1f\x22\x21\x65\x93\x65\x6f\x89\x44\x95\xbf\x2e\x29\xb3\xaa\x7e\x8b\x25\x64\x21\xe3\x29\xbe\x8a\x5a\x8a\xa6\x29\x8e\x89\x1e\xa2\xec\xf7\xd8\xd3\x1c\x06\xef\xdc\xf4\xc2\xf0\x65\x5d\x8b\xe5\xb1\x9e\xff\xb2\x19\x48\x7b\x7e\xc1\x63\x99\x97\xf1\x72\x8f\x9a\x3c\xec\xff\xfb\x1e\x00\x00\xff\xff\x72\xb0\x3d\xe8\xfd\x03\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/6/1": &vfsgen۰CompressedFileInfo{
			name:             "1",
			modTime:          mustUnmarshalTextTime("2016-09-28T15:35:53Z"),
			uncompressedSize: 313,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x74\xd0\xb1\x4e\xf3\x30\x14\x05\xe0\xfd\x7f\x0a\xeb\xae\x7f\xda\xe4\xc6\x71\xea\x7a\x2b\x14\x24\x56\xc4\x04\xea\xe0\x38\xd7\xa9\x51\xed\x5b\xc5\xae\x04\xaa\xf2\xee\xa8\x02\x89\x89\xf5\x9c\xe1\xe8\x7c\x57\xd8\x5d\xca\x91\x67\x30\x57\x78\xda\x83\x51\xb8\xdd\xa8\x8d\xaa\x60\xcf\xd1\x86\x04\x06\xa6\x50\x8e\x97\x61\xed\x38\xc2\x52\xc1\xfd\x4c\xb6\xd0\xb8\x2b\x60\xa0\x6d\xb0\x5f\x35\xdb\x55\xab\x5f\x50\x99\x46\x1a\x94\x6b\x8d\x4a\x63\xbb\x69\xf4\x2b\x54\x70\xc7\xe3\x27\x18\x38\xd3\xec\x79\x8e\x36\x39\x12\x21\x8b\x81\x1c\xc7\x90\x26\x71\xa2\x9c\x05\x7b\x61\x93\x08\x39\x5f\x68\x2d\x1e\x79\x16\xf4\x61\xe3\xf9\x44\xe2\x58\xca\x39\x9b\xba\xfe\xdd\xaf\x27\x3e\xd9\x34\xd5\x13\xd7\x8e\x63\x0c\xa5\xf6\x7a\x68\x25\x76\x4e\xf5\x72\xa0\x4e\xf6\xbd\xef\x3b\xa5\x64\x4f\xba\x91\x68\x51\xb6\xce\x8f\x5e\x8e\x23\x54\xf0\x4c\xd6\x95\xc0\x29\x83\x79\xbb\xc2\x43\xe4\xf7\x70\xfb\x0b\xff\x11\xaa\x1f\x83\xef\xea\x96\xe2\xb6\xed\x50\x76\x7f\x28\x1c\x96\xc3\xf2\xef\x2b\x00\x00\xff\xff\x00\x26\x30\xc6\x39\x01\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/6/events": &vfsgen۰DirInfo{
			name:    "events",
			modTime: mustUnmarshalTextTime("2016-09-24T22:07:47Z"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/7": &vfsgen۰DirInfo{
			name:    "7",
			modTime: mustUnmarshalTextTime("2016-10-22T22:28:18Z"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/7/0": &vfsgen۰CompressedFileInfo{
			name:             "0",
			modTime:          mustUnmarshalTextTime("2016-10-22T22:28:14Z"),
			uncompressedSize: 1250,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x8c\x93\x4d\x6f\xdb\x38\x10\x86\xef\xfb\x2b\x06\xb3\x87\x1c\x56\x91\x25\xea\x9b\xb7\xc4\xce\x2e\x16\x28\x7a\x48\x7c\x4a\x1d\x34\xb4\x34\x91\x58\x88\xa4\x40\x52\x69\x0d\xc3\xff\xbd\x90\xed\x34\x2d\x9a\xd8\x3d\x92\x7a\xf0\xf0\x25\xe7\xd5\x16\xef\xbc\xf0\x84\x1c\xcd\x40\x1a\x03\x5c\x4a\xdf\x4f\xcb\xb9\x51\x8a\xb4\x77\xf0\x64\x2c\x74\xa3\x12\xda\x81\xe8\xbf\x8a\x8d\x83\x4e\x3c\x13\x08\x70\x52\xb7\x3d\x81\x1b\x44\x4d\x20\x9e\x3c\x59\xf0\x1d\x81\xeb\x85\xeb\xc8\x61\x80\x1f\xc4\x9a\x7a\x87\xfc\xd3\x16\x3f\x0a\x35\x49\xaf\xea\x9a\x06\x4f\x0d\x06\x38\x37\xbd\xb1\xc8\xb7\x78\x8b\x9c\xb1\x34\xc0\xff\x90\xb3\x24\x0b\xf0\x1a\x39\x4b\xb3\xdd\xee\x21\xc0\xab\xd1\x77\x07\xe8\xff\x05\xf2\xb8\x62\x69\x9c\xa4\x01\x2e\x8c\x12\x52\x23\xc7\x56\xfa\x6e\x5c\x87\xb5\x51\xb8\x0b\x70\x6e\x49\x78\x6a\xae\x3c\x72\x64\x51\x9c\x5f\x46\xd5\x25\x4b\x97\x8c\xf1\xa8\xe4\x59\x15\x46\x51\xc6\xd2\xa4\x28\xd2\x7b\x0c\xf0\xa6\x91\x53\x0e\xbe\xc5\xeb\xcd\x9f\x1e\xf0\xab\xb9\x5c\xc6\x15\x67\x31\x8f\xab\x30\x89\x73\x56\xb0\x28\xab\xee\x27\xec\xda\x34\x1b\xe4\xb8\x30\xe0\x3b\xe9\xf8\x4a\xaf\xf4\xe3\xe3\xe3\x4a\xcf\x66\xb0\xec\xa4\x03\xe9\x40\x40\x7d\x78\xde\xfd\xee\xeb\x0b\x87\x47\x74\xa5\x17\x46\x5f\x78\x68\x7e\x77\xbc\xa9\x78\xcb\xf0\xaf\xb1\x50\x1b\xed\xa4\xf3\xa4\xeb\x4d\x00\x42\x37\xb0\xa6\x5a\x8c\x8e\xf6\x83\xd2\xe6\x38\x3b\xe7\x37\x3d\x4d\x4e\x4b\x8e\xec\x33\x35\xfb\x44\x47\x3d\x0c\x56\xb4\x4a\xb8\x60\xbf\x49\xdf\x84\x1a\x7a\xfa\x39\x50\x6b\x78\x4b\x9a\xac\xf0\x04\xad\x01\x3b\x6a\x68\x49\x87\xad\xf9\x91\x64\x49\x6a\x30\x56\x58\xd9\x6f\x5e\xac\xd4\x80\x19\x3d\xd4\xa6\x21\x70\x9d\x19\xfb\x06\x44\xef\xcc\xa1\x5a\x2f\xc1\x5c\x00\xeb\xd1\x83\xf4\x17\x0e\xb4\xf1\xa0\x48\x68\x0f\xde\xc0\x9a\xf6\x1e\xe9\x3d\x35\xe1\x74\xc2\x1d\x11\x74\xde\x0f\x8e\x4f\x79\x7a\xa1\xdb\xd0\xd8\x76\x56\xab\x66\x56\x1b\x35\xc8\x9e\x66\x7f\x77\x8d\xbd\x9c\x1f\x16\xf6\xf3\x42\x5a\xaa\xbd\x7c\x26\x17\x62\x80\xb7\x24\x6a\x2f\x8d\x3e\x74\xf5\x46\x99\x2f\x72\xea\x03\xfe\x13\xe3\x4b\x09\x0f\x9f\xf6\x2d\xc9\xa3\x2a\xc9\xcb\xf7\x5a\x72\x84\x58\x9a\x56\x51\x74\x0e\x62\x45\x7c\x1a\xc9\xa3\xa2\x3c\x77\x16\x4b\xb3\x74\xfa\x71\x4e\x32\x71\x16\x65\x79\x71\x1a\x9a\x6a\x9c\xc6\xc9\x69\x28\x63\x65\xc6\xce\xdc\x2b\x61\x55\x95\x9d\x49\x94\xb3\xa2\xac\xde\xbb\xfd\xc3\x44\xbd\xce\x41\x8d\xae\xb3\xc6\xa8\x37\xa6\x91\x97\x25\x4b\xde\xd7\x3c\xec\xfe\xfa\x1e\x00\x00\xff\xff\xb7\xb5\xb3\x38\xe2\x04\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/7/events": &vfsgen۰DirInfo{
			name:    "events",
			modTime: mustUnmarshalTextTime("2016-09-24T22:08:59Z"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/8": &vfsgen۰DirInfo{
			name:    "8",
			modTime: mustUnmarshalTextTime("2016-10-04T03:45:49Z"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/8/0": &vfsgen۰CompressedFileInfo{
			name:             "0",
			modTime:          mustUnmarshalTextTime("2016-10-03T21:34:12Z"),
			uncompressedSize: 1225,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x8c\x93\x51\x6f\xda\x3c\x14\x86\xef\xbf\x5f\x71\x74\x6e\xbe\x8b\xa5\x40\x0c\x09\xe0\xbb\xb6\x30\x36\xa9\xda\xa4\xae\xbb\xe9\x40\x8b\x49\x4e\x89\x4b\xe2\x83\x6c\xa7\x0c\x21\xfe\xfb\xe4\xb2\x76\xeb\x16\xba\x5d\xc6\x79\xf5\xf8\x7d\xa3\x27\x7b\xfc\xe4\x95\x27\x94\xc8\x1b\x32\x18\xe1\x8d\xf6\x55\x78\x7c\xcb\x16\x96\x56\x99\xc2\x01\x5b\xd8\xb2\x2d\x1c\x6c\xb5\x2f\xa1\x66\x4b\xe0\x4b\x65\x20\x86\x5c\x6d\xb4\x57\x15\x54\xe4\x3d\xd9\x08\x2a\xde\x92\xcd\x95\x23\x50\xd5\xd3\xa9\xc3\x08\xaf\xd4\x92\x2a\x87\xf2\xcb\x1e\x3f\xa8\x3a\xe0\xcf\xf3\x9c\x36\x9e\x0a\x8c\xf0\x92\x2b\xb6\x28\xf7\x78\x8d\x52\x88\x41\x84\x33\x94\xa2\x9f\x44\x78\x81\x52\x0c\x92\xc3\x61\x11\xe1\x79\xe3\xcb\x63\xe8\xfd\x04\x65\x3c\x16\x83\xb8\x3f\x88\x70\xc2\xb5\xd2\x06\x25\xae\xb4\x2f\x9b\x65\x27\xe7\x1a\x0f\x11\x5e\x5a\x52\x9e\x8a\x73\x8f\x12\x45\x2f\x4e\xcf\x7a\xe3\x33\x31\xb8\x11\x42\xc6\xb1\xec\x89\xce\x38\x4d\xc5\x48\x8c\x7b\xe3\x5b\x8c\x70\x5a\xe8\xd0\x43\xee\xf1\x62\xf7\xaf\x17\xb4\x93\x45\xd2\x11\xa3\x61\x92\xf4\xd3\x51\x72\x1b\x62\x17\x5c\xec\x50\xe2\x84\xc1\x97\xda\xc9\xb9\x99\x9b\x2c\xcb\x66\x3c\x37\xdd\x2e\x4c\xbf\x6d\xd8\x7a\x2a\x3a\x73\xf3\xa0\x2c\x7c\x0c\x13\xa7\x46\x2d\x2b\x2a\x60\xc9\x5c\x1d\x8f\x67\xda\xbf\x6b\x96\x37\xbc\x26\x03\xce\x5b\x6d\x56\x81\xd2\xed\xc2\x67\x43\x2f\x01\xac\x5a\x01\xc7\xe2\x2f\x01\x59\x96\x05\xca\x84\xcd\xff\x1e\x8a\xd6\x76\x7f\xe2\xdb\xfb\xad\x5a\xfa\xfd\xc0\x5f\xb5\xc9\x10\x81\x61\x0f\x6c\xaa\x1d\xf8\x92\xe0\x4e\x5b\xe7\x9f\xf5\xe1\xbb\x5f\x0e\x83\x72\xb0\x2d\xc9\xc0\x8e\x1b\xd8\x2a\xe3\xc1\x33\xd4\x6a\x4d\xa0\x0c\x34\xcf\xfd\xe0\x81\xac\xd3\x6c\x3a\xe1\xce\x60\x6d\xce\xc6\x69\xe7\xc9\xe4\xbb\xa3\xb1\xdb\x52\xf9\x47\xf0\x8c\x61\x63\xf9\x9e\xf2\xb0\x9a\x5c\x04\xca\x14\xb0\xa4\x5c\x35\x8e\x40\x7b\xa8\x98\xd7\x0e\x8c\xce\xc9\x76\x20\x7b\x5c\x9c\x81\x76\x70\xdf\x84\x3e\xa4\x6d\xd1\xc1\x08\xaf\x49\xe5\x5e\xb3\x39\xfa\x3c\xad\xf9\x5e\x07\x67\xf0\x4d\x8c\x4f\xa2\x1e\x5f\x3d\x9a\x24\xc4\x30\x3e\xe5\xd1\x31\x92\xf6\x86\xa3\x74\xf4\x7a\x46\x0c\x92\x41\xf8\x25\x5e\xcd\xc4\x49\x2f\x49\x87\xaf\x87\xfa\x71\x1a\xd4\xfe\x4b\xa3\xa4\x77\xaa\xcf\x22\x64\x7e\x6e\xae\x1b\x57\x5a\xe6\xba\x65\x79\x3a\x1a\x89\xfe\xa9\xe9\xbf\x61\x7c\xa9\xcd\x5a\x9b\xd5\xd7\x3b\x95\x53\xdb\x57\xec\x8b\xf1\x38\x39\xb5\x7f\x71\x58\x1c\xfe\xfb\x1e\x00\x00\xff\xff\x2f\xdc\x2d\x73\xc9\x04\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/8/1": &vfsgen۰CompressedFileInfo{
			name:             "1",
			modTime:          mustUnmarshalTextTime("2016-09-28T08:38:13Z"),
			uncompressedSize: 380,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x54\xcf\x4d\x8b\xe2\x40\x10\xc6\xf1\xfb\x7e\x8a\x87\x3a\x29\xc4\x10\x5f\x70\x93\xdc\x5c\xdd\x83\x87\x65\x05\x85\x85\x25\x97\x4a\xba\x34\xcd\x74\xba\x43\x77\x47\x09\xe2\x77\x1f\x9c\xc3\x38\x73\xfd\x51\xf5\xc0\xff\x4e\x9b\x21\xb6\xce\x53\x79\xa7\xfd\x8e\xca\xd5\x3a\xcf\xf3\x84\x76\xae\x63\x6d\xa9\xa4\x8b\x8e\xed\x50\xa7\x8d\xeb\xe8\x91\xd0\xd6\x0b\x47\x51\x9b\x48\x25\x2d\xb2\xf9\x7a\x96\x15\xb3\x45\x7e\xca\xf2\x72\x99\x97\xf3\x65\x5a\xac\x8a\xe2\x67\x3e\xff\x4f\x09\xfd\x72\x6a\xa4\x92\x0e\xe2\x5b\xee\x03\x62\x2b\xf0\x83\x11\x34\x6e\x30\x0a\xb5\xa0\x31\xec\xf5\x59\x8b\x42\x3d\x22\xf0\xa8\xed\x05\xb5\x8b\x2d\x2a\xaa\x3d\x5b\x15\x2a\x02\x5b\x85\x8a\xac\x84\x28\x0a\xdc\x78\x67\xc7\x2e\xc0\x79\x70\x5d\x7b\xb9\x6a\x8e\xda\xd9\x50\x51\x8a\xa3\xb6\x8d\xa0\xa2\xbf\xcf\x9c\x8a\xa0\x03\xd8\x7e\x3b\x4b\x10\x3a\x0e\x2d\xd8\x18\x0c\x7d\x2f\xbe\xe1\x20\x29\xf6\x11\x6c\x82\xc3\xcd\xf9\xb7\x80\xb3\xf3\x38\xfe\x39\x1d\x7e\xdb\xab\x18\xd7\x0b\x66\xd5\x90\x65\x4b\x41\xe8\x62\xff\x89\x93\xaf\xbb\xd3\x14\x1b\xab\x70\x74\x56\x37\xff\xd8\x98\xad\xd1\x62\xe3\xeb\xf1\xe9\xb7\x97\x4f\x3e\xe2\xa6\x29\x3d\x7e\xbc\x07\x00\x00\xff\xff\x50\xf4\xc9\x67\x7c\x01\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/8/2": &vfsgen۰CompressedFileInfo{
			name:             "2",
			modTime:          mustUnmarshalTextTime("2016-09-28T08:50:35Z"),
			uncompressedSize: 747,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xa4\x91\x41\x6f\xd3\x40\x14\x84\xef\xfc\x8a\xd1\x72\x28\x48\xae\xed\x3a\x6e\x69\x7c\x81\x36\xad\x68\x0e\x88\xaa\xad\x84\x54\xf5\xd0\xe7\xf8\x61\x2f\x59\xef\x46\xfb\x9e\x63\x59\x55\xff\x3b\x4a\x72\x00\x21\x0e\x48\x9c\x67\x76\x66\xf6\x7d\x2f\xe6\x62\xd0\x2e\x44\x53\xbd\x98\xe5\x95\xa9\x4e\xe6\x45\x79\x32\x2b\x13\x73\x15\x7a\xb2\xde\x54\xa6\xb5\xda\x0d\x75\xba\x0a\xbd\x79\x4d\xcc\x22\x32\x29\x37\x17\x6a\x2a\x53\xe4\x27\x67\xc7\xf9\xfc\xb8\x38\x7f\xc8\xcf\xab\x72\x5e\x95\x1f\xd2\xa2\x28\xf3\x32\x2f\x66\x67\x8f\x26\x31\xd7\x8d\x55\x6e\x76\xd1\x97\xd3\xbf\x16\xfc\x25\xf9\x34\xaf\x66\xa7\x69\x71\x5e\xcc\xcf\x66\x65\x3e\x7b\xdc\xd9\x2e\x43\x33\x99\xca\x7c\x5a\x4f\x8e\xb7\xb8\xe9\xfb\x04\x4b\x34\xc1\x1f\x29\xb4\xb3\x7e\x8d\x25\x3c\x73\x03\x0d\x58\x85\x2d\x47\xd0\x2a\x06\x3f\xf5\x92\x51\x5d\x47\xde\x5a\x52\x1b\xbc\x24\x10\xeb\x57\x0c\xed\x48\x8f\x04\xe4\x22\x53\x33\x1d\x9e\x70\x83\x7a\x42\xa7\xba\x91\x2a\xcb\x7e\xad\xcc\xda\xe0\xc8\xb7\x59\x1b\xb2\xd1\xae\x6d\xb6\x08\x0d\xdf\xf1\xd6\xf2\xb8\x08\x7d\xcf\x5e\xe5\xad\xf5\x56\x2d\x39\x2b\xbd\xa4\x78\xe8\xac\x40\x86\xb6\x65\xd9\x75\xc2\x0a\x22\x93\x73\x13\x7a\x26\xaf\xa0\x3a\x0c\x8a\x3a\x92\x6f\xe0\xa9\x67\x49\xe0\xec\x9a\xd1\xde\xdd\x2e\x12\x7c\xdd\xf1\x49\xf0\xd9\xea\xcd\x50\x27\xb8\x0f\xde\xae\xbe\x91\x73\xe9\x93\x7f\xf2\xcf\xf7\x5f\x6e\x1f\xae\xfd\x96\x5d\xd8\xf0\x33\x7e\x0c\xa2\xf8\x1e\x9c\x0b\xa3\x40\x3b\xfe\xef\xf1\x88\x83\xe3\x7d\xd3\x55\x60\xd9\x5f\x09\x3d\xad\x19\xc2\x5e\xf8\xe3\x4e\x78\x77\xe1\x24\x24\xbf\xcf\x3f\xd8\x0e\x2c\x6a\x6e\xad\xc7\x68\xb5\x03\x61\x45\x1b\xab\xe4\xe0\x58\x95\x63\x82\x7a\x50\x74\xb4\xe5\x3f\x04\x01\x3b\xe1\xb1\xe3\xc8\x09\x28\x32\x36\x91\x55\x27\x74\x14\xf7\x3c\x1b\x26\xb7\x8f\x4c\xd3\x14\xcb\xa3\x1e\xa2\xd6\x39\xf8\xa0\x90\x21\x32\xc6\x03\xcb\xdd\xff\x6b\x16\xc5\x48\x53\xfa\xde\xbc\xbe\xf9\x19\x00\x00\xff\xff\x46\x31\xe6\xb6\xeb\x02\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/8/events": &vfsgen۰DirInfo{
			name:    "events",
			modTime: mustUnmarshalTextTime("2016-09-24T22:11:02Z"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/9": &vfsgen۰DirInfo{
			name:    "9",
			modTime: mustUnmarshalTextTime("2016-10-04T03:45:53Z"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/9/0": &vfsgen۰CompressedFileInfo{
			name:             "0",
			modTime:          mustUnmarshalTextTime("2016-10-03T21:33:47Z"),
			uncompressedSize: 1852,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x9c\x94\x5d\x6f\xe2\x38\x14\x86\xef\xf7\x57\x58\x67\x2f\xb6\xd5\x66\x92\xd8\x24\x21\xb1\x34\x17\x65\x60\x47\x2b\xad\xaa\xd5\xc0\xd5\x6c\x90\xea\x26\x6e\x70\xeb\xd8\xc8\x71\x60\x11\xe2\xbf\x8f\x1c\x68\x4b\x3f\x20\x55\x2f\x93\xf3\xf8\x7d\xcf\x97\xce\x16\xa6\x96\x59\x0e\x14\xf4\x92\x2b\xf0\x60\x26\xac\x74\x9f\x13\x63\xb4\x41\x2b\x66\x04\xbb\x95\x1c\x29\x56\x0b\x55\x81\x07\xff\xb0\x5b\x2e\x1b\xa0\xff\x6d\xe1\x9a\xd5\x8e\xbc\x2a\x0a\xbe\xb4\xbc\x04\x0f\xbe\x69\xa9\x0d\xd0\x2d\xfc\x00\x4a\x48\xe4\xc1\x77\xa0\x64\x10\x7b\x30\x02\x4a\xa2\x78\xb7\x9b\x7b\x70\xd5\xda\xc5\x1e\xfa\x7b\x0c\x14\x67\x24\xc2\x83\xc8\x83\xb1\xae\x99\x50\x40\xa1\x12\x76\xd1\xde\xfa\x85\xae\x61\xe7\xc1\x37\xc3\x99\xe5\xe5\x95\x05\x0a\x24\xc4\xc9\x97\x30\xfb\x42\xa2\x19\x21\x14\x13\x1a\x0f\xfd\x34\xc9\x32\x3c\x8c\xa2\xe4\x27\x78\x30\x29\x85\xcb\x83\x6e\x61\xb4\xf9\xa8\xc1\x4b\xe5\x74\x86\x33\x8a\x33\x1a\x11\x1f\xa7\x61\x82\xe3\x0c\x67\x3f\x1d\x36\xd2\xe5\x06\x28\x8c\x35\xb2\x0b\xd1\xd0\x5c\xe5\xea\xe6\xe6\xe6\xbb\xce\x55\x10\xa0\x7f\x59\xf1\xc0\x2a\x8e\x24\x5f\x71\x89\xf8\xff\x4b\x6d\x2c\x2f\x11\x77\x2d\xf4\x73\xb5\x62\x06\x4d\x8c\x99\xea\x9a\xdb\x85\x50\x15\xfa\xba\x0f\x35\xfe\x35\x5f\x5f\xe4\xd0\x3c\x05\xd6\x5c\x59\xb4\x36\x5a\x55\x39\x5c\x3a\x8f\xbb\x56\x15\xc8\xe5\x7d\x71\x89\xb6\xb9\xca\x6d\x10\xa0\x6b\x6d\x6a\x26\xe5\x06\x6d\x74\x8b\x0a\x26\x25\x12\x16\xdd\xb7\x8d\x45\x39\x70\x63\x72\xf0\x1c\x68\x78\xd3\x4a\xeb\x39\x27\x44\xbf\xa2\x52\x3f\xd9\x5f\x5c\x1e\x84\x98\x2a\x51\xdb\xf0\x0e\x31\xa2\x5a\x58\xc4\xd6\x6c\xe3\x3b\xdf\x2e\x3e\x6a\x2d\x12\x77\x9d\xcd\x9a\x29\x8b\xac\x46\x95\x58\x71\x67\xc7\x90\xd4\xaa\xe2\xc6\xed\x05\xf7\x3a\x95\xa3\x3a\xba\xdd\xc9\xc1\x29\x59\x57\x7c\xb3\xe4\x85\xb8\x13\xc5\x7e\xa7\xba\xda\x8f\x53\x7c\x19\xee\x72\x3d\xfc\x99\x3d\xe5\xbb\xcf\xc8\xf7\xfd\xce\xeb\xe5\x0b\xc9\x2c\x77\x7d\xde\x75\x33\x71\xf0\x58\xab\x3f\x2c\x2a\xdf\x0e\xeb\x30\x0a\xfd\x89\x61\xb8\xa7\xd3\xa3\x0a\x3f\xfd\x50\x7f\xfc\xe9\x3b\x0b\xf0\xaa\x9f\x67\xbb\x79\xba\x97\x4e\x85\x1b\xf3\x18\x7b\xab\x72\x1c\xec\x53\xd1\xe7\x75\x74\x8f\xd2\xf3\xd8\xfe\xd2\x06\x15\x5a\x35\xa2\xb1\x5c\x15\x1b\x1f\x4d\x39\x47\x0b\x6b\x97\x0d\x0d\x02\xcb\xe4\x43\xe3\x57\x5a\x32\x55\xf9\xda\x54\x01\x09\x71\x14\xb8\xfd\x6b\xfc\x46\x8a\x92\xff\x8e\x63\x1f\x3c\xf8\xc1\x59\x61\x85\x56\xfb\x1b\x35\xa9\xf5\xbd\x70\x77\x00\x0a\xc9\x96\xf0\x78\x7e\xf6\xc1\xee\x3e\x0c\x93\x21\xc6\xe9\xa9\xfb\x70\x80\x92\x30\x1b\x24\x7d\x50\x46\xd2\x24\xc3\x3d\x10\x49\xd3\x24\x8e\x93\x3e\x8a\x0c\x7b\x84\x48\x14\x47\xee\xb2\x9e\x63\x92\x38\x3c\x95\xf3\xdc\x31\xcf\xcd\xf9\x13\xbf\xd3\x9a\x24\x1c\xa6\x7d\x45\x7f\x24\x0d\x82\xe3\x30\x4e\x86\xe7\xa1\x01\x4e\xdc\xa1\x3e\x0f\xa5\x51\x1a\xf7\xb9\xe1\x01\xc9\xb2\xf8\x14\xf4\xaa\xee\xba\x6d\x16\x46\xeb\xfa\xbd\xea\xd3\x94\x0c\x4e\x0d\x61\xbe\x9b\xef\x7e\xfb\x15\x00\x00\xff\xff\xfb\xf0\x14\x76\x3c\x07\x00\x00"),
		},
		"/dmitri.shuralyov.com/idiomatic-go/issues/9/events": &vfsgen۰DirInfo{
			name:    "events",
			modTime: mustUnmarshalTextTime("2016-09-24T22:12:57Z"),
		},
	}
	fs["/"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/dmitri.shuralyov.com"].(os.FileInfo),
	}
	fs["/dmitri.shuralyov.com"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/dmitri.shuralyov.com/idiomatic-go"].(os.FileInfo),
	}
	fs["/dmitri.shuralyov.com/idiomatic-go"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/dmitri.shuralyov.com/idiomatic-go/issues"].(os.FileInfo),
	}
	fs["/dmitri.shuralyov.com/idiomatic-go/issues"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/1"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/10"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/11"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/12"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/2"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/3"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/4"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/5"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/6"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/7"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/8"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/9"].(os.FileInfo),
	}
	fs["/dmitri.shuralyov.com/idiomatic-go/issues/1"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/1/0"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/1/1"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/1/2"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/1/events"].(os.FileInfo),
	}
	fs["/dmitri.shuralyov.com/idiomatic-go/issues/10"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/10/0"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/10/events"].(os.FileInfo),
	}
	fs["/dmitri.shuralyov.com/idiomatic-go/issues/11"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/11/0"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/11/1"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/11/2"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/11/3"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/11/4"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/11/events"].(os.FileInfo),
	}
	fs["/dmitri.shuralyov.com/idiomatic-go/issues/11/events"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/11/events/1"].(os.FileInfo),
	}
	fs["/dmitri.shuralyov.com/idiomatic-go/issues/12"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/12/0"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/12/events"].(os.FileInfo),
	}
	fs["/dmitri.shuralyov.com/idiomatic-go/issues/2"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/2/0"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/2/1"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/2/2"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/2/3"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/2/4"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/2/events"].(os.FileInfo),
	}
	fs["/dmitri.shuralyov.com/idiomatic-go/issues/3"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/3/0"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/3/1"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/3/2"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/3/events"].(os.FileInfo),
	}
	fs["/dmitri.shuralyov.com/idiomatic-go/issues/4"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/4/0"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/4/1"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/4/2"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/4/3"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/4/4"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/4/5"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/4/6"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/4/events"].(os.FileInfo),
	}
	fs["/dmitri.shuralyov.com/idiomatic-go/issues/5"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/5/0"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/5/1"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/5/2"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/5/events"].(os.FileInfo),
	}
	fs["/dmitri.shuralyov.com/idiomatic-go/issues/6"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/6/0"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/6/1"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/6/events"].(os.FileInfo),
	}
	fs["/dmitri.shuralyov.com/idiomatic-go/issues/7"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/7/0"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/7/events"].(os.FileInfo),
	}
	fs["/dmitri.shuralyov.com/idiomatic-go/issues/8"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/8/0"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/8/1"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/8/2"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/8/events"].(os.FileInfo),
	}
	fs["/dmitri.shuralyov.com/idiomatic-go/issues/9"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/9/0"].(os.FileInfo),
		fs["/dmitri.shuralyov.com/idiomatic-go/issues/9/events"].(os.FileInfo),
	}

	return fs
}()

type vfsgen۰FS map[string]interface{}

func (fs vfsgen۰FS) Open(path string) (http.File, error) {
	path = pathpkg.Clean("/" + path)
	f, ok := fs[path]
	if !ok {
		return nil, &os.PathError{Op: "open", Path: path, Err: os.ErrNotExist}
	}

	switch f := f.(type) {
	case *vfsgen۰CompressedFileInfo:
		gr, err := gzip.NewReader(bytes.NewReader(f.compressedContent))
		if err != nil {
			// This should never happen because we generate the gzip bytes such that they are always valid.
			panic("unexpected error reading own gzip compressed bytes: " + err.Error())
		}
		return &vfsgen۰CompressedFile{
			vfsgen۰CompressedFileInfo: f,
			gr:                        gr,
		}, nil
	case *vfsgen۰FileInfo:
		return &vfsgen۰File{
			vfsgen۰FileInfo: f,
			Reader:          bytes.NewReader(f.content),
		}, nil
	case *vfsgen۰DirInfo:
		return &vfsgen۰Dir{
			vfsgen۰DirInfo: f,
		}, nil
	default:
		// This should never happen because we generate only the above types.
		panic(fmt.Sprintf("unexpected type %T", f))
	}
}

// vfsgen۰CompressedFileInfo is a static definition of a gzip compressed file.
type vfsgen۰CompressedFileInfo struct {
	name              string
	modTime           time.Time
	compressedContent []byte
	uncompressedSize  int64
}

func (f *vfsgen۰CompressedFileInfo) Readdir(count int) ([]os.FileInfo, error) {
	return nil, fmt.Errorf("cannot Readdir from file %s", f.name)
}
func (f *vfsgen۰CompressedFileInfo) Stat() (os.FileInfo, error) { return f, nil }

func (f *vfsgen۰CompressedFileInfo) GzipBytes() []byte {
	return f.compressedContent
}

func (f *vfsgen۰CompressedFileInfo) Name() string       { return f.name }
func (f *vfsgen۰CompressedFileInfo) Size() int64        { return f.uncompressedSize }
func (f *vfsgen۰CompressedFileInfo) Mode() os.FileMode  { return 0444 }
func (f *vfsgen۰CompressedFileInfo) ModTime() time.Time { return f.modTime }
func (f *vfsgen۰CompressedFileInfo) IsDir() bool        { return false }
func (f *vfsgen۰CompressedFileInfo) Sys() interface{}   { return nil }

// vfsgen۰CompressedFile is an opened compressedFile instance.
type vfsgen۰CompressedFile struct {
	*vfsgen۰CompressedFileInfo
	gr      *gzip.Reader
	grPos   int64 // Actual gr uncompressed position.
	seekPos int64 // Seek uncompressed position.
}

func (f *vfsgen۰CompressedFile) Read(p []byte) (n int, err error) {
	if f.grPos > f.seekPos {
		// Rewind to beginning.
		err = f.gr.Reset(bytes.NewReader(f.compressedContent))
		if err != nil {
			return 0, err
		}
		f.grPos = 0
	}
	if f.grPos < f.seekPos {
		// Fast-forward.
		_, err = io.CopyN(ioutil.Discard, f.gr, f.seekPos-f.grPos)
		if err != nil {
			return 0, err
		}
		f.grPos = f.seekPos
	}
	n, err = f.gr.Read(p)
	f.grPos += int64(n)
	f.seekPos = f.grPos
	return n, err
}
func (f *vfsgen۰CompressedFile) Seek(offset int64, whence int) (int64, error) {
	switch whence {
	case io.SeekStart:
		f.seekPos = 0 + offset
	case io.SeekCurrent:
		f.seekPos += offset
	case io.SeekEnd:
		f.seekPos = f.uncompressedSize + offset
	default:
		panic(fmt.Errorf("invalid whence value: %v", whence))
	}
	return f.seekPos, nil
}
func (f *vfsgen۰CompressedFile) Close() error {
	return f.gr.Close()
}

// vfsgen۰FileInfo is a static definition of an uncompressed file (because it's not worth gzip compressing).
type vfsgen۰FileInfo struct {
	name    string
	modTime time.Time
	content []byte
}

func (f *vfsgen۰FileInfo) Readdir(count int) ([]os.FileInfo, error) {
	return nil, fmt.Errorf("cannot Readdir from file %s", f.name)
}
func (f *vfsgen۰FileInfo) Stat() (os.FileInfo, error) { return f, nil }

func (f *vfsgen۰FileInfo) NotWorthGzipCompressing() {}

func (f *vfsgen۰FileInfo) Name() string       { return f.name }
func (f *vfsgen۰FileInfo) Size() int64        { return int64(len(f.content)) }
func (f *vfsgen۰FileInfo) Mode() os.FileMode  { return 0444 }
func (f *vfsgen۰FileInfo) ModTime() time.Time { return f.modTime }
func (f *vfsgen۰FileInfo) IsDir() bool        { return false }
func (f *vfsgen۰FileInfo) Sys() interface{}   { return nil }

// vfsgen۰File is an opened file instance.
type vfsgen۰File struct {
	*vfsgen۰FileInfo
	*bytes.Reader
}

func (f *vfsgen۰File) Close() error {
	return nil
}

// vfsgen۰DirInfo is a static definition of a directory.
type vfsgen۰DirInfo struct {
	name    string
	modTime time.Time
	entries []os.FileInfo
}

func (d *vfsgen۰DirInfo) Read([]byte) (int, error) {
	return 0, fmt.Errorf("cannot Read from directory %s", d.name)
}
func (d *vfsgen۰DirInfo) Close() error               { return nil }
func (d *vfsgen۰DirInfo) Stat() (os.FileInfo, error) { return d, nil }

func (d *vfsgen۰DirInfo) Name() string       { return d.name }
func (d *vfsgen۰DirInfo) Size() int64        { return 0 }
func (d *vfsgen۰DirInfo) Mode() os.FileMode  { return 0755 | os.ModeDir }
func (d *vfsgen۰DirInfo) ModTime() time.Time { return d.modTime }
func (d *vfsgen۰DirInfo) IsDir() bool        { return true }
func (d *vfsgen۰DirInfo) Sys() interface{}   { return nil }

// vfsgen۰Dir is an opened dir instance.
type vfsgen۰Dir struct {
	*vfsgen۰DirInfo
	pos int // Position within entries for Seek and Readdir.
}

func (d *vfsgen۰Dir) Seek(offset int64, whence int) (int64, error) {
	if offset == 0 && whence == io.SeekStart {
		d.pos = 0
		return 0, nil
	}
	return 0, fmt.Errorf("unsupported Seek in directory %s", d.name)
}

func (d *vfsgen۰Dir) Readdir(count int) ([]os.FileInfo, error) {
	if d.pos >= len(d.entries) && count > 0 {
		return nil, io.EOF
	}
	if count <= 0 || count > len(d.entries)-d.pos {
		count = len(d.entries) - d.pos
	}
	e := d.entries[d.pos : d.pos+count]
	d.pos += count
	return e, nil
}
