package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTotalStatistics invokes the aegis.DescribeTotalStatistics API synchronously
// api document: https://help.aliyun.com/api/aegis/describetotalstatistics.html
func (client *Client) DescribeTotalStatistics(request *DescribeTotalStatisticsRequest) (response *DescribeTotalStatisticsResponse, err error) {
	response = CreateDescribeTotalStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTotalStatisticsWithChan invokes the aegis.DescribeTotalStatistics API asynchronously
// api document: https://help.aliyun.com/api/aegis/describetotalstatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTotalStatisticsWithChan(request *DescribeTotalStatisticsRequest) (<-chan *DescribeTotalStatisticsResponse, <-chan error) {
	responseChan := make(chan *DescribeTotalStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTotalStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTotalStatisticsWithCallback invokes the aegis.DescribeTotalStatistics API asynchronously
// api document: https://help.aliyun.com/api/aegis/describetotalstatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTotalStatisticsWithCallback(request *DescribeTotalStatisticsRequest, callback func(response *DescribeTotalStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTotalStatisticsResponse
		var err error
		defer close(result)
		response, err = client.DescribeTotalStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTotalStatisticsRequest is the request struct for api DescribeTotalStatistics
type DescribeTotalStatisticsRequest struct {
	*requests.RpcRequest
	StatusList  string           `position:"Query" name:"StatusList"`
	SaleId      string           `position:"Query" name:"SaleId"`
	RuleType    requests.Integer `position:"Query" name:"RuleType"`
	GroupId     requests.Integer `position:"Query" name:"GroupId"`
	EndTime     string           `position:"Query" name:"EndTime"`
	Remark      string           `position:"Query" name:"Remark"`
	Dealed      string           `position:"Query" name:"Dealed"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	StartTime   string           `position:"Query" name:"StartTime"`
	Type        string           `position:"Query" name:"Type"`
	Uuid        string           `position:"Query" name:"Uuid"`
	SecureToken string           `position:"Query" name:"SecureToken"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	WebGroupId  requests.Integer `position:"Query" name:"WebGroupId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	From        string           `position:"Query" name:"From"`
	Action1     requests.Integer `position:"Query" name:"Action1"`
	Tag         string           `position:"Query" name:"Tag"`
	Flow        requests.Integer `position:"Query" name:"Flow"`
	Status      requests.Integer `position:"Query" name:"Status"`
}

// DescribeTotalStatisticsResponse is the response struct for api DescribeTotalStatistics
type DescribeTotalStatisticsResponse struct {
	*responses.BaseResponse
	RequestId              string `json:"RequestId" xml:"RequestId"`
	VulAsapSum             int    `json:"VulAsapSum" xml:"VulAsapSum"`
	VulNntfSum             int    `json:"VulNntfSum" xml:"VulNntfSum"`
	HealthTotal            int    `json:"HealthTotal" xml:"HealthTotal"`
	SuspiciousmediumTotal  int    `json:"SuspiciousmediumTotal" xml:"SuspiciousmediumTotal"`
	Health                 int    `json:"Health" xml:"Health"`
	HealthdealedTotal      int    `json:"HealthdealedTotal" xml:"HealthdealedTotal"`
	Trojan                 int    `json:"Trojan" xml:"Trojan"`
	VulLaterSum            int    `json:"VulLaterSum" xml:"VulLaterSum"`
	Suspicious             int    `json:"Suspicious" xml:"Suspicious"`
	Vul                    int    `json:"Vul" xml:"Vul"`
	HealthhighTotal        int    `json:"HealthhighTotal" xml:"HealthhighTotal"`
	HealthlowTotal         int    `json:"HealthlowTotal" xml:"HealthlowTotal"`
	HealthseriousTotal     int    `json:"HealthseriousTotal" xml:"HealthseriousTotal"`
	VulDealedTotal         int    `json:"VulDealedTotal" xml:"VulDealedTotal"`
	Patch                  int    `json:"Patch" xml:"Patch"`
	SuspicioushighTotal    int    `json:"SuspicioushighTotal" xml:"SuspicioushighTotal"`
	SuspiciouslowTotal     int    `json:"SuspiciouslowTotal" xml:"SuspiciouslowTotal"`
	SuspiciousTotal        int    `json:"SuspiciousTotal" xml:"SuspiciousTotal"`
	VulTotal               int    `json:"VulTotal" xml:"VulTotal"`
	SuspiciousseriousTotal int    `json:"SuspiciousseriousTotal" xml:"SuspiciousseriousTotal"`
	HealthmediumTotal      int    `json:"HealthmediumTotal" xml:"HealthmediumTotal"`
	Online                 bool   `json:"Online" xml:"Online"`
	SuspiciousdealedTotal  int    `json:"SuspiciousdealedTotal" xml:"SuspiciousdealedTotal"`
	Account                int    `json:"Account" xml:"Account"`
	Newsuspicious          int    `json:"Newsuspicious" xml:"Newsuspicious"`
}

// CreateDescribeTotalStatisticsRequest creates a request to invoke DescribeTotalStatistics API
func CreateDescribeTotalStatisticsRequest() (request *DescribeTotalStatisticsRequest) {
	request = &DescribeTotalStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeTotalStatistics", "vipaegis", "openAPI")
	return
}

// CreateDescribeTotalStatisticsResponse creates a response to parse from DescribeTotalStatistics response
func CreateDescribeTotalStatisticsResponse() (response *DescribeTotalStatisticsResponse) {
	response = &DescribeTotalStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
