package afs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AuthenticateSig invokes the afs.AuthenticateSig API synchronously
// api document: https://help.aliyun.com/api/afs/authenticatesig.html
func (client *Client) AuthenticateSig(request *AuthenticateSigRequest) (response *AuthenticateSigResponse, err error) {
	response = CreateAuthenticateSigResponse()
	err = client.DoAction(request, response)
	return
}

// AuthenticateSigWithChan invokes the afs.AuthenticateSig API asynchronously
// api document: https://help.aliyun.com/api/afs/authenticatesig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AuthenticateSigWithChan(request *AuthenticateSigRequest) (<-chan *AuthenticateSigResponse, <-chan error) {
	responseChan := make(chan *AuthenticateSigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AuthenticateSig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AuthenticateSigWithCallback invokes the afs.AuthenticateSig API asynchronously
// api document: https://help.aliyun.com/api/afs/authenticatesig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AuthenticateSigWithCallback(request *AuthenticateSigRequest, callback func(response *AuthenticateSigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AuthenticateSigResponse
		var err error
		defer close(result)
		response, err = client.AuthenticateSig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AuthenticateSigRequest is the request struct for api AuthenticateSig
type AuthenticateSigRequest struct {
	*requests.RpcRequest
	Sig       string `position:"Query" name:"Sig"`
	RemoteIp  string `position:"Query" name:"RemoteIp"`
	SourceIp  string `position:"Query" name:"SourceIp"`
	AppKey    string `position:"Query" name:"AppKey"`
	SessionId string `position:"Query" name:"SessionId"`
	Token     string `position:"Query" name:"Token"`
	Scene     string `position:"Query" name:"Scene"`
}

// AuthenticateSigResponse is the response struct for api AuthenticateSig
type AuthenticateSigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Msg       string `json:"Msg" xml:"Msg"`
	RiskLevel string `json:"RiskLevel" xml:"RiskLevel"`
	Detail    string `json:"Detail" xml:"Detail"`
}

// CreateAuthenticateSigRequest creates a request to invoke AuthenticateSig API
func CreateAuthenticateSigRequest() (request *AuthenticateSigRequest) {
	request = &AuthenticateSigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("afs", "2018-01-12", "AuthenticateSig", "afs", "openAPI")
	return
}

// CreateAuthenticateSigResponse creates a response to parse from AuthenticateSig response
func CreateAuthenticateSigResponse() (response *AuthenticateSigResponse) {
	response = &AuthenticateSigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
