package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDiversify invokes the airec.DeleteDiversify API synchronously
// api document: https://help.aliyun.com/api/airec/deletediversify.html
func (client *Client) DeleteDiversify(request *DeleteDiversifyRequest) (response *DeleteDiversifyResponse, err error) {
	response = CreateDeleteDiversifyResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDiversifyWithChan invokes the airec.DeleteDiversify API asynchronously
// api document: https://help.aliyun.com/api/airec/deletediversify.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteDiversifyWithChan(request *DeleteDiversifyRequest) (<-chan *DeleteDiversifyResponse, <-chan error) {
	responseChan := make(chan *DeleteDiversifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDiversify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDiversifyWithCallback invokes the airec.DeleteDiversify API asynchronously
// api document: https://help.aliyun.com/api/airec/deletediversify.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteDiversifyWithCallback(request *DeleteDiversifyRequest, callback func(response *DeleteDiversifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDiversifyResponse
		var err error
		defer close(result)
		response, err = client.DeleteDiversify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDiversifyRequest is the request struct for api DeleteDiversify
type DeleteDiversifyRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
	Name       string `position:"Path" name:"Name"`
}

// DeleteDiversifyResponse is the response struct for api DeleteDiversify
type DeleteDiversifyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDeleteDiversifyRequest creates a request to invoke DeleteDiversify API
func CreateDeleteDiversifyRequest() (request *DeleteDiversifyRequest) {
	request = &DeleteDiversifyRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2018-10-12", "DeleteDiversify", "/openapi/instances/[InstanceId]/diversifies/[Name]", "airec", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteDiversifyResponse creates a response to parse from DeleteDiversify response
func CreateDeleteDiversifyResponse() (response *DeleteDiversifyResponse) {
	response = &DeleteDiversifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
