package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ValidateInstance invokes the airec.ValidateInstance API synchronously
// api document: https://help.aliyun.com/api/airec/validateinstance.html
func (client *Client) ValidateInstance(request *ValidateInstanceRequest) (response *ValidateInstanceResponse, err error) {
	response = CreateValidateInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// ValidateInstanceWithChan invokes the airec.ValidateInstance API asynchronously
// api document: https://help.aliyun.com/api/airec/validateinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ValidateInstanceWithChan(request *ValidateInstanceRequest) (<-chan *ValidateInstanceResponse, <-chan error) {
	responseChan := make(chan *ValidateInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ValidateInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ValidateInstanceWithCallback invokes the airec.ValidateInstance API asynchronously
// api document: https://help.aliyun.com/api/airec/validateinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ValidateInstanceWithCallback(request *ValidateInstanceRequest, callback func(response *ValidateInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ValidateInstanceResponse
		var err error
		defer close(result)
		response, err = client.ValidateInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ValidateInstanceRequest is the request struct for api ValidateInstance
type ValidateInstanceRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
}

// ValidateInstanceResponse is the response struct for api ValidateInstance
type ValidateInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateValidateInstanceRequest creates a request to invoke ValidateInstance API
func CreateValidateInstanceRequest() (request *ValidateInstanceRequest) {
	request = &ValidateInstanceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2018-10-12", "ValidateInstance", "/openapi/instances/[InstanceId]/actions/validate", "airec", "openAPI")
	request.Method = requests.POST
	return
}

// CreateValidateInstanceResponse creates a response to parse from ValidateInstance response
func CreateValidateInstanceResponse() (response *ValidateInstanceResponse) {
	response = &ValidateInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
