package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOrganizationChaincodes invokes the baas.DescribeOrganizationChaincodes API synchronously
// api document: https://help.aliyun.com/api/baas/describeorganizationchaincodes.html
func (client *Client) DescribeOrganizationChaincodes(request *DescribeOrganizationChaincodesRequest) (response *DescribeOrganizationChaincodesResponse, err error) {
	response = CreateDescribeOrganizationChaincodesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOrganizationChaincodesWithChan invokes the baas.DescribeOrganizationChaincodes API asynchronously
// api document: https://help.aliyun.com/api/baas/describeorganizationchaincodes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOrganizationChaincodesWithChan(request *DescribeOrganizationChaincodesRequest) (<-chan *DescribeOrganizationChaincodesResponse, <-chan error) {
	responseChan := make(chan *DescribeOrganizationChaincodesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOrganizationChaincodes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOrganizationChaincodesWithCallback invokes the baas.DescribeOrganizationChaincodes API asynchronously
// api document: https://help.aliyun.com/api/baas/describeorganizationchaincodes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOrganizationChaincodesWithCallback(request *DescribeOrganizationChaincodesRequest, callback func(response *DescribeOrganizationChaincodesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOrganizationChaincodesResponse
		var err error
		defer close(result)
		response, err = client.DescribeOrganizationChaincodes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOrganizationChaincodesRequest is the request struct for api DescribeOrganizationChaincodes
type DescribeOrganizationChaincodesRequest struct {
	*requests.RpcRequest
	OrganizationId string `position:"Body" name:"OrganizationId"`
	Location       string `position:"Body" name:"Location"`
}

// DescribeOrganizationChaincodesResponse is the response struct for api DescribeOrganizationChaincodes
type DescribeOrganizationChaincodesResponse struct {
	*responses.BaseResponse
	RequestId string                  `json:"RequestId" xml:"RequestId"`
	Success   bool                    `json:"Success" xml:"Success"`
	ErrorCode int                     `json:"ErrorCode" xml:"ErrorCode"`
	Result    []OrganizationChaincode `json:"Result" xml:"Result"`
}

// CreateDescribeOrganizationChaincodesRequest creates a request to invoke DescribeOrganizationChaincodes API
func CreateDescribeOrganizationChaincodesRequest() (request *DescribeOrganizationChaincodesRequest) {
	request = &DescribeOrganizationChaincodesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribeOrganizationChaincodes", "", "")
	return
}

// CreateDescribeOrganizationChaincodesResponse creates a response to parse from DescribeOrganizationChaincodes response
func CreateDescribeOrganizationChaincodesResponse() (response *DescribeOrganizationChaincodesResponse) {
	response = &DescribeOrganizationChaincodesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
